
package org.ow2.weblab.core.model;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for operator.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="operator">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="AND"/>
 *     &lt;enumeration value="OR"/>
 *     &lt;enumeration value="NOT"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "operator")
@XmlEnum
public enum Operator {


    /**
     * A Boolean operator that narrows a search by
     * 						requiring all of the search queries to be matched in the results
     * 						retrieved.
     * 
     */
    AND,

    /**
     * A Boolean operator that broadens a search by
     * 						requiring any of the search queries to be matched in the results
     * 						retrieved.
     * 
     */
    OR,

    /**
     * A Boolean operator that narrows a search by
     * 						excluding results of the given queries in the results retrieved.
     * 					
     * 
     */
    NOT;

    public String value() {
        return name();
    }

    public static Operator fromValue(String v) {
        return valueOf(v);
    }

}
