
package org.ow2.weblab.core.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;


/**
 * A PieceOfKnowledge (or PoK) object should be
 * 				understood as the definition provided by the W3C in its resource
 * 				description framework. One can note that we involve the RDF
 * 				methodology concepts and design formalism which should not be
 * 				misunderstood as the RDF/XML serialisation format. Each PoK is
 * 				composed of a set of RDF statements composed of a set of triple:
 * 				subject, property and object. Thus any description can be applied on
 * 				any resource as soon as the property and object element refer to a
 * 				consistent vocabulary in a certain domain. This vocabulary could be
 * 				expressed in accordance to a specified ontology. However, one of the
 * 				project's guidelines is extensibility, thus PieceOfKnowledge should
 * 				be extendable using any OWLS or RDFS. The set of triple statements
 * 				described a resource will be contained in the PieceOfKnowledge
 * 				object serialised in the RDF/XML format. Since an PoK is a resource,
 * 				it can also contain Annotations. The contained statements can be
 * 				seen as meta-Annotations describing, for example, how and when the
 * 				first level of annotations has been created (which service with what
 * 				resource or configuration). Data Exchange Model for WebLab platform
 * 				provided by CASSIDIAN - Version 1.2 - 2010/08
 * 
 * <p>Java class for PieceOfKnowledge complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="PieceOfKnowledge">
 *   &lt;complexContent>
 *     &lt;extension base="{http://weblab.ow2.org/core/1.2/model#}Resource">
 *       &lt;sequence>
 *         &lt;element name="data" type="{http://www.w3.org/2001/XMLSchema}anyType"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PieceOfKnowledge", propOrder = {
    "data"
})
@XmlSeeAlso({
    Annotation.class
})
public class PieceOfKnowledge
    extends Resource
    implements Serializable
{

    private final static long serialVersionUID = 12L;
    @XmlElement(required = true)
    protected Object data;

    /**
     * Gets the value of the data property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public Object getData() {
        return data;
    }

    /**
     * Sets the value of the data property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    public void setData(Object value) {
        this.data = value;
    }

}
