
package org.ow2.weblab.core.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;


/**
 * A query is a resource which contains request
 * 				data. This data describe a each specific specialisation of query, in
 * 				a specific format. The query object is then abstract and several
 * 				specialisations will be used to describe any type of queries. A
 * 				proposal is to adopt common standards in order to provide consistent
 * 				definitions over all the WebLab platform. XQuery and SPARQL format
 * 				has been identified as a promising candidate respectively for
 * 				structured and semantic search.As a resource, a query could be
 * 				annotated to provide, for example, meta-informations its creation
 * 				date, its author, etc. Data Exchange Model for WebLab platform
 * 				provided by CASSIDIAN Query package - Version 1.2 - 2010/08
 * 			
 * 
 * <p>Java class for Query complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Query">
 *   &lt;complexContent>
 *     &lt;extension base="{http://weblab.ow2.org/core/1.2/model#}Resource">
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Query")
@XmlSeeAlso({
    ComposedQuery.class,
    ElementaryQuery.class
})
public abstract class Query
    extends Resource
    implements Serializable
{

    private final static long serialVersionUID = 12L;

}
