
package org.ow2.weblab.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;


/**
 * A resource refers to any object that could be
 * 				manipulated in the WebLab platform. It will be identified by a
 * 				unique URI. \n It can hold some annotations that will describe the
 * 				resource itself at a semantic level. It can also hold some low level
 * 				descriptors that are describing itself at a lower level. It will be
 * 				a common interface which will be inherited by almost all WebLab
 * 				objects. Any reference to a resource will use its URI. Data Exchange
 * 				Model for WebLab platform provided by CASSIDIAN Core package - Version
 * 				1.2 - 2010/08
 * 
 * <p>Java class for Resource complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Resource">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="annotation" type="{http://weblab.ow2.org/core/1.2/model#}Annotation" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="descriptor" type="{http://weblab.ow2.org/core/1.2/model#}LowLevelDescriptor" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="uri" use="required" type="{http://www.w3.org/2001/XMLSchema}anyURI" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Resource", propOrder = {
    "annotation",
    "descriptor"
})
@XmlSeeAlso({
    ResultSet.class,
    ComposedResource.class,
    PieceOfKnowledge.class,
    LowLevelDescriptor.class,
    MediaUnit.class,
    Query.class
})
public class Resource
    implements Serializable
{

    private final static long serialVersionUID = 12L;
    protected List<Annotation> annotation;
    protected List<LowLevelDescriptor> descriptor;
    @XmlAttribute(required = true)
    @XmlSchemaType(name = "anyURI")
    protected String uri;

    /**
     * Gets the value of the annotation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the annotation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAnnotation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Annotation }
     * 
     * 
     */
    public List<Annotation> getAnnotation() {
        if (annotation == null) {
            annotation = new ArrayList<Annotation>();
        }
        return this.annotation;
    }

    public boolean isSetAnnotation() {
        return ((this.annotation!= null)&&(!this.annotation.isEmpty()));
    }

    public void unsetAnnotation() {
        this.annotation = null;
    }

    /**
     * Gets the value of the descriptor property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the descriptor property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescriptor().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LowLevelDescriptor }
     * 
     * 
     */
    public List<LowLevelDescriptor> getDescriptor() {
        if (descriptor == null) {
            descriptor = new ArrayList<LowLevelDescriptor>();
        }
        return this.descriptor;
    }

    public boolean isSetDescriptor() {
        return ((this.descriptor!= null)&&(!this.descriptor.isEmpty()));
    }

    public void unsetDescriptor() {
        this.descriptor = null;
    }

    /**
     * Gets the value of the uri property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUri() {
        return uri;
    }

    /**
     * Sets the value of the uri property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUri(String value) {
        this.uri = value;
    }

}
