
package org.ow2.weblab.core.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;


/**
 * A segment is a resource that should not have any
 * 				content and which is linked to a media unit. It allows describing
 * 				the content of a unit with at much finer level. The segment could be
 * 				annotated as it inherits from resource. It provides a way to assign
 * 				annotation on a very high level of structure description without
 * 				adding weight to the model by transporting the data. The object
 * 				willcontain positioning information which allows localising itself
 * 				in the parent unit. As media type are very different the position
 * 				itself will be specialised to them andthus provide localisation
 * 				adapted to the media. This object cannot be used itself (this is an
 * 				abstract object). However, some implementations with real
 * 				capabilities must be developed in order to match every media class.
 * 				A class of media stands here for a list of segments which can be
 * 				localised in the same manner. For example, a text section can be
 * 				described in the same way as a video segment: both of them need a
 * 				start and stop index, one referring to character index and the other
 * 				to a temporal reference. Data Exchange Model for WebLab platform
 * 				provided by CASSIDIAN - Version 1.2 - 2010/08
 * 
 * <p>Java class for Segment complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Segment">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;attribute name="uri" use="required" type="{http://www.w3.org/2001/XMLSchema}anyURI" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Segment")
@XmlSeeAlso({
    SpatialSegment.class,
    LinearSegment.class,
    TemporalSegment.class
})
public abstract class Segment
    implements Serializable
{

    private final static long serialVersionUID = 12L;
    @XmlAttribute(required = true)
    @XmlSchemaType(name = "anyURI")
    protected String uri;

    /**
     * Gets the value of the uri property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUri() {
        return uri;
    }

    /**
     * Sets the value of the uri property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUri(String value) {
        this.uri = value;
    }

}
