
package org.ow2.weblab.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * A spatial segment is aiming to localise any
 * 				meaningful content in a spatial document. For example, one can think
 * 				to a picture showing some people. Specific segment can be localised
 * 				with coordinate descriptors defining the silhouettes of each person
 * 				in the picture. Then specific annotation can be applied to each
 * 				segment (i.e. to declare that those are human beings). It is the
 * 				kind of segment that may be used for image and video unit. When
 * 				there are only two coordinates given associated to the
 * 				spatialSegment, it means that the shape is a disk. The first
 * 				coordinate is the centre and the second one in one point of the
 * 				circle. Otherwise, coordinates are describing a closed shape since
 * 				the last coordinate of the list will be linked to the first one.
 * 				Data Exchange Model for WebLabplatform provided by CASSIDIAN - Version
 * 				1.2 - 2010/08
 * 
 * <p>Java class for SpatialSegment complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="SpatialSegment">
 *   &lt;complexContent>
 *     &lt;extension base="{http://weblab.ow2.org/core/1.2/model#}Segment">
 *       &lt;sequence>
 *         &lt;element name="coordinate" type="{http://weblab.ow2.org/core/1.2/model#}Coordinate" maxOccurs="unbounded" minOccurs="2"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SpatialSegment", propOrder = {
    "coordinate"
})
public class SpatialSegment
    extends Segment
    implements Serializable
{

    private final static long serialVersionUID = 12L;
    @XmlElement(required = true)
    protected List<Coordinate> coordinate;

    /**
     * Gets the value of the coordinate property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the coordinate property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCoordinate().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Coordinate }
     * 
     * 
     */
    public List<Coordinate> getCoordinate() {
        if (coordinate == null) {
            coordinate = new ArrayList<Coordinate>();
        }
        return this.coordinate;
    }

}
