
package org.ow2.weblab.core.model;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;


/**
 * A video unit describes a dynamic visual content
 * 				out of media document. As a resource it can be annotated to describe
 * 				the content. It can also be described using low level descriptors.
 * 				The original content may be in the content field or a reference
 * 				using annotation should be made to the content. Data Exchange Model
 * 				for WebLab platform provided by CASSIDIAN - Version 1.2 - 2010/08
 * 			
 * 
 * <p>Java class for Video complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Video">
 *   &lt;complexContent>
 *     &lt;extension base="{http://weblab.ow2.org/core/1.2/model#}MediaUnit">
 *       &lt;sequence>
 *         &lt;element name="content" type="{http://www.w3.org/2001/XMLSchema}base64Binary" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Video", propOrder = {
    "content"
})
public class Video
    extends MediaUnit
    implements Serializable
{

    private final static long serialVersionUID = 12L;
    protected byte[] content;

    /**
     * Gets the value of the content property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    public byte[] getContent() {
        return content;
    }

    /**
     * Sets the value of the content property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setContent(byte[] value) {
        this.content = ((byte[]) value);
    }

    public boolean isSetContent() {
        return (this.content!= null);
    }

}
