
package org.ow2.weblab.core.services;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;


/**
 * Interface of a analyser. It only contains a method to enable business analyser to process resources, given a usage context. Most of the time this analysis turn out to be the addition
 * 			of annotations to the Resource.
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.3-b02-
 * Generated source version: 2.1
 * 
 */
@WebService(name = "Analyser", targetNamespace = "http://weblab.ow2.org/core/1.2/services/analyser")
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
@XmlSeeAlso({
    org.ow2.weblab.core.services.reportprovider.ObjectFactory.class,
    org.ow2.weblab.core.services.sourcereader.ObjectFactory.class,
    org.ow2.weblab.core.services.trainable.ObjectFactory.class,
    org.ow2.weblab.core.services.indexer.ObjectFactory.class,
    org.ow2.weblab.core.services.configurable.ObjectFactory.class,
    org.ow2.weblab.core.services.analyser.ObjectFactory.class,
    org.ow2.weblab.core.model.ObjectFactory.class,
    org.ow2.weblab.core.services.resourcecontainer.ObjectFactory.class,
    org.ow2.weblab.core.services.exception.ObjectFactory.class,
    org.ow2.weblab.core.services.queuemanager.ObjectFactory.class,
    org.ow2.weblab.core.services.searcher.ObjectFactory.class
})
public interface Analyser {


    /**
     * Ask to the service to process with its business method.
     * 
     * @param args
     * @return
     *     returns org.ow2.weblab.core.services.analyser.ProcessReturn
     * @throws AccessDeniedException
     * @throws ContentNotAvailableException
     * @throws UnsupportedRequestException
     * @throws ServiceNotConfiguredException
     * @throws UnexpectedException
     * @throws InvalidParameterException
     * @throws InsufficientResourcesException
     */
    @WebMethod(action = "process")
    @WebResult(name = "processReturn", targetNamespace = "http://weblab.ow2.org/core/1.2/services/analyser", partName = "return")
    public ProcessReturn process(
        @WebParam(name = "processArgs", targetNamespace = "http://weblab.ow2.org/core/1.2/services/analyser", partName = "args")
        ProcessArgs args)
        throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException
    ;

}
