
package org.ow2.weblab.core.services;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.ow2.weblab.core.services.configurable.ConfigureArgs;
import org.ow2.weblab.core.services.configurable.ConfigureReturn;
import org.ow2.weblab.core.services.configurable.ResetConfigurationArgs;
import org.ow2.weblab.core.services.configurable.ResetConfigurationReturn;


/**
 * The configurable interface will be used to define services of which behavior depends on a usage context, this context corresponding to a particular set of parameters. In some services, the
 * 			configurable interface is optional and won't be inevitably realised in every implementations.
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.3-b02-
 * Generated source version: 2.1
 * 
 */
@WebService(name = "Configurable", targetNamespace = "http://weblab.ow2.org/core/1.2/services/configurable")
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
@XmlSeeAlso({
    org.ow2.weblab.core.services.reportprovider.ObjectFactory.class,
    org.ow2.weblab.core.services.sourcereader.ObjectFactory.class,
    org.ow2.weblab.core.services.trainable.ObjectFactory.class,
    org.ow2.weblab.core.services.indexer.ObjectFactory.class,
    org.ow2.weblab.core.services.configurable.ObjectFactory.class,
    org.ow2.weblab.core.services.analyser.ObjectFactory.class,
    org.ow2.weblab.core.model.ObjectFactory.class,
    org.ow2.weblab.core.services.resourcecontainer.ObjectFactory.class,
    org.ow2.weblab.core.services.exception.ObjectFactory.class,
    org.ow2.weblab.core.services.queuemanager.ObjectFactory.class,
    org.ow2.weblab.core.services.searcher.ObjectFactory.class
})
public interface Configurable {


    /**
     * Configure the service.
     * 
     * @param args
     * @return
     *     returns org.ow2.weblab.core.services.configurable.ConfigureReturn
     * @throws AccessDeniedException
     * @throws ContentNotAvailableException
     * @throws UnsupportedRequestException
     * @throws UnexpectedException
     * @throws InvalidParameterException
     * @throws InsufficientResourcesException
     */
    @WebMethod(action = "configure")
    @WebResult(name = "configureReturn", targetNamespace = "http://weblab.ow2.org/core/1.2/services/configurable", partName = "return")
    public ConfigureReturn configure(
        @WebParam(name = "configureArgs", targetNamespace = "http://weblab.ow2.org/core/1.2/services/configurable", partName = "args")
        ConfigureArgs args)
        throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, UnexpectedException, UnsupportedRequestException
    ;

    /**
     * Reset the configuration of the service to the default one.
     * 
     * @param args
     * @return
     *     returns org.ow2.weblab.core.services.configurable.ResetConfigurationReturn
     * @throws AccessDeniedException
     * @throws ContentNotAvailableException
     * @throws UnsupportedRequestException
     * @throws UnexpectedException
     * @throws InvalidParameterException
     * @throws InsufficientResourcesException
     */
    @WebMethod(action = "resetConfiguration")
    @WebResult(name = "resetConfigurationReturn", targetNamespace = "http://weblab.ow2.org/core/1.2/services/configurable", partName = "return")
    public ResetConfigurationReturn resetConfiguration(
        @WebParam(name = "resetConfigurationArgs", targetNamespace = "http://weblab.ow2.org/core/1.2/services/configurable", partName = "args")
        ResetConfigurationArgs args)
        throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, UnexpectedException, UnsupportedRequestException
    ;

}
