
package org.ow2.weblab.core.services;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.ow2.weblab.core.services.indexer.IndexArgs;
import org.ow2.weblab.core.services.indexer.IndexReturn;


/**
 * The indexer interface will be used to define resources indexing services. This interface will be realised only by services enabling on-line indexing.
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.3-b02-
 * Generated source version: 2.1
 * 
 */
@WebService(name = "Indexer", targetNamespace = "http://weblab.ow2.org/core/1.2/services/indexer")
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
@XmlSeeAlso({
    org.ow2.weblab.core.services.reportprovider.ObjectFactory.class,
    org.ow2.weblab.core.services.sourcereader.ObjectFactory.class,
    org.ow2.weblab.core.services.trainable.ObjectFactory.class,
    org.ow2.weblab.core.services.indexer.ObjectFactory.class,
    org.ow2.weblab.core.services.configurable.ObjectFactory.class,
    org.ow2.weblab.core.services.analyser.ObjectFactory.class,
    org.ow2.weblab.core.model.ObjectFactory.class,
    org.ow2.weblab.core.services.resourcecontainer.ObjectFactory.class,
    org.ow2.weblab.core.services.exception.ObjectFactory.class,
    org.ow2.weblab.core.services.queuemanager.ObjectFactory.class,
    org.ow2.weblab.core.services.searcher.ObjectFactory.class
})
public interface Indexer {


    /**
     * Index the given resource.
     * 
     * @param args
     * @return
     *     returns org.ow2.weblab.core.services.indexer.IndexReturn
     * @throws AccessDeniedException
     * @throws ContentNotAvailableException
     * @throws UnsupportedRequestException
     * @throws UnexpectedException
     * @throws ServiceNotConfiguredException
     * @throws InvalidParameterException
     * @throws InsufficientResourcesException
     */
    @WebMethod(action = "index")
    @WebResult(name = "indexReturn", targetNamespace = "http://weblab.ow2.org/core/1.2/services/indexer", partName = "return")
    public IndexReturn index(
        @WebParam(name = "indexArgs", targetNamespace = "http://weblab.ow2.org/core/1.2/services/indexer", partName = "args")
        IndexArgs args)
        throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException
    ;

}
