
package org.ow2.weblab.core.services;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.ow2.weblab.core.services.reportprovider.AddInformationArgs;
import org.ow2.weblab.core.services.reportprovider.AddInformationReturn;
import org.ow2.weblab.core.services.reportprovider.BuildReportArgs;
import org.ow2.weblab.core.services.reportprovider.BuildReportReturn;


/**
 * 
 * 			The report provider interface will be used to define services that can produce reports. These services will be, in most of the cases, parametrisable: they will realised configurable
 * 			interface. This will enable the reporting to be dependent of the usage context.
 * 		
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.3-b02-
 * Generated source version: 2.1
 * 
 */
@WebService(name = "ReportProvider", targetNamespace = "http://weblab.ow2.org/core/1.2/services/reportprovider")
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
@XmlSeeAlso({
    org.ow2.weblab.core.services.reportprovider.ObjectFactory.class,
    org.ow2.weblab.core.services.sourcereader.ObjectFactory.class,
    org.ow2.weblab.core.services.trainable.ObjectFactory.class,
    org.ow2.weblab.core.services.indexer.ObjectFactory.class,
    org.ow2.weblab.core.services.configurable.ObjectFactory.class,
    org.ow2.weblab.core.services.analyser.ObjectFactory.class,
    org.ow2.weblab.core.model.ObjectFactory.class,
    org.ow2.weblab.core.services.resourcecontainer.ObjectFactory.class,
    org.ow2.weblab.core.services.exception.ObjectFactory.class,
    org.ow2.weblab.core.services.queuemanager.ObjectFactory.class,
    org.ow2.weblab.core.services.searcher.ObjectFactory.class
})
public interface ReportProvider {


    /**
     * Add a resource to be reported given a usage context.
     * 
     * @param args
     * @return
     *     returns org.ow2.weblab.core.services.reportprovider.AddInformationReturn
     * @throws AccessDeniedException
     * @throws ContentNotAvailableException
     * @throws UnsupportedRequestException
     * @throws ServiceNotConfiguredException
     * @throws UnexpectedException
     * @throws InvalidParameterException
     * @throws InsufficientResourcesException
     */
    @WebMethod(action = "addInformation")
    @WebResult(name = "addInformationReturn", targetNamespace = "http://weblab.ow2.org/core/1.2/services/reportprovider", partName = "return")
    public AddInformationReturn addInformation(
        @WebParam(name = "addInformationArgs", targetNamespace = "http://weblab.ow2.org/core/1.2/services/reportprovider", partName = "args")
        AddInformationArgs args)
        throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException
    ;

    /**
     * Build the report on the previously added resources, given a usage context.
     * 
     * @param args
     * @return
     *     returns org.ow2.weblab.core.services.reportprovider.BuildReportReturn
     * @throws AccessDeniedException
     * @throws ContentNotAvailableException
     * @throws UnsupportedRequestException
     * @throws ServiceNotConfiguredException
     * @throws UnexpectedException
     * @throws InvalidParameterException
     * @throws InsufficientResourcesException
     */
    @WebMethod(action = "buildReport")
    @WebResult(name = "buildReportReturn", targetNamespace = "http://weblab.ow2.org/core/1.2/services/reportprovider", partName = "return")
    public BuildReportReturn buildReport(
        @WebParam(name = "buildReportArgs", targetNamespace = "http://weblab.ow2.org/core/1.2/services/reportprovider", partName = "args")
        BuildReportArgs args)
        throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException
    ;

}
