
package org.ow2.weblab.core.services;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.ow2.weblab.core.services.resourcecontainer.LoadResourceArgs;
import org.ow2.weblab.core.services.resourcecontainer.LoadResourceReturn;
import org.ow2.weblab.core.services.resourcecontainer.SaveResourceArgs;
import org.ow2.weblab.core.services.resourcecontainer.SaveResourceReturn;


/**
 * The resource container interface will be used to define services that can manage the resources persistence.
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.3-b02-
 * Generated source version: 2.1
 * 
 */
@WebService(name = "ResourceContainer", targetNamespace = "http://weblab.ow2.org/core/1.2/services/resourcecontainer")
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
@XmlSeeAlso({
    org.ow2.weblab.core.services.reportprovider.ObjectFactory.class,
    org.ow2.weblab.core.services.sourcereader.ObjectFactory.class,
    org.ow2.weblab.core.services.trainable.ObjectFactory.class,
    org.ow2.weblab.core.services.indexer.ObjectFactory.class,
    org.ow2.weblab.core.services.configurable.ObjectFactory.class,
    org.ow2.weblab.core.services.analyser.ObjectFactory.class,
    org.ow2.weblab.core.model.ObjectFactory.class,
    org.ow2.weblab.core.services.resourcecontainer.ObjectFactory.class,
    org.ow2.weblab.core.services.exception.ObjectFactory.class,
    org.ow2.weblab.core.services.queuemanager.ObjectFactory.class,
    org.ow2.weblab.core.services.searcher.ObjectFactory.class
})
public interface ResourceContainer {


    /**
     * Save a resource in the repository.
     * 
     * @param args
     * @return
     *     returns org.ow2.weblab.core.services.resourcecontainer.SaveResourceReturn
     * @throws AccessDeniedException
     * @throws ContentNotAvailableException
     * @throws UnsupportedRequestException
     * @throws UnexpectedException
     * @throws ServiceNotConfiguredException
     * @throws InvalidParameterException
     * @throws InsufficientResourcesException
     */
    @WebMethod(action = "saveResource")
    @WebResult(name = "saveResourceReturn", targetNamespace = "http://weblab.ow2.org/core/1.2/services/resourcecontainer", partName = "return")
    public SaveResourceReturn saveResource(
        @WebParam(name = "saveResourceArgs", targetNamespace = "http://weblab.ow2.org/core/1.2/services/resourcecontainer", partName = "args")
        SaveResourceArgs args)
        throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException
    ;

    /**
     * Load a resource stored in the repository.
     * 
     * @param args
     * @return
     *     returns org.ow2.weblab.core.services.resourcecontainer.LoadResourceReturn
     * @throws AccessDeniedException
     * @throws ContentNotAvailableException
     * @throws UnsupportedRequestException
     * @throws UnexpectedException
     * @throws ServiceNotConfiguredException
     * @throws InvalidParameterException
     * @throws InsufficientResourcesException
     */
    @WebMethod(action = "loadResource")
    @WebResult(name = "loadResourceReturn", targetNamespace = "http://weblab.ow2.org/core/1.2/services/resourcecontainer", partName = "return")
    public LoadResourceReturn loadResource(
        @WebParam(name = "loadResourceArgs", targetNamespace = "http://weblab.ow2.org/core/1.2/services/resourcecontainer", partName = "args")
        LoadResourceArgs args)
        throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException
    ;

}
