
package org.ow2.weblab.core.services;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.ow2.weblab.core.services.searcher.SearchArgs;
import org.ow2.weblab.core.services.searcher.SearchReturn;


/**
 * The searcher interface will be used to define resource searching services.
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.3-b02-
 * Generated source version: 2.1
 * 
 */
@WebService(name = "Searcher", targetNamespace = "http://weblab.ow2.org/core/1.2/services/searcher")
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
@XmlSeeAlso({
    org.ow2.weblab.core.services.reportprovider.ObjectFactory.class,
    org.ow2.weblab.core.services.sourcereader.ObjectFactory.class,
    org.ow2.weblab.core.services.trainable.ObjectFactory.class,
    org.ow2.weblab.core.services.indexer.ObjectFactory.class,
    org.ow2.weblab.core.services.configurable.ObjectFactory.class,
    org.ow2.weblab.core.services.analyser.ObjectFactory.class,
    org.ow2.weblab.core.model.ObjectFactory.class,
    org.ow2.weblab.core.services.resourcecontainer.ObjectFactory.class,
    org.ow2.weblab.core.services.exception.ObjectFactory.class,
    org.ow2.weblab.core.services.queuemanager.ObjectFactory.class,
    org.ow2.weblab.core.services.searcher.ObjectFactory.class
})
public interface Searcher {


    /**
     * Search using the given query.
     * 
     * @param args
     * @return
     *     returns org.ow2.weblab.core.services.searcher.SearchReturn
     * @throws AccessDeniedException
     * @throws ContentNotAvailableException
     * @throws UnsupportedRequestException
     * @throws UnexpectedException
     * @throws ServiceNotConfiguredException
     * @throws InvalidParameterException
     * @throws InsufficientResourcesException
     */
    @WebMethod(action = "search")
    @WebResult(name = "searchReturn", targetNamespace = "http://weblab.ow2.org/core/1.2/services/searcher", partName = "return")
    public SearchReturn search(
        @WebParam(name = "searchArgs", targetNamespace = "http://weblab.ow2.org/core/1.2/services/searcher", partName = "args")
        SearchArgs args)
        throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException
    ;

}
