
package org.ow2.weblab.core.services;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.ow2.weblab.core.services.trainable.AddTrainResourceArgs;
import org.ow2.weblab.core.services.trainable.AddTrainResourceReturn;
import org.ow2.weblab.core.services.trainable.ResetTrainedModelArgs;
import org.ow2.weblab.core.services.trainable.ResetTrainedModelReturn;
import org.ow2.weblab.core.services.trainable.TrainArgs;
import org.ow2.weblab.core.services.trainable.TrainReturn;


/**
 * The trainable interface will be used to define services of which behavior change dynamically by machine learning. This interface should enable to provide resources to the services.
 * 			These
 * 			resources will be used to learned its behavior model. In some services, this model could be dependent of a usage context.
 * 
 * 			The trainable interface will be realised only by services enabling the
 * 			machine learning procedure on-line (in some case, this step will be done off-line).
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.3-b02-
 * Generated source version: 2.1
 * 
 */
@WebService(name = "Trainable", targetNamespace = "http://weblab.ow2.org/core/1.2/services/trainable")
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
@XmlSeeAlso({
    org.ow2.weblab.core.services.reportprovider.ObjectFactory.class,
    org.ow2.weblab.core.services.sourcereader.ObjectFactory.class,
    org.ow2.weblab.core.services.trainable.ObjectFactory.class,
    org.ow2.weblab.core.services.indexer.ObjectFactory.class,
    org.ow2.weblab.core.services.configurable.ObjectFactory.class,
    org.ow2.weblab.core.services.analyser.ObjectFactory.class,
    org.ow2.weblab.core.model.ObjectFactory.class,
    org.ow2.weblab.core.services.resourcecontainer.ObjectFactory.class,
    org.ow2.weblab.core.services.exception.ObjectFactory.class,
    org.ow2.weblab.core.services.queuemanager.ObjectFactory.class,
    org.ow2.weblab.core.services.searcher.ObjectFactory.class
})
public interface Trainable {


    /**
     * Add the resource to the training set, given a usage context.
     * 
     * @param args
     * @return
     *     returns org.ow2.weblab.core.services.trainable.AddTrainResourceReturn
     * @throws AccessDeniedException
     * @throws ContentNotAvailableException
     * @throws UnsupportedRequestException
     * @throws ServiceNotConfiguredException
     * @throws UnexpectedException
     * @throws InvalidParameterException
     * @throws InsufficientResourcesException
     */
    @WebMethod(action = "addTrainResource")
    @WebResult(name = "addTrainResourceReturn", targetNamespace = "http://weblab.ow2.org/core/1.2/services/trainable", partName = "return")
    public AddTrainResourceReturn addTrainResource(
        @WebParam(name = "addTrainResourceArgs", targetNamespace = "http://weblab.ow2.org/core/1.2/services/trainable", partName = "args")
        AddTrainResourceArgs args)
        throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException
    ;

    /**
     * Train using the resources previously added to the training set identified by the usage context.
     * 
     * @param args
     * @return
     *     returns org.ow2.weblab.core.services.trainable.TrainReturn
     * @throws AccessDeniedException
     * @throws ContentNotAvailableException
     * @throws UnsupportedRequestException
     * @throws ServiceNotConfiguredException
     * @throws UnexpectedException
     * @throws InvalidParameterException
     * @throws InsufficientResourcesException
     */
    @WebMethod(action = "train")
    @WebResult(name = "trainReturn", targetNamespace = "http://weblab.ow2.org/core/1.2/services/trainable", partName = "return")
    public TrainReturn train(
        @WebParam(name = "trainArgs", targetNamespace = "http://weblab.ow2.org/core/1.2/services/trainable", partName = "args")
        TrainArgs args)
        throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException
    ;

    /**
     * Empty training set identified by the usage context.
     * 
     * @param args
     * @return
     *     returns org.ow2.weblab.core.services.trainable.ResetTrainedModelReturn
     * @throws AccessDeniedException
     * @throws ContentNotAvailableException
     * @throws UnsupportedRequestException
     * @throws UnexpectedException
     * @throws ServiceNotConfiguredException
     * @throws InvalidParameterException
     * @throws InsufficientResourcesException
     */
    @WebMethod(action = "resetTrainedModel")
    @WebResult(name = "resetTrainedModelReturn", targetNamespace = "http://weblab.ow2.org/core/1.2/services/trainable", partName = "return")
    public ResetTrainedModelReturn resetTrainedModel(
        @WebParam(name = "resetTrainedModelArgs", targetNamespace = "http://weblab.ow2.org/core/1.2/services/trainable", partName = "args")
        ResetTrainedModelArgs args)
        throws AccessDeniedException, ContentNotAvailableException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException
    ;

}
