
package org.ow2.weblab.core.services.searcher;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.ow2.weblab.core.model.Query;


/**
 * Wrapper containing a query to search, and an
 * 				optional context and two integers the offset and limit values.
 * 
 * 				Note
 * 				that's, when these parameters exist and the text of the query
 * 				contains equivalent parameters in its syntax, the offset and limit
 * 				values to be used are depending of the implementation.
 * 			
 * 
 * <p>Java class for searchArgs complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="searchArgs">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="usageContext" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="query" type="{http://weblab.ow2.org/core/1.2/model#}Query"/>
 *         &lt;element name="offset" type="{http://www.w3.org/2001/XMLSchema}int" minOccurs="0"/>
 *         &lt;element name="limit" type="{http://www.w3.org/2001/XMLSchema}int" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "searchArgs", propOrder = {
    "usageContext",
    "query",
    "offset",
    "limit"
})
public class SearchArgs
    implements Serializable
{

    private final static long serialVersionUID = 12L;
    protected String usageContext;
    @XmlElement(required = true)
    protected Query query;
    @XmlElement(defaultValue = "0")
    protected Integer offset;
    @XmlElement(defaultValue = "20")
    protected Integer limit;

    /**
     * Gets the value of the usageContext property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUsageContext() {
        return usageContext;
    }

    /**
     * Sets the value of the usageContext property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUsageContext(String value) {
        this.usageContext = value;
    }

    public boolean isSetUsageContext() {
        return (this.usageContext!= null);
    }

    /**
     * Gets the value of the query property.
     * 
     * @return
     *     possible object is
     *     {@link Query }
     *     
     */
    public Query getQuery() {
        return query;
    }

    /**
     * Sets the value of the query property.
     * 
     * @param value
     *     allowed object is
     *     {@link Query }
     *     
     */
    public void setQuery(Query value) {
        this.query = value;
    }

    /**
     * Gets the value of the offset property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getOffset() {
        return offset;
    }

    /**
     * Sets the value of the offset property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setOffset(Integer value) {
        this.offset = value;
    }

    public boolean isSetOffset() {
        return (this.offset!= null);
    }

    /**
     * Gets the value of the limit property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getLimit() {
        return limit;
    }

    /**
     * Sets the value of the limit property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setLimit(Integer value) {
        this.limit = value;
    }

    public boolean isSetLimit() {
        return (this.limit!= null);
    }

}
