package org.ow2.weblab.core.helper.impl;

import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.util.PoKUtil;
import org.ow2.weblab.core.model.PieceOfKnowledge;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;

public class AdvancedLinkedHashMap implements IPredicateValuePairs{

	private LinkedHashMap<String, List<WTriple>> map = new LinkedHashMap<String, List<WTriple>>();
	private Statements wtm;
	private String temporaryURI = null;;
	
	protected AdvancedLinkedHashMap(Statements wtm, String uri){
		this.wtm = wtm;
		this.temporaryURI = uri;
	}
	
	public AdvancedLinkedHashMap(Statements wtm){
		this.wtm = wtm;
	}
		
	public LinkedHashMap<String, List<WTriple>> getMap() {
		return map;
	}

	public void setMap(LinkedHashMap<String, List<WTriple>> map) {
		this.map = map;
	}

	@Override
	public Object getValue(String predicate) {
		List<WTriple> wts = map.get(predicate);
		if (wts == null || wts.isEmpty()){
			return null;
		}
		if (wts.size() == 1){
			return wts.get(0).getObject();
		}
		List<Object> lo = new LinkedList<Object>();
		for(WTriple wt:wts){
			lo.add(wt.getObject());
		}
		return lo;
	}

	public void writeStatements(String[] predicates, String[] objects, PieceOfKnowledge pokover) throws WebLabCheckedException {
		if (predicates == null || objects == null || 
			predicates.length == 0 || objects.length == 0 || 
			predicates.length != objects.length){
			throw new WebLabCheckedException("Unable to write predicate and object.");
		}
		
		Collection<WTriple> wls = getStatements();
		if (wls.isEmpty()){
			if (temporaryURI != null){
				wls = new LinkedList<WTriple>();
				// Create a dummy WTriple
				wls.add(new WTriple(temporaryURI,"none","none",null,null,pokover));
				temporaryURI = null;
			}else{
				throw new WebLabCheckedException("Unable to write predicate and object because there is no previous element.");
			}
		}
		
		WTriple wt = wls.iterator().next();
		
		if (pokover == null){
			pokover = wt.getAnnotation();
		}
		
		List<WTriple> list = new LinkedList<WTriple>();
		
		String uri = wt.getSubject();
		for(int i=0;i<predicates.length;i++){
			WTriple nw = new WTriple(uri,predicates[i],objects[i],wt.getSubjectResource(),wtm.getResource(objects[i]),wt.getAnnotatedOn());
			nw.setAnnotation(pokover);
			put(nw);
			list.add(nw);
		}
		
		write(list, pokover, wtm, new HashMap<String, String>());
		
	}
	
	protected static void write(List<WTriple> list, 
								PieceOfKnowledge pokover, 
								Statements wtm,
								HashMap<String,String> mapping) 
		throws WebLabCheckedException{
		
		Object data = pokover.getData();
		
		Model model;
		if (data == null || !(data instanceof org.w3c.dom.Node)){
			model = ModelFactory.createDefaultModel();
		}else{
			model = TripleSelectors.loadModel((org.w3c.dom.Node)data);
		}
		
		for(WTriple wt:list){
			boolean res = false;
			String uri = wt.getSubject();
			String predicate = wt.getPredicate();
			String object = wt.getObject();
			if (uri == null || predicate ==null || object == null){
				throw new WebLabCheckedException("Unable to write predicate and object : "+predicate+" : "+object+" on "+uri);
			}
			for(String namespace:wtm.namespaces){
				if (object.startsWith(namespace)){
					res = true;
					break;
				}
			}
			
			Triple t = wt.getTriple();
			if (t != null){
				Node n = t.getObject();
				if (n != null && !n.isLiteral()){
						res = true;
				}
			}				
			
			String muri = mapping.get(uri);
			String mobject = mapping.get(object);
			muri = muri == null?uri:muri;
			mobject = mobject == null?object:mobject;
			
			Resource s = model.createResource(muri);
			Property p = model.createProperty(predicate); 
			
			if (res){
				model.createStatement(s, p, mobject);
			}else{

				Statement statement = model.createStatement(s,p, t.getObject().getLiteral().getValue().toString());
				model.add(statement);
			}
		}
		
		StringWriter sw = new StringWriter();
		model.write(sw);
		PoKUtil.setPoKData(pokover, sw.toString());
		model.close();
	}
	
	@Override
	public void writeStatement(String predicate, String object) throws WebLabCheckedException {
		writeStatements(new String[]{predicate}, new String[]{object},null);
	}

	/**
	 * Inner function to add a WTriple
	 * @param wt a WTriple
	 */
	protected void put(WTriple wt) {
		List<WTriple> list = map.get(wt.getPredicate());
		if (list == null){
			list = new LinkedList<WTriple>();
		}
		list.add(wt);
		map.put(wt.getPredicate(),list);
	}
	
	public Set<String> allPredicates(){
		return map.keySet(); 
	}
	
	public Collection<WTriple> getStatements(){
		List<WTriple> list = new LinkedList<WTriple>();
		for(List<WTriple> li:map.values()){
			list.addAll(li);
		}
		return list;
		
	}
	
	public String toString(){
		return map.toString();
	}
}
