/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.helper.impl;

import java.util.LinkedList;
import java.util.List;

import org.ow2.weblab.core.helper.impl.Rule.Domain;

import com.hp.hpl.jena.graph.Triple;


public class Filter {
	protected List<Rule> rules = new LinkedList<Rule>();
	
	/**
	 * Creates a filter.
	 * This filter is an discard all filter.
	 * You must add rules to select which triples are interessting
	 */
	public Filter(){
	}

	/**
	 * Add a filter on an association subject/predicat
	 * @param subject
	 * @param predicat
	 */
	public void addSPFilter(final String subject,final  String predicat){
		rules.add(new Rule(Domain.SUBJECT,subject,Domain.PREDICATE,predicat));
	}
	
	/**
	 * Add a filter on an association subject/object
	 * @param subject
	 * @param object
	 */
	public void addSOFilter(final String subject,final  String object){
		rules.add(new Rule(Domain.SUBJECT,subject,Domain.OBJECT,object));
	}
	
	/**
	 * Add a filter on an association predicat/object
	 * @param predicat
	 * @param object
	 */
	public void addPOFilter(final String predicat, final String object){
		rules.add(new Rule(Domain.PREDICATE,predicat,Domain.OBJECT,object));
	}

	/**
	 * Returns true if the WTriple matches at least 1 rule.
	 * @param wt a WTriple
	 * @return true if the WTriple matches at least 1 rule. 
	 */
	public boolean matches(WTriple wt){
		for(Rule rule:rules){
			if (matches(rule,wt)){
				return true;
			}
		}
		return false;
	}
	
	protected boolean matches(Rule rule, Triple t) {
		return matches(rule, t.getSubject().toString(), 
							 t.getPredicate().toString(), 
							 t.getObject().toString());
	}
	
	protected boolean matches(Rule rule, WTriple wt) {
		return matches(rule, wt.getSubject(), wt.getPredicate(), wt.getObject());
	}
	
	protected boolean matches(Rule rule, String subject, String predicate, String object) {
		String first = null;
		String second = null;
		switch (rule.first) {
			case SUBJECT:
				first = subject;
				break;
			case PREDICATE:
				first = predicate;
				break;
			case OBJECT:
				first = object;
				break;
		}
		if (rule.second != null){
			switch (rule.second) {
			case SUBJECT:
				second = subject;
				break;
			case PREDICATE:
				second = predicate;
				break;
			case OBJECT:
				second = object;
				break;
			}
		}
		if (first != null && first.matches("(?i)"+rule.firstS)){
			if (second == null){
				return true;
			}
			if(second.matches("(?i)"+rule.secondS)){
				return true;
			}
		}
		
		return false;
	}
	
}
