package org.ow2.weblab.core.helper.impl;

import java.util.Collection;
import java.util.Set;

import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.model.PieceOfKnowledge;

/**
 * THis class gives basic tools to retrieve Predicate, Value pairs and 
 * to write statements from a WTripleMap
 * 
 * @author Arnaud
 *
 */
public interface IPredicateValuePairs {

	/**
	 * Returns the object of the predicate.
	 * @param predicate a predicate
	 * @return the object
	 */
	public Object getValue(String predicate);
	
	/**
	 * Write a statement.
	 * @param predicate a predicate
	 * @param object an object
	 * @throws WebLabCheckedException
	 */
	public void writeStatement(String predicate, String object) throws WebLabCheckedException;
	
	/**
	 * Write several statements at the same time.
	 * @param predicates an array of predicates
	 * @param objects an array of objects
	 * @param pok a piece of knowledge
	 * @throws WebLabCheckedException
	 */
	public void writeStatements(String[] predicates, String[] objects, PieceOfKnowledge pok) throws WebLabCheckedException;
	
	/**
	 * Returns all predicates
	 * @return all predicates
	 */
	public Set<String> allPredicates();
	
	/**
	 * Returns the list of WTriples
	 * @return the list of WTriples
	 */
	public Collection<WTriple> getStatements();	
}
