/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.helper.impl;

import java.util.List;

import org.ow2.weblab.core.model.Resource;

/**
 * Selection functions for triples retrieval and WebLab model association.
 * 
 */
public interface RDFRulesSelector {
	
	/**
	 * Find Triplets Subject, Predicate, Object) in the resource 
	 * according to the rules already set in the Selector.  
	 * @param resource a resource
	 * @return a list of triples
	 */
	List<WTriple> findIn(Resource resource);
	
	/**
	 * Add a filter on an association subject/predicat
	 * @param subject
	 * @param predicat
	 */
	public void addSPRule(final String subject, final String predicat);
	
	/**
	 * Add a filter on an association subject/object
	 * @param subject
	 * @param object
	 */
	public void addSORule(final String subject, final String object);
	
	/**
	 * Add a filter on an association predicat/object
	 * @param predicat
	 * @param object
	 */
	public void addPORule(final String predicat, final String object);
	
	/**
	 * If limit is true, then all the searches made with this RDFSelector
	 * will stop after the first level of annotation.<br/>
	 * Else the search will recursively browse all the searched Resource structure.
	 * By default limit is false.
	 * @param limit if true, it will only search annotation on resource else it will search until the leaf annotations
	 */
	void limitToFirstLevelAnnotation(boolean limit);
}
