package org.ow2.weblab.core.helper.impl;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;

/**
 * This class provides simple methods to access results of the selection.<br/>
 * Results are ordered in a map of map.<br/>
 * Let's say your search returns 3 results:<br/>
 * <code>
 * (uri:mySubject#1, uri:myPredicate#1, resource:myObject#1)<br/>
 * (uri:mySubject#1, uri:myPredicate#2, resource:myObject#2)<br/>
 * (uri:mySubject#2, uri:myPredicate#1, resource:myObject#3)<br/>
 * </code><br/>
 * To access the text value of <i>resource:myObject#1</i>, one could write <br/>
 * <code>
 *  Results results = SimpleSelector.searchFor(Mydoc);<br/>
 *  String valueOfMyObject1 = results.getTypedValue("uri:mySubject#1","uri:myPredicate#1",String.class); <br/>
 * </code><br/><br/>
 * To list all subjects that contain the predicate <i>uri:myPredicate#1</i>, one could write: <br/>
 * <code>
 *  Results results = SimpleSelector.searchFor(Mydoc);<br/>
 *  List&lt;String&gt; sujbects = results.getSubjects("uri:myPredicate#1",".*");<br/>
 * </code>
 * Remark: the use of a regular expression in the second parameters allow to select any value for this predicate.<br/>
 * 
 * 
 * @author arnaud saval
 *
 */
public class Results extends LinkedHashMap<String, LinkedHashMap<String, Object>>{
	
	protected Statements statements;
	
	protected Results(Statements statements){
		this.statements = statements;
		LinkedHashMap<String, LinkedHashMap<String, Object>> itself= statements.getMap();
		putAll(itself);
	}
	
	/**
	 * Returns all the subjects that matches the tuple (predicate,object)
	 * @param predicate
	 * @param object
	 * @return a set of subject
	 */
	public Set<String> getSubjects(String predicate, String object){
		return this.statements.getSubjects(predicate, object);
	}
	
	/**
	 * Return a typed value rather than an object.
	 * @param <T> the type to be returned
	 * @param subject a subject
	 * @param property a property
	 * @param clazz a class of the type of the value 
	 * @return An instance of <T> if the value can be mapped on this type, else null. 
	 */
	public <T> T getTypedValue(String subject, String property, Class<T> clazz){
		return this.statements.getTypedValue(subject, property, clazz);
	}
	
	
	/**
	 * Returns a list of typed values.
	 * @param <T> the type of the value 
	 * @param subject the uri of the subject
	 * @param property the uri of the subject
	 * @param clazz the class of the value
	 * @return a list of typed values.
	 */
	public <T> LinkedList<T> getTypedValues(String subject, String property, Class<T> clazz){
		return this.statements.getTypedValues(subject, property, clazz);
	}

}
