package org.ow2.weblab.core.helper.impl;

import org.ow2.weblab.core.model.Resource;

public interface SimpleSelector {
	
	/**
	 * Build a collection of objects with given properties.<br/>
	 * Let's say you search for : searchFor(myResource, EVENT, NAME, DATE, LOCATION)
	 * where name is a type of resource and NAME, DATE and LOCATION are predicates.<br/> 
	 * Then it will return a map :<br/>
	 * <code>
	 *  {<br/>
	 *   subject0uri => { NAME => nameObject0, DATE => dateObject0, LOCATION => locationObject0 },<br/>
	 *   subject1uri => { NAME => nameObject1, DATE => dateObject1, LOCATION => locationObject1 },<br/>
	 *   subject2uri => { NAME => nameObject2, DATE => dateObject2, LOCATION => locationObject2 }<br/>
	 *  } <br/>
	 * </code>
	 * It can access any EVENT in O(1) and any predicate value in O(1).<br/>
	 * If the resource is null, then a NullPointerException is thrown.
	 * If predicates are null, then all predicates will match the search. 
	 * @param resource an annotated Resource
	 * @param predicates the list of searched predicates
	 * @return an easy and fast access structure collection of triples 
	 */
	Results select(Resource resource, String... predicates);
	
	/**
	 * If limit is true, then all the searches made with this RDFSelector
	 * will stop after the first level of annotation.<br/>
	 * Else the search will recursively browse all the searched Resource structure.
	 * By default limit is false.
	 * @param limit if true, it will only search annotation on resource else it will search until the leaf annotations
	 */
	void limitToFirstLevelAnnotation(boolean limit);
	
}
