/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.helper.impl.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.hp.hpl.jena.iri.impl.Parser;

public final class Parsers {
	
	private static Map<String, TypeParser<?>> parsers = loadParsers();
	protected static boolean strict = false;
	private static Log log = LogFactory.getLog(Parser.class); 
	
	private Parsers(){
		throw new UnsupportedOperationException("This class only contains "
				+ "static methods; no need to instantiate it.");
	}
	
	private static HashMap<String, TypeParser<?>> loadParsers(){
		if (log == null){
			log = LogFactory.getLog(Parser.class);
		}
		log.debug("Loading RDFType parsers.");
		Properties prop = new Properties();
		HashMap<String, TypeParser<?>> parsers = new HashMap<String, TypeParser<?>>();
		try {
			InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream("typeParsers.properties");
			if (is != null){
				prop.load(is);
			}else{
				log.info("Can not load parsers from typeParsers.properties");
				log.info("Loading default properties:");
				log.info("option.strict=false\n" +
						"java.util.Date=org.weblab_project.core.helper.impl.parser.RDFDateTypeParser\n" +
						"java.lang.Integer=org.weblab_project.core.helper.impl.parser.RDFIntegerTypeParser\n" +
						"java.lang.Float=org.weblab_project.core.helper.impl.parser.RDFFloatTypeParser\n" +
						"java.lang.String=org.weblab_project.core.helper.impl.parser.RDFTransparentStringTypeParser");
				prop.setProperty("option.strict", "false");
				prop.setProperty("java.util.Date", "org.weblab_project.core.helper.impl.parser.RDFDateTypeParser");
				prop.setProperty("java.lang.Integer", "org.weblab_project.core.helper.impl.parser.RDFIntegerTypeParser");
				prop.setProperty("java.lang.Float", "org.weblab_project.core.helper.impl.parser.RDFFloatTypeParser");
				prop.setProperty("java.lang.String", "org.weblab_project.core.helper.impl.parser.RDFTransparentStringTypeParser");
			}
			for(Object key:prop.keySet()){
				log.debug("key: "+key+" value : "+prop.getProperty(key.toString()));
				if (key.toString().startsWith("option")){
					Object value = prop.getProperty(key.toString());
					if (value != null && key.toString().endsWith("strict")){
						strict = value.toString().equalsIgnoreCase("true"); 
					}
				}else{
					parsers.put(key.toString(), load(prop.getProperty(key.toString())));
				}
			}
		} catch (IOException e) {
			log.error(e);
		}
		log.debug("RDFType parsers loaded.");
		return parsers;
	}
	
	private static TypeParser<?> load(Object object) {
		TypeParser<?> tp = null;
		try {
			log.debug("Try to load with System ClassLoader : "+object);
			tp = (TypeParser<?>) ClassLoader.getSystemClassLoader().loadClass(object.toString()).newInstance();
		} catch (ClassNotFoundException e) {
			log.warn(e);
		} catch (InstantiationException e) {
			log.error(e);
		} catch (IllegalAccessException e) {
			log.error(e);
		}
		if (tp == null){
			
			try {
				log.debug("Try to load with Local ClassLoader : "+object);
				tp = (TypeParser<?>) Parsers.class.getClassLoader().loadClass(object.toString()).newInstance();
			} catch (ClassNotFoundException e) {
				log.error(e);
			} catch (InstantiationException e) {
				log.error(e);
			} catch (IllegalAccessException e) {
				log.error(e);
			}
		}
		log.debug("Loaded : "+tp);
		return tp;
	}

	public static <T> TypeParser<T> getParser(Class<T> clazz) throws ParserConfigurationException, ClassCastException{
		TypeParser<?> tp = Parsers.parsers.get(clazz.getName());
		if(tp == null){
			throw new ParserConfigurationException("No parser found for type : "+clazz.getName()+" in : "+Parsers.parsers);
		}
		TypeParser<T> result = null;
		try{
			// TODO: a true verification is needed.
			result = (TypeParser<T>) tp;
		}catch (ClassCastException cce) {
			throw cce;
		}
		return result;
	}
}
