/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.helper.impl.parser;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ibm.icu.text.SimpleDateFormat;

public class RDFDateTypeParser extends TypeParser<Date>{

	private static final String XSD_DATE_REGEXP = "\"(.|\\s)+\"\\^\\^xsd:date(@..(.|\\s)*)?";
	private static final Log log = LogFactory.getLog(RDFDateTypeParser.class); 
	
	@Override
	protected Date parseTypeValue(String value, String type, String lang) {
		
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
		try {
			Date d = sdf.parse(value.trim());
			return d;
		} catch (ParseException e) {
			log.error(e);
		}

		int[] styles = new int[]{
				DateFormat.DEFAULT,
				DateFormat.SHORT,
				DateFormat.MEDIUM,
				DateFormat.LONG,
				DateFormat.FULL
		};
		Locale[] locales = new Locale[]{
				Locale.ENGLISH,
				Locale.FRENCH,
				Locale.GERMAN
		}; 
		boolean found = false;
		Date date = null;
		int i =0;
		int l =0;
		while(!found){
			try {
				if (l == locales.length){
					break;
				}
				DateFormat df = DateFormat.getDateInstance(styles[i],locales[l]);
				i++;
				if (i == styles.length){
					i = 0;
					l++;
				}
				date = df.parse(value.trim());
				found = true;
			} catch (ParseException e) {
				log.trace(e);
			}
		}
		
		return date;
	}

	@Override
	protected boolean matches(String o) {
		return o.trim().matches(XSD_DATE_REGEXP);
	}	

}

