/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.helper.impl.parser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RDFIntegerTypeParser extends TypeParser<Integer>{

	private static final String XSD_DATE_REGEXP = "\"(.|\\s)+\"\\^\\^xsd:int(etger)?(@..(.|\\s)*)?";
	private static final Log log = LogFactory.getLog(RDFIntegerTypeParser.class);	
	
	@Override
	protected boolean matches(String o) {
		return o.trim().matches(XSD_DATE_REGEXP);
	}

	@Override
	protected Integer parseTypeValue(String value, String type, String lang) {
		Integer i = null;
		try{
			i = Integer.parseInt(value.trim());
		}catch(NumberFormatException nfe){
			log.error(nfe);
		}
		return i;
	}
	
	
}
