/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.helper.impl.parser;


public abstract class TypeParser<T> {
	public T parseValue(Object o){
		if (!Parsers.strict || ((o instanceof String) && matches(o.toString()))){
			String[] values = split(o.toString());
			return parseTypeValue(values[0],values[1],values[2]);
		}
		return null;
	}
	
	protected abstract T parseTypeValue(String value,String type,String lang);
	
	protected abstract boolean matches(String o);
	
	protected String[] split(String s){
		int i = s.lastIndexOf('"');
		int a = s.lastIndexOf('@');
		String lang = "";
		String type = "";
		String value = s;
		if (s.startsWith("\"") && i > 0){
			value = s.substring(1,i);
			String ts = s.substring(i);
			int t = ts.indexOf("^^");
			t = i+((t == -1)?1:t+2);
			if (a != -1){
				lang = s.substring(a+1);
				type = s.substring(t,a);
			}else { 
				type = s.substring(t);
			}
		}
		return new String[]{value,type,lang};
	}
	
}
