/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.helper;

/**
 * <p>
 * API to manipulate a unique <code>PieceOfKnowledge</code> object, with extended functions compared with <code>PoKHelper</code>
 * </p>
 * <p>
 * In this new version of helpers, a lots of method have been added. They shall be easier to understand and use. No more boolean in parameters. But anonymous
 * resources are know taken into account, thus giving the code more possibility of choice.<br />
 * </p>
 * <p>
 * In this class a lot of abbreviation are used to reduce the length of the methods. Those convention are commons with {@link PoKHelper}, {@link ResourceHelper}
 * and {@link ResourceHelperExtended}.
 * <ul>
 * <li><tt>Subj</tt>: In method names, means subject.</li>
 * <li><tt>Pred</tt>: In method names, means predicate (property).</li>
 * <li><tt>Lit</tt>: In method names, means object that is literal.</li>
 * <li><tt>Res</tt>: In method names, means object that is resource.</li>
 * <li><tt>Stat</tt>: In method names, means statement.</li>
 * <li><tt>Reif</tt>: In method names, means reification of statement.</li>
 * <li><tt>Anon</tt>: In method names, means that subject or object is an anonymous resource.</li>
 * <li><tt>uriSubj</tt>: In parameter, means the URI of a subject that is a named resource.</li>
 * <li><tt>idSubj</tt>: In parameter, means the internal ID of a subject that is an anonymous resource. <i>Using this ID between two different implementation of
 * helpers is totally discouraged.</i></li>
 * <li><tt>uriPred</tt>: In parameter, means the URI of a predicate that is a named resource.</li>
 * <li><tt>uriObj</tt>: In parameter, means the URI of an object that is a named resource.</li>
 * <li><tt>litObj</tt>: In parameter, means the value of an object that is a literal.</li>
 * <li><tt>idObj</tt>: In parameter, means the internal ID of an object that is an anonymous resource. <i>Using this ID between two different implementation of
 * helpers is totally discouraged.</i></li>
 * </ul>
 * 
 * @note Using an anonymous resource as predicate is not possible in this interface since we never encountered the case.
 * @todo Extend literal to typed literals
 * @todo Extend literal to language dependent literals
 * @author EADS WebLab Team
 * @date 2009-06-23
 * @see PoKHelper
 * @see ResourceHelper
 * @see ResourceHelperExtended
 */
public interface PoKHelperExtended extends PoKHelper, RDFReaderExtended, RDFWriterExtended {
	// Nothing is needed here; everything are in the interfaces.
}
