/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.helper;

/**
 * <p>
 * This class is an extract from former <code>AnnotationHelper</code>, in order to be separated from methods of <code>ResourceHelper</code>.
 * </p>
 * More comments are done in {@link PoKHelper}.
 * 
 * @author EADS WebLab Team
 * @date 2008-09-16
 * @see PoKHelper
 */
interface RDFWriter {

	
	/**
	 * Creates a statement having <code>uriSubj</code> as subject, <code>uriPred</code> as predicate and <code>litObj</code> as literal value of the object.<br />
	 * 
	 * @param uriSubj
	 *            The URI of the subject resource.
	 * @param uriPred
	 *            The URI of the predicate resource.
	 * @param litObj
	 *            The literal value of the object.
	 * @param language
	 *            The language of the literal value. See http://www.w3.org/TR/REC-xml/#sec-lang-tag for more information. 
	 */
	public void createLitStat(final String uriSubj, final String uriPred, final String litObj, final String language);
	
	/**
	 * Creates a statement having <code>uriSubj</code> as subject, <code>uriPred</code> as predicate and <code>litObj</code> as literal value of the object.<br />
	 * 
	 * @param uriSubj
	 *            The URI of the subject resource.
	 * @param uriPred
	 *            The URI of the predicate resource.
	 * @param litObj
	 *            The literal value of the object.
	 */
	public void createLitStat(final String uriSubj, final String uriPred, final String litObj);

	/**
	 * Creates a statement having <code>uriSubj</code> as subject, <code>uriPred</code> as predicate and <code>uriObj</code> as URI of the object.<br />
	 * 
	 * @param uriSubj
	 *            The URI of the subject resource.
	 * @param uriPred
	 *            The URI of the predicate resource.
	 * @param uriObj
	 *            The URI of the object resource.
	 */
	public void createResStat(final String uriSubj, final String uriPred, final String uriObj);

	/**
	 * Removes every statements having <code>uriSubj</code> as subject, <code>uriPred</code> as predicate and <code>litObj</code> as literal value of the
	 * object.<br />
	 * 
	 * @param uriSubj
	 *            The URI of the subject resource.
	 * @param uriPred
	 *            The URI of the predicate resource.
	 * @param litObj
	 *            The literal value of the object.
	 * @return The number of removed statements.
	 */
	public void removeLitStat(final String uriSubj, final String uriPred, final String litObj);

	/**
	 * Removes every statements having <code>uriSubj</code> as subject, <code>uriPred</code> as predicate and <code>uriObj</code> as URI of the object.<br />
	 * 
	 * @param uriSubj
	 *            The URI of the subject resource.
	 * @param uriPred
	 *            The URI of the predicate resource.
	 * @param uriObj
	 *            The URI of the object resource.
	 * @return The number of removed statements.
	 */
	public void removeResStat(final String uriSubj, final String uriPred, final String uriObj);

	/**
	 * Removes every statements having <code>uriSubj</code> as subject whatever are predicate and object.<br />
	 * 
	 * @param uriSubj
	 *            The URI of the subject resource.
	 * @return The number of removed statements.
	 */
	public void removeStatsOnSubj(final String uriSubj);

	/**
	 * Removes every statements having <code>litObj</code> as object literal value whatever are subject and predicate.<br />
	 * 
	 * @param litObj
	 *            The literal value of the object.
	 * @return The number of removed statements.
	 */
	public void removeStatsWithLit(final String litObj);

	/**
	 * Removes every statements having <code>uriPred</code> as predicate whatever are subject and object.<br />
	 * 
	 * @param uriPred
	 *            The URI of the predicate resource.
	 * @return The number of removed statements.
	 */
	public void removeStatsWithPred(final String uriPred);

	/**
	 * Removes every statements having <code>uriObj</code> as object named resource URI value whatever are subject and predicate.<br />
	 * 
	 * @param uriObj
	 *            The URI of the object resource. The URI of the object resource.
	 * @return The number of removed statements.
	 */
	public void removeStatsWithRes(final String uriObj);

}
