/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.helper;

/**
 * <p>
 * Extended API to manipulate <code>Annotation</code> objects that are present on a <code>Resource</code> and its potential sub-resources.
 * </p>
 * <p>
 * Note that if the given <code>Resource</code> is it self an <code>PieceOfKnowledge</code>, it will not load its content but the content of every
 * <code>Annotation</code> on this <code>PieceOfKnowledge</code> (and recursively then for each <code>Annotation</code> loaded).
 * </p>
 * 
 * @author EADS WebLab Team
 * @date 2008-09-18
 * @see PoKHelperExtended
 * @see ResourceHelper
 */
public interface ResourceHelperExtended extends RDFReaderExtended, ResourceHelper {
	// Nothing is needed here. Everything is in the interfaces extended.
}
