/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.helper.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.ow2.weblab.core.helper.PoKHelperExtended;

/**
 * Implementation of <code>AnnotationHelperExtended</code> based on <tt>Jena framework</tt>.<br />
 * You'd rather to load this class using the <code>HelperFactory</code>.
 * 
 * @author EADS WebLab Team
 * @date 2008-01-18
 * @see JenaPoKHelper
 * @todo Prevent the direct instantiation of this class.
 */
public class JenaPoKHelperExtended extends JenaPoKHelper implements PoKHelperExtended {

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createAnonResStat(java.lang.String, java.lang.String, java.lang.String)
	 */
	public void createAnonResStat(final String uriSubj, final String uriPred, final String idObj) {
		this.bejh.createAnonResStat(uriSubj, uriPred, idObj);
		if (this.autoCommit) {
			this.commit();
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createAnonResStatOnAnonSubj(java.lang.String, java.lang.String, java.lang.String)
	 */
	public void createAnonResStatOnAnonSubj(final String idSubj, final String uriPred, final String idObj) {
		this.bejh.createAnonResStatOnAnonSubj(idSubj, uriPred, idObj);
		if (this.autoCommit) {
			this.commit();
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createAnonResStatReif(java.lang.String, java.lang.String, java.lang.String, java.util.Map,
	 * java.util.Map, java.util.Map)
	 */
	public String createAnonResStatReif(final String uriSubj, final String uriPred, final String idObj,
			final Map<String, String> mapPredLit, final Map<String, String> mapPredUri,
			final Map<String, String> mapPredId) {
		final String id = this.bejh.createAnonResStatReif(uriSubj, uriPred, idObj, mapPredLit, mapPredUri, mapPredId);
		if (this.autoCommit) {
			this.commit();
		}
		return id;
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createAnonResStatReif(java.lang.String, java.lang.String, java.lang.String, java.util.Map,
	 * java.util.Map, java.util.Map, java.lang.String)
	 */
	public String createAnonResStatReif(final String uriSubj, final String uriPred, final String idObj,
			final Map<String, String> mapPredLit, final Map<String, String> mapPredUri,
			final Map<String, String> mapPredId, final String statUri) {
		final String id = this.bejh.createAnonResStatReif(uriSubj, uriPred, idObj, mapPredLit, mapPredUri, mapPredId);
		if (this.autoCommit) {
			this.commit();
		}
		return id;
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createAnonResStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String,
	 * java.util.Map, java.util.Map, java.util.Map)
	 */
	public String createAnonResStatReifOnAnonSubj(final String idSubj, final String uriPred, final String idObj,
			final Map<String, String> mapPredLit, final Map<String, String> mapPredUri,
			final Map<String, String> mapPredId) {
		final String id =
				this.bejh.createAnonResStatReifOnAnonSubj(idSubj, uriPred, idObj, mapPredLit, mapPredUri, mapPredId);
		if (this.autoCommit) {
			this.commit();
		}
		return id;

	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createAnonResStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String,
	 * java.util.Map, java.util.Map, java.util.Map, java.lang.String)
	 */
	public String createAnonResStatReifOnAnonSubj(final String idSubj, final String uriPred, final String idObj,
			final Map<String, String> mapPredLit, final Map<String, String> mapPredUri,
			final Map<String, String> mapPredId, final String statUri) {
		final String uri =
				this.bejh.createAnonResStatReifOnAnonSubj(idSubj, uriPred, idObj, mapPredLit, mapPredUri, mapPredId,
						statUri);
		if (this.autoCommit) {
			this.commit();
		}
		return uri;
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createLitStatOnAnonSubj(java.lang.String, java.lang.String, java.lang.String)
	 */
	public void createLitStatOnAnonSubj(final String idSubj, final String uriPred, final String litObj) {
		this.bejh.createLitStatOnAnonSubj(idSubj, uriPred, litObj);
		if (this.autoCommit) {
			this.commit();
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createLitStatReif(java.lang.String, java.lang.String, java.lang.String, java.util.Map,
	 * java.util.Map, java.util.Map)
	 */
	public String createLitStatReif(final String uriSubj, final String uriPred, final String litObj,
			final Map<String, String> mapPredLit, final Map<String, String> mapPredUri,
			final Map<String, String> mapPredId) {
		final String id = this.bejh.createLitStatReif(uriSubj, uriPred, litObj, mapPredLit, mapPredUri, mapPredId);
		if (this.autoCommit) {
			this.commit();
		}
		return id;

	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createLitStatReif(java.lang.String, java.lang.String, java.lang.String, java.util.Map,
	 * java.util.Map, java.util.Map, java.lang.String)
	 */
	public String createLitStatReif(final String uriSubj, final String uriPred, final String litObj,
			final Map<String, String> mapPredLit, final Map<String, String> mapPredUri,
			final Map<String, String> mapPredId, final String statUri) {
		final String uri =
				this.bejh.createLitStatReif(uriSubj, uriPred, litObj, mapPredLit, mapPredUri, mapPredId, statUri);
		if (this.autoCommit) {
			this.commit();
		}
		return uri;
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createLitStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String, java.util.Map,
	 * java.util.Map, java.util.Map)
	 */
	public String createLitStatReifOnAnonSubj(final String idSubj, final String uriPred, final String litObj,
			final Map<String, String> mapPredLit, final Map<String, String> mapPredUri,
			final Map<String, String> mapPredId) {
		final String id =
				this.bejh.createLitStatReifOnAnonSubj(idSubj, uriPred, litObj, mapPredLit, mapPredUri, mapPredId);
		if (this.autoCommit) {
			this.commit();
		}
		return id;
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createLitStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String, java.util.Map,
	 * java.util.Map, java.util.Map, java.lang.String)
	 */
	public String createLitStatReifOnAnonSubj(final String idSubj, final String uriPred, final String litObj,
			final Map<String, String> mapPredLit, final Map<String, String> mapPredUri,
			final Map<String, String> mapPredId, final String statUri) {
		final String uri =
				this.bejh.createLitStatReifOnAnonSubj(idSubj, uriPred, litObj, mapPredLit, mapPredUri, mapPredId,
						statUri);
		if (this.autoCommit) {
			this.commit();
		}
		return uri;

	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createResStatOnAnonSubj(java.lang.String, java.lang.String, java.lang.String)
	 */
	public void createResStatOnAnonSubj(final String idSubj, final String uriPred, final String uriObj) {
		this.bejh.createResStatOnAnonSubj(idSubj, uriPred, uriObj);
		if (this.autoCommit) {
			this.commit();
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createResStatReif(java.lang.String, java.lang.String, java.lang.String, java.util.Map,
	 * java.util.Map, java.util.Map)
	 */
	public String createResStatReif(final String uriSubj, final String uriPred, final String uriObj,
			final Map<String, String> mapPredLit, final Map<String, String> mapPredUri,
			final Map<String, String> mapPredId) {
		final String id = this.bejh.createResStatReif(uriSubj, uriPred, uriObj, mapPredLit, mapPredUri, mapPredId);
		if (this.autoCommit) {
			this.commit();
		}
		return id;
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createResStatReif(java.lang.String, java.lang.String, java.lang.String, java.util.Map,
	 * java.util.Map, java.util.Map, java.lang.String)
	 */
	public String createResStatReif(final String uriSubj, final String uriPred, final String uriObj,
			final Map<String, String> mapPredLit, final Map<String, String> mapPredUri,
			final Map<String, String> mapPredId, final String statUri) {
		final String uri =
				this.bejh.createResStatReif(uriSubj, uriPred, uriObj, mapPredLit, mapPredUri, mapPredId, statUri);
		if (this.autoCommit) {
			this.commit();
		}
		return uri;
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createResStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String, java.util.Map,
	 * java.util.Map, java.util.Map)
	 */
	public String createResStatReifOnAnonSubj(final String idSubj, final String uriPred, final String uriObj,
			final Map<String, String> mapPredLit, final Map<String, String> mapPredUri,
			final Map<String, String> mapPredId) {
		final String id =
				this.bejh.createResStatReifOnAnonSubj(idSubj, uriPred, uriObj, mapPredLit, mapPredUri, mapPredId);
		if (this.autoCommit) {
			this.commit();
		}
		return id;
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#createResStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String, java.util.Map,
	 * java.util.Map, java.util.Map, java.lang.String)
	 */
	public String createResStatReifOnAnonSubj(final String idSubj, final String uriPred, final String uriObj,
			final Map<String, String> mapPredLit, final Map<String, String> mapPredUri,
			final Map<String, String> mapPredId, final String statUri) {
		final String toRet =
				this.bejh.createResStatReifOnAnonSubj(idSubj, uriPred, uriObj, mapPredLit, mapPredUri, mapPredId,
						statUri);
		if (this.autoCommit) {
			this.commit();
		}
		return toRet;
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonReifStats()
	 */
	public List<String> getAnonReifStats() {
		return this.bejh.getAnonReifStats();
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonResOnAnonReifStat(java.lang.String)
	 */
	public String getAnonResOfAnonReifStat(final String statId) {
		return this.bejh.getAnonResOfAnonReifStat(statId);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonResOnPredAnonResStatReif(java.lang.String, java.lang.String, java.lang.String,
	 * java.lang.String)
	 */
	public List<String> getAnonRessOnPredAnonResStatReif(final String uriSubj, final String uriPred,
			final String idObj, final String uriReif) {
		return this.bejh.getAnonResOnPredAnonResStatReif(uriSubj, uriPred, idObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonResOnPredAnonResStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String,
	 * java.lang.String)
	 */
	public List<String> getAnonRessOnPredAnonResStatReifOnAnonSubj(final String idSubj, final String uriPred,
			final String idObj, final String uriReif) {
		return this.bejh.getAnonResOnPredAnonResStatReifOnAnonSubj(idSubj, uriPred, idObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonResOnPredAnonStatReif(java.lang.String, java.lang.String)
	 */
	public List<String> getAnonRessOnPredAnonStatReif(final String statId, final String uriPred) {
		return this.bejh.getAnonResOnPredAnonStatReif(statId, uriPred);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonResOnPredAnonSubj(java.lang.String, java.lang.String)
	 */
	public List<String> getAnonRessOnPredAnonSubj(final String idSubj, final String uriPred) {
		return this.bejh.getAnonResOnPredAnonSubj(idSubj, uriPred);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonResOnPredLitStatReif(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public List<String> getAnonRessOnPredLitStatReif(final String uriSubj, final String uriPred, final String litObj,
			final String uriReif) {
		return this.bejh.getAnonResOnPredLitStatReif(uriSubj, uriPred, litObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonResOnPredLitStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String,
	 * java.lang.String)
	 */
	public List<String> getAnonRessOnPredLitStatReifOnAnonSubj(final String idSubj, final String uriPred,
			final String litObj, final String uriReif) {
		return this.bejh.getAnonResOnPredLitStatReifOnAnonSubj(idSubj, uriPred, litObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonResOnPredResStatReif(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public List<String> getAnonRessOnPredResStatReif(final String uriSubj, final String uriPred, final String uriObj,
			final String uriReif) {
		return this.bejh.getAnonResOnPredResStatReif(uriSubj, uriPred, uriObj, uriReif);
	}

	public List<String> getAnonRessOnPredResStatReifOnAnonSubj(final String idSubj, final String uriPred,
			final String uriObj, final String uriReif) {
		return this.bejh.getAnonResOnPredResStatReifOnAnonSubj(idSubj, uriPred, uriObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonResOnPredStatReif(java.lang.String, java.lang.String)
	 */
	public List<String> getAnonRessOnPredStatReif(final String statUri, final String uriPred) {
		return this.bejh.getAnonResOnPredStatReif(statUri, uriPred);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonResOnPredSubj(java.lang.String, java.lang.String)
	 */
	public List<String> getAnonRessOnPredSubj(final String uriSubj, final String uriPred) {
		return this.bejh.getAnonResOnPredSubj(uriSubj, uriPred);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonResOnReifStat(java.lang.String)
	 */
	public String getAnonResOnReifStat(final String statUri) {
		return this.bejh.getAnonResOnReifStat(statUri);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonSubj()
	 */
	public Set<String> getAnonSubjs() {
		return this.bejh.getAnonSubj();
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonSubjOnAnonReifStat(java.lang.String)
	 */
	public String getAnonSubjOfAnonReifStat(final String statId) {
		return this.bejh.getAnonSubjOfAnonReifStat(statId);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonSubjOnReifStat(java.lang.String)
	 */
	public String getAnonSubjOfReifStat(final String statUri) {
		return this.bejh.getAnonSubjOfReifStat(statUri);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonSubjOnPred(java.lang.String)
	 */
	public Set<String> getAnonSubjsOnPred(final String uriPred) {
		return this.bejh.getAnonSubjOnPred(uriPred);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonSubjOnPredAnonRes(java.lang.String, java.lang.String)
	 */
	public Set<String> getAnonSubjsOnPredAnonRes(final String uriPred, final String idObj) {
		return this.bejh.getAnonSubjOnPredAnonRes(uriPred, idObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonSubjOnPredLit(java.lang.String, java.lang.String)
	 */
	public Set<String> getAnonSubjsOnPredLit(final String uriPred, final String litObj) {
		return this.bejh.getAnonSubjOnPredLit(uriPred, litObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getAnonSubjOnPredRes(java.lang.String, java.lang.String)
	 */
	public Set<String> getAnonSubjsOnPredRes(final String uriPred, final String uriObj) {
		return this.bejh.getAnonSubjOnPredRes(uriPred, uriObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getLitOnAnonReifStat(java.lang.String)
	 */
	public String getLitOfAnonReifStat(final String statId) {
		return this.bejh.getLitOfAnonReifStat(statId);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getLitOnReifStat(java.lang.String)
	 */
	public String getLitOfReifStat(final String statUri) {
		return this.bejh.getLitOfReifStat(statUri);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getLitOnPredAnonResStatReif(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public List<String> getLitsOnPredAnonResStatReif(final String uriSubj, final String uriPred, final String idObj,
			final String uriReif) {
		return this.bejh.getLitOnPredAnonResStatReif(uriSubj, uriPred, idObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getLitOnPredAnonResStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String,
	 * java.lang.String)
	 */
	public List<String> getLitsOnPredAnonResStatReifOnAnonSubj(final String idSubj, final String uriPred,
			final String idObj, final String uriReif) {
		return this.bejh.getLitOnPredAnonResStatReifOnAnonSubj(idSubj, uriPred, idObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getLitOnPredAnonStatReif(java.lang.String, java.lang.String)
	 */
	public List<String> getLitsOnPredAnonStatReif(final String statId, final String uriPred) {
		return this.bejh.getLitOnPredAnonStatReif(statId, uriPred);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getLitOnPredAnonSubj(java.lang.String, java.lang.String)
	 */
	public List<String> getLitsOnPredAnonSubj(final String idSubj, final String uriPred) {
		return this.bejh.getLitOnPredAnonSubj(idSubj, uriPred);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getLitOnPredLitStatReif(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public List<String> getLitsOnPredLitStatReif(final String uriSubj, final String uriPred, final String litObj,
			final String uriReif) {
		return this.bejh.getLitOnPredLitStatReif(uriSubj, uriPred, litObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getLitOnPredLitStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String,
	 * java.lang.String)
	 */
	public List<String> getLitsOnPredLitStatReifOnAnonSubj(final String idSubj, final String uriPred,
			final String litObj, final String uriReif) {
		return this.bejh.getLitOnPredLitStatReifOnAnonSubj(idSubj, uriPred, litObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getLitOnPredResStatReif(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public List<String> getLitsOnPredResStatReif(final String uriSubj, final String uriPred, final String uriObj,
			final String uriReif) {
		return this.bejh.getLitOnPredResStatReif(uriSubj, uriPred, uriObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getLitOnPredResStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String,
	 * java.lang.String)
	 */
	public List<String> getLitsOnPredResStatReifOnAnonSubj(final String idSubj, final String uriPred,
			final String uriObj, final String uriReif) {
		return this.bejh.getLitsOnPredResStatReifOnAnonSubj(idSubj, uriPred, uriObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getLitOnPredStatReif(java.lang.String, java.lang.String)
	 */
	public List<String> getLitsOnPredStatReif(final String statUri, final String uriPred) {
		return this.bejh.getLitsOnPredStatReif(statUri, uriPred);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getNSPrefixes()
	 */
	public Map<String, String> getNSPrefixes() {
		return this.bejh.getNSPrefixes();
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getPredOnAnonReifStat(java.lang.String)
	 */
	public String getPredOfAnonReifStat(final String statId) {
		return this.bejh.getPredOfAnonReifStat(statId);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getPredOnReifStat(java.lang.String)
	 */
	public String getPredOfReifStat(final String statUri) {
		return this.bejh.getPredOfReifStat(statUri);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getPredOnAnonResStatReif(java.lang.String, java.lang.String, java.lang.String)
	 */
	public Set<String> getPredsOnAnonResStatReif(final String uriSubj, final String uriPred, final String idObj) {
		return this.bejh.getPredOnAnonResStatReif(uriSubj, uriPred, idObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getPredOnAnonResStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String)
	 */
	public Set<String> getPredsOnAnonResStatReifOnAnonSubj(final String idSubj, final String uriPred, final String idObj) {
		return this.bejh.getPredOnAnonResStatReifOnAnonSubj(idSubj, uriPred, idObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getPredOnAnonStatReif(java.lang.String)
	 */
	public Set<String> getPredsOnAnonStatReif(final String statId) {
		return this.bejh.getPredOnAnonStatReif(statId);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getPredOnAnonSubj(java.lang.String)
	 */
	public Set<String> getPredsOnAnonSubj(final String idSubj) {
		return this.bejh.getPredOnAnonSubj(idSubj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getPredOnLitStatReif(java.lang.String, java.lang.String, java.lang.String)
	 */
	public Set<String> getPredsOnLitStatReif(final String uriSubj, final String uriPred, final String litObj) {
		return this.bejh.getPredOnLitStatReif(uriSubj, uriPred, litObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getPredOnLitStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String)
	 */
	public Set<String> getPredsOnLitStatReifOnAnonSubj(final String idSubj, final String uriPred, final String litObj) {
		return this.bejh.getPredOnLitStatReifOnAnonSubj(idSubj, uriPred, litObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getPredOnResStatReif(java.lang.String, java.lang.String, java.lang.String)
	 */
	public Set<String> getPredsOnResStatReif(final String uriSubj, final String uriPred, final String uriObj) {
		return this.bejh.getPredOnResStatReif(uriSubj, uriPred, uriObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getPredOnResStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String)
	 */
	public Set<String> getPredsOnResStatReifOnAnonSubj(final String idSubj, final String uriPred, final String uriObj) {
		return this.bejh.getPredOnResStatReifOnAnonSubj(idSubj, uriPred, uriObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getPredOnStatReif(java.lang.String)
	 */
	public Set<String> getPredsOnStatReif(final String statUri) {
		return this.bejh.getPredOnStatReif(statUri);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getReifStats()
	 */
	public List<String> getReifStats() {
		return this.bejh.getReifStats();
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getResOnAnonReifStat(java.lang.String)
	 */
	public String getResOfAnonReifStat(final String statId) {
		return this.bejh.getResOfAnonReifStat(statId);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getResOnReifStat(java.lang.String)
	 */
	public String getResOfReifStat(final String statUri) {
		return this.bejh.getResOfReifStat(statUri);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getResOnPredAnonResStatReif(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public List<String> getRessOnPredAnonResStatReif(final String uriSubj, final String uriPred, final String idObj,
			final String uriReif) {
		return this.bejh.getResOnPredAnonResStatReif(uriSubj, uriPred, idObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getResOnPredAnonResStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String,
	 * java.lang.String)
	 */
	public List<String> getRessOnPredAnonResStatReifOnAnonSubj(final String idSubj, final String uriPred,
			final String idObj, final String uriReif) {
		return this.bejh.getResOnPredAnonResStatReifOnAnonSubj(idSubj, uriPred, idObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getResOnPredAnonStatReif(java.lang.String, java.lang.String)
	 */
	public List<String> getRessOnPredAnonStatReif(final String statId, final String uriPred) {
		return this.bejh.getResOnPredAnonStatReif(statId, uriPred);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getResOnPredAnonSubj(java.lang.String, java.lang.String)
	 */
	public List<String> getRessOnPredAnonSubj(final String idSubj, final String uriPred) {
		return this.bejh.getResOnPredAnonSubj(idSubj, uriPred);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getResOnPredLitStatReif(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public List<String> getRessOnPredLitStatReif(final String uriSubj, final String uriPred, final String litObj,
			final String uriReif) {
		return this.bejh.getResOnPredLitStatReif(uriSubj, uriPred, litObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getResOnPredLitStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String,
	 * java.lang.String)
	 */
	public List<String> getRessOnPredLitStatReifOnAnonSubj(final String idSubj, final String uriPred,
			final String litObj, final String uriReif) {
		return this.bejh.getResOnPredLitStatReifOnAnonSubj(idSubj, uriPred, litObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getResOnPredResStatReif(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public List<String> getRessOnPredResStatReif(final String uriSubj, final String uriPred, final String uriObj,
			final String uriReif) {
		return this.bejh.getResOnPredResStatReif(uriSubj, uriPred, uriObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getResOnPredResStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String,
	 * java.lang.String)
	 */
	public List<String> getRessOnPredResStatReifOnAnonSubj(final String idSubj, final String uriPred,
			final String uriObj, final String uriReif) {
		return this.bejh.getResOnPredResStatReifOnAnonSubj(idSubj, uriPred, uriObj, uriReif);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getResOnPredStatReif(java.lang.String, java.lang.String)
	 */
	public List<String> getRessOnPredStatReif(final String statUri, final String uriPred) {
		return this.bejh.getResOnPredStatReif(statUri, uriPred);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getSubjOnAnonReifStat(java.lang.String)
	 */
	public String getSubjOfAnonReifStat(final String statId) {
		return this.bejh.getSubjOfAnonReifStat(statId);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getSubjOnReifStat(java.lang.String)
	 */
	public String getSubjOfReifStat(final String statUri) {
		return this.bejh.getSubjOfReifStat(statUri);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#getSubjOnPredAnonRes(java.lang.String, java.lang.String)
	 */
	public Set<String> getSubjsOnPredAnonRes(final String uriPred, final String idObj) {
		return this.bejh.getSubjOnPredAnonRes(uriPred, idObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#hasAnonResStat(java.lang.String, java.lang.String, java.lang.String)
	 */
	public boolean hasAnonResStat(final String uriSubj, final String uriPred, final String idObj) {
		return this.bejh.hasAnonResStat(uriSubj, uriPred, idObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#hasAnonResStatOnAnonSubj(java.lang.String, java.lang.String, java.lang.String)
	 */
	public boolean hasAnonResStatOnAnonSubj(final String idSubj, final String uriPred, final String idObj) {
		return this.bejh.hasAnonResStatOnAnonSubj(idSubj, uriPred, idObj);
	}

	public boolean hasLitStatOnAnonSubj(final String idSubj, final String uriPred, final String litObj) {
		return this.bejh.hasLitStatOnAnonSubj(idSubj, uriPred, litObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#hasResStatOnAnonSubj(java.lang.String, java.lang.String, java.lang.String)
	 */
	public boolean hasResStatOnAnonSubj(final String idSubj, final String uriPred, final String uriObj) {
		return this.bejh.hasResStatOnAnonSubj(idSubj, uriPred, uriObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#isAnonResStatReif(java.lang.String, java.lang.String, java.lang.String)
	 */
	public boolean isAnonResStatReif(final String uriSubj, final String uriPred, final String idObj) {
		return this.bejh.isAnonResStatReif(uriSubj, uriPred, idObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#isAnonResStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String)
	 */
	public boolean isAnonResStatReifOnAnonSubj(final String idSubj, final String uriPred, final String idObj) {
		return this.bejh.isAnonResStatReifOnAnonSubj(idSubj, uriPred, idObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#isDefinedAnonRes(java.lang.String)
	 */
	public boolean isDefinedAnonRes(final String id) {
		return this.bejh.isDefinedAnonRes(id);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#isLitStatReif(java.lang.String, java.lang.String, java.lang.String)
	 */
	public boolean isLitStatReif(final String uriSubj, final String uriPred, final String litObj) {
		return this.bejh.isLitStatReif(uriSubj, uriPred, litObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#isLitStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String)
	 */
	public boolean isLitStatReifOnAnonSubj(final String idSubj, final String uriPred, final String litObj) {
		return this.bejh.isLitStatReifOnAnonSubj(idSubj, uriPred, litObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#isResStatReif(java.lang.String, java.lang.String, java.lang.String)
	 */
	public boolean isResStatReif(final String uriSubj, final String uriPred, final String uriObj) {
		return this.bejh.isResStatReif(uriSubj, uriPred, uriObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFReaderExtended#isResStatReifOnAnonSubj(java.lang.String, java.lang.String, java.lang.String)
	 */
	public boolean isResStatReifOnAnonSubj(final String idSubj, final String uriPred, final String uriObj) {
		return this.bejh.isResStatReifOnAnonSubj(idSubj, uriPred, uriObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#removeAnonReifStat(java.lang.String)
	 */
	public void removeAnonReifStat(final String statId) {
		this.bejh.removeAnonReifStat(statId);
		if (this.autoCommit) {
			this.commit();
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#removeAnonResStat(java.lang.String, java.lang.String, java.lang.String)
	 */
	public void removeAnonResStat(final String uriSubj, final String uriPred, final String idObj) {
		this.bejh.removeAnonResStat(uriSubj, uriPred, idObj);
		if (this.autoCommit) {
			this.commit();
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#removeAnonResStatOnAnonSubj(java.lang.String, java.lang.String, java.lang.String)
	 */
	public void removeAnonResStatOnAnonSubj(final String idSubj, final String uriPred, final String idObj) {
		this.bejh.removeAnonResStatOnAnonSubj(idSubj, uriPred, idObj);
		if (this.autoCommit) {
			this.commit();
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#removeLitStatOnAnonSubj(java.lang.String, java.lang.String, java.lang.String)
	 */
	public void removeLitStatOnAnonSubj(final String idSubj, final String uriPred, final String litObj) {
		this.bejh.removeLitStatOnAnonSubj(idSubj, uriPred, litObj);
		if (this.autoCommit) {
			this.commit();
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#removeReifStat(java.lang.String)
	 */
	public void removeReifStat(final String statUri) {
		this.bejh.removeReifStat(statUri);
		if (this.autoCommit) {
			this.commit();
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#removeResStatOnAnonSubj(java.lang.String, java.lang.String, java.lang.String)
	 */
	public void removeResStatOnAnonSubj(final String idSubj, final String uriPred, final String uriObj) {
		this.bejh.removeResStatOnAnonSubj(idSubj, uriPred, uriObj);
		if (this.autoCommit) {
			this.commit();
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#removeStatsOnAnonSubj(java.lang.String)
	 */
	public void removeStatsOnAnonSubj(final String idSubj) {
		this.bejh.removeStatsOnAnonSubj(idSubj);
		if (this.autoCommit) {
			this.commit();
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#removeStatWithAnonRes(java.lang.String)
	 */
	public void removeStatsWithAnonRes(final String idObj) {
		this.bejh.removeStatWithAnonRes(idObj);
	}

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.RDFWriterExtended#setNSPrefix(java.lang.String, java.lang.String)
	 */
	public Map<String, String> setNSPrefix(final String prefix, final String uri) {
		return this.bejh.setNSPrefix(prefix, uri);
	}

}
