/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.core.helper.impl;

import org.ow2.weblab.core.extended.util.PoKUtil;
import org.ow2.weblab.core.model.Annotation;
import org.ow2.weblab.core.model.Resource;

/**
 * This is the simplest implementation of the <code>ResourceHelperExtended</code>. It only loads every <code>Annotations</code> that are on this object. No
 * crawling of the <code>Resource</code>. If the loaded <code>Resource</code> is an <code>Annotation</code>, its content won't be loaded.
 * 
 * @author EADS WebLab Team
 * @date 2008-11-25
 * @todo Prevent the direct instantiation of this class.
 */
public class JenaSingleResourceHelperExtended extends JenaResourceHelperExtended {

	/*
	 * (non-Javadoc)
	 * @see org.weblab_project.core.helper.impl.JenaResourceHelper#addResource(org.weblab_project.core.model.Resource)
	 */
	@Override
	protected void addResource(final Resource res) {
		for (final Annotation a : res.getAnnotation()) {
			final String rdf = PoKUtil.getPoKData(a);
			if (!rdf.trim().equals("")) {
				this.loadFromRdfXml(rdf, true);
			}
		}
	}
}
