/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.helper;

import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.properties.PropertiesLoader;
import org.ow2.weblab.core.helper.PoKHelper;
import org.ow2.weblab.core.helper.PoKHelperExtended;
import org.ow2.weblab.core.helper.ResourceHelper;
import org.ow2.weblab.core.helper.ResourceHelperExtended;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Resource;

public class RDFHelperFactory {
    private static Class<? extends PoKHelper> pokHelpClass = null;
    private static Class<? extends PoKHelperExtended> pokHelpExtClass = null;
    private static String pokHelpExtImplClassName = null;
    private static String pokHelpImplClassName = null;
    public static final String FILENAME = "rdf-helper.properties";
    private static Class<? extends ResourceHelper> resHelpClass = null;
    private static Class<? extends ResourceHelperExtended> resHelpExtClass = null;
    private static String resHelpExtImplClassName = null;
    private static String resHelpImplClassName = null;

    private RDFHelperFactory() {
        throw new UnsupportedOperationException("This class only contains static methods; no need to instantiate it.");
    }

    private static PoKHelper getPOKHelp() {
        if (pokHelpClass == null) {
            pokHelpClass = RDFHelperFactory.loadDynamicClass(RDFHelperFactory.getPoKHelperImplClassName(), PoKHelper.class);
        }
        return RDFHelperFactory.getInstance(pokHelpClass);
    }

    public static PoKHelper getPoKHelper(PieceOfKnowledge pok) {
        PoKHelper h = RDFHelperFactory.getPOKHelp();
        h.setPoK(pok);
        return h;
    }

    public static PoKHelper getSpecificPoKHelper(PieceOfKnowledge pok, String pokHelperImpl) {
        Class<PoKHelper> clazz = RDFHelperFactory.loadDynamicClass(pokHelperImpl, PoKHelper.class);
        PoKHelper h = RDFHelperFactory.getInstance(clazz);
        h.setPoK(pok);
        return h;
    }

    private static PoKHelperExtended getPOKHelpExt() {
        if (pokHelpExtClass == null) {
            pokHelpExtClass = RDFHelperFactory.loadDynamicClass(RDFHelperFactory.getPoKHelperExtendedImplClassName(), PoKHelperExtended.class);
        }
        return RDFHelperFactory.getInstance(pokHelpExtClass);
    }

    public static PoKHelperExtended getPoKHelperExtended(PieceOfKnowledge pok) {
        PoKHelperExtended h = RDFHelperFactory.getPOKHelpExt();
        h.setPoK(pok);
        return h;
    }

    public static PoKHelperExtended getSpecificPoKHelperExtended(PieceOfKnowledge pok, String pokHelperExtImpl) {
        Class<PoKHelperExtended> clazz = RDFHelperFactory.loadDynamicClass(pokHelperExtImpl, PoKHelperExtended.class);
        PoKHelperExtended h = RDFHelperFactory.getInstance(clazz);
        h.setPoK(pok);
        return h;
    }

    public static String getPoKHelperExtendedImplClassName() {
        if (pokHelpExtImplClassName == null) {
            RDFHelperFactory.loadProperties();
        }
        return pokHelpExtImplClassName;
    }

    public static String getPoKHelperImplClassName() {
        if (pokHelpImplClassName == null) {
            RDFHelperFactory.loadProperties();
        }
        return pokHelpImplClassName;
    }

    private static <T> T getInstance(Class<T> classToInstantiate) {
        try {
            T ret = classToInstantiate.newInstance();
            LogFactory.getLog(RDFHelperFactory.class).trace((Object)("Instantiate: " + ret));
            return ret;
        }
        catch (InstantiationException ie) {
            throw new WebLabUncheckedException("Cannot instantiate " + classToInstantiate.getName() + ".", (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new WebLabUncheckedException("Cannot instantiate " + classToInstantiate.getName() + ".", (Throwable)iae);
        }
    }

    private static ResourceHelper getResHelp() {
        if (resHelpClass == null) {
            resHelpClass = RDFHelperFactory.loadDynamicClass(RDFHelperFactory.getResourceHelperImplClassName(), ResourceHelper.class);
        }
        return RDFHelperFactory.getInstance(resHelpClass);
    }

    private static ResourceHelperExtended getResHelpExt() {
        if (resHelpExtClass == null) {
            resHelpExtClass = RDFHelperFactory.loadDynamicClass(RDFHelperFactory.getResourceHelperExtendedImplClassName(), ResourceHelperExtended.class);
        }
        return RDFHelperFactory.getInstance(resHelpExtClass);
    }

    public static ResourceHelperExtended getResourceHelperExtended(Resource resource) {
        ResourceHelperExtended h = RDFHelperFactory.getResHelpExt();
        h.setResource(resource);
        return h;
    }

    public static ResourceHelperExtended getSpecificResourceHelperExtended(Resource resource, String resHelperExtImpl) {
        Class<ResourceHelperExtended> clazz = RDFHelperFactory.loadDynamicClass(resHelperExtImpl, ResourceHelperExtended.class);
        ResourceHelperExtended h = RDFHelperFactory.getInstance(clazz);
        h.setResource(resource);
        return h;
    }

    public static ResourceHelper getResourceHelper(Resource resource) {
        ResourceHelper h = RDFHelperFactory.getResHelp();
        h.setResource(resource);
        return h;
    }

    public static ResourceHelper getSpecificResourceHelper(Resource resource, String resHelperImpl) {
        Class<ResourceHelper> clazz = RDFHelperFactory.loadDynamicClass(resHelperImpl, ResourceHelper.class);
        ResourceHelper h = RDFHelperFactory.getInstance(clazz);
        h.setResource(resource);
        return h;
    }

    public static String getResourceHelperImplClassName() {
        if (resHelpImplClassName == null) {
            RDFHelperFactory.loadProperties();
        }
        return resHelpImplClassName;
    }

    public static String getResourceHelperExtendedImplClassName() {
        if (resHelpExtImplClassName == null) {
            RDFHelperFactory.loadProperties();
        }
        return resHelpExtImplClassName;
    }

    private static <T> Class<? extends T> loadDynamicClass(String className, Class<T> helperType) {
        try {
            Class<?> impl = RDFHelperFactory.class.getClassLoader().loadClass(className);
            if (!helperType.isAssignableFrom(impl)) {
                throw new ClassNotFoundException("Unable load the class: " + className + " as a " + helperType.getSimpleName());
            }
            Class<T> toReturn = impl.asSubclass(helperType);
            LogFactory.getLog(RDFHelperFactory.class).debug((Object)("Loaded: '" + className + "'; instance of '" + helperType.getSimpleName() + "'"));
            return toReturn;
        }
        catch (ClassNotFoundException cnfe) {
            throw new WebLabUncheckedException("Cannot instantiate " + className + ".", (Throwable)cnfe);
        }
    }

    private static void loadProperties() {
        String pokHelpStr = PoKHelper.class.getSimpleName().toLowerCase(Locale.ENGLISH);
        String pokHelpExtStr = PoKHelperExtended.class.getSimpleName().toLowerCase(Locale.ENGLISH);
        String resHelpStr = ResourceHelper.class.getSimpleName().toLowerCase(Locale.ENGLISH);
        String resHelpExtStr = ResourceHelperExtended.class.getSimpleName().toLowerCase(Locale.ENGLISH);
        HashSet<String> prop = new HashSet<String>();
        prop.add(pokHelpStr);
        prop.add(pokHelpExtStr);
        prop.add(resHelpStr);
        prop.add(resHelpExtStr);
        Map values = PropertiesLoader.loadProperties((String)FILENAME, RDFHelperFactory.class);
        pokHelpImplClassName = (String)values.get(pokHelpStr);
        pokHelpExtImplClassName = (String)values.get(pokHelpExtStr);
        resHelpImplClassName = (String)values.get(resHelpStr);
        resHelpExtImplClassName = (String)values.get(resHelpExtStr);
    }

    public static void setPoKHelperExtendedImplClassName(String pokHelperExtendedImplClassName) {
        pokHelpExtImplClassName = pokHelperExtendedImplClassName;
        pokHelpExtClass = null;
    }

    public static void setPoKHelperImplClassName(String pokHelperImplClassName) {
        pokHelpImplClassName = pokHelperImplClassName;
        pokHelpClass = null;
    }

    public static void setResourceHelperImplClassName(String resourceHelperImplClassName) {
        resHelpImplClassName = resourceHelperImplClassName;
        resHelpClass = null;
    }

    public static void setResourceHelperExtendedImplClassName(String resourceHelperExtendedImplClassName) {
        resHelpExtImplClassName = resourceHelperExtendedImplClassName;
        resHelpExtClass = null;
    }
}

