/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.helper.impl;

import java.util.List;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.exception.WebLabUncheckedException;
import org.ow2.weblab.core.extended.util.PoKUtil;
import org.ow2.weblab.core.helper.PoKHelper;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.utils.BackEndJenaHelper;

public class JenaPoKHelper
implements PoKHelper {
    protected PieceOfKnowledge pok;
    protected BackEndJenaHelper bejh;
    protected boolean autoCommit = true;

    @Override
    public Set<String> getSubjs() {
        return this.bejh.getSubjs();
    }

    @Override
    public Set<String> getPredsOnSubj(String uriSubj) {
        return this.bejh.getPredsOnSubj(uriSubj);
    }

    @Override
    public List<String> getLitsOnPredSubj(String uriSubj, String uriPred) {
        return this.bejh.getLitsOnPredSubj(uriSubj, uriPred);
    }

    @Override
    public List<String> getRessOnPredSubj(String uriSubj, String uriPred) {
        return this.bejh.getRessOnPredSubj(uriSubj, uriPred);
    }

    @Override
    public boolean hasLitStat(String uriSubj, String uriPred, String litObj) {
        return this.bejh.hasLitStat(uriSubj, uriPred, litObj);
    }

    @Override
    public boolean hasResStat(String uriSubj, String uriPred, String uriObj) {
        return this.bejh.hasResStat(uriSubj, uriPred, uriObj);
    }

    @Override
    public void createLitStat(String uriSubj, String uriPred, String litObj, String language) {
        this.bejh.createLitStat(uriSubj, uriPred, litObj, language);
        if (this.autoCommit) {
            this.commit();
        }
    }

    @Override
    public void createLitStat(String uriSubj, String uriPred, String litObj) {
        this.bejh.createLitStat(uriSubj, uriPred, litObj);
        if (this.autoCommit) {
            this.commit();
        }
    }

    @Override
    public void createResStat(String uriSubj, String uriPred, String uriObj) {
        this.bejh.createResStat(uriSubj, uriPred, uriObj);
        if (this.autoCommit) {
            this.commit();
        }
    }

    @Override
    public void removeLitStat(String uriSubj, String uriPred, String litObj) {
        this.bejh.removeLitStat(uriSubj, uriPred, litObj);
        if (this.autoCommit) {
            this.commit();
        }
    }

    @Override
    public void removeResStat(String uriSubj, String uriPred, String uriObj) {
        this.bejh.removeResStat(uriSubj, uriPred, uriObj);
        if (this.autoCommit) {
            this.commit();
        }
    }

    @Override
    public void removeStatsOnSubj(String uriSubj) {
        this.bejh.removeStatsOnSubj(uriSubj);
        if (this.autoCommit) {
            this.commit();
        }
    }

    @Override
    public void removeStatsWithPred(String uriPred) {
        this.bejh.removeStatsWithPred(uriPred);
        if (this.autoCommit) {
            this.commit();
        }
    }

    @Override
    public void removeStatsWithLit(String litObj) {
        this.bejh.removeStatsWithLit(litObj);
        if (this.autoCommit) {
            this.commit();
        }
    }

    @Override
    public void removeStatsWithRes(String uriObj) {
        this.bejh.removeStatsWithRes(uriObj);
        if (this.autoCommit) {
            this.commit();
        }
    }

    @Override
    public Set<String> getSubjsOnPred(String uriPred) {
        return this.bejh.getSubjsOnPred(uriPred);
    }

    @Override
    public Set<String> getSubjsOnPredLit(String uriPred, String litObj) {
        return this.bejh.getSubjsOnPredLit(uriPred, litObj);
    }

    @Override
    public Set<String> getSubjsOnPredRes(String uriPred, String uriObj) {
        return this.bejh.getSubjsOnPredRes(uriPred, uriObj);
    }

    @Override
    public void setAutoCommitMode(boolean autoCommitMode) {
        this.autoCommit = autoCommitMode;
    }

    @Override
    public void loadFromRdfXml(String rdfXml) throws WebLabCheckedException {
        this.bejh = new BackEndJenaHelper(rdfXml);
    }

    @Override
    public String getRdfXml() {
        if (this.bejh != null && this.pok != null) {
            return this.bejh.getRdfXml();
        }
        return "";
    }

    @Override
    public boolean isDefinedResource(String uri) {
        return this.bejh.isDefinedResource(uri);
    }

    @Override
    public void commit() {
        if (this.bejh != null && this.pok != null) {
            String data = this.getRdfXml();
            try {
                PoKUtil.setPoKData((PieceOfKnowledge)this.pok, (String)data);
            }
            catch (WebLabCheckedException wce) {
                throw new WebLabUncheckedException("Serialisation of Jena model failed. RDF/XML string appears to be invalid: " + data, (Throwable)wce);
            }
        } else {
            throw new WebLabUncheckedException("Annotation was not set.");
        }
    }

    @Override
    public PieceOfKnowledge getPoK() {
        return this.pok;
    }

    @Override
    public void setPoK(PieceOfKnowledge pok) {
        this.pok = pok;
        if (this.pok == null) {
            throw new WebLabUncheckedException("No PieceOfKnowledge to load.");
        }
        if (this.bejh != null) {
            this.bejh.close();
        }
        if (this.pok.getData() != null) {
            String data = PoKUtil.getPoKData((PieceOfKnowledge)this.pok);
            try {
                this.loadFromRdfXml(data);
            }
            catch (WebLabCheckedException wlce) {
                LogFactory.getLog(this.getClass()).warn((Object)"An error occurs loading the pok.");
                LogFactory.getLog(this.getClass()).trace((Object)data);
                this.bejh = new BackEndJenaHelper();
            }
        } else {
            this.bejh = new BackEndJenaHelper();
        }
    }

    @Override
    public Set<String> getPreds() {
        return this.bejh.getPreds();
    }

    @Override
    public List<String> getLitsOnPredSubj(String uriSubj, String uriPred, String language) {
        return this.bejh.getLitsOnPredSubj(uriSubj, uriPred, language);
    }
}

