/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.core.helper.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.util.PoKUtil;
import org.ow2.weblab.core.helper.ResourceHelper;
import org.ow2.weblab.core.model.Annotation;
import org.ow2.weblab.core.model.ComposedQuery;
import org.ow2.weblab.core.model.ComposedResource;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.LowLevelDescriptor;
import org.ow2.weblab.core.model.MediaUnit;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.model.SimilarityQuery;
import org.ow2.weblab.utils.BackEndJenaHelper;

public class JenaResourceHelper
implements ResourceHelper {
    protected Resource resource;
    protected Map<String, Resource> resourcesMap;
    protected BackEndJenaHelper bejh;

    @Override
    public Resource getResource(String uri) throws WebLabCheckedException {
        if (!this.isFullyDefinedResource(uri)) {
            throw new WebLabCheckedException("Cannot retrieve type for resource '" + uri + "'. Resource is not defined.");
        }
        return this.resourcesMap.get(uri);
    }

    @Override
    public <T extends Resource> T getSpecificResource(String uri, Class<T> specificClass) throws WebLabCheckedException {
        Resource res = this.getResource(uri);
        if (specificClass.isInstance(res)) {
            return (T)((Resource)specificClass.cast(res));
        }
        throw new WebLabCheckedException("Cannot retrieve Resource '" + uri + "'", (Throwable)new ClassCastException("Unable to cast resource: " + res.getUri() + " into a " + specificClass.getName() + " since its a " + res.getClass().getName()));
    }

    @Override
    public Class<? extends Resource> getType(String uri) throws WebLabCheckedException {
        Resource res = this.getResource(uri);
        return res.getClass();
    }

    @Override
    public void setResource(Resource resource) {
        if (this.bejh != null) {
            this.bejh.close();
        }
        this.bejh = new BackEndJenaHelper();
        this.resourcesMap = new HashMap<String, Resource>();
        this.addResource(resource);
        this.resource = resource;
    }

    protected void addResource(Resource res) {
        this.resourcesMap.put(res.getUri(), res);
        for (Annotation annot : res.getAnnotation()) {
            this.addResource((Resource)annot);
        }
        for (LowLevelDescriptor lld : res.getDescriptor()) {
            this.addResource((Resource)lld);
        }
        if (res instanceof MediaUnit) {
            this.addMediaUnit((MediaUnit)res);
        } else if (res instanceof PieceOfKnowledge) {
            this.addPieceOfKnowledge((PieceOfKnowledge)res);
        } else if (res instanceof ComposedResource) {
            this.addComposedResource((ComposedResource)res);
        } else if (res instanceof ResultSet) {
            this.addResultSet((ResultSet)res);
        } else if (res instanceof ComposedQuery) {
            this.addComposedQuery((ComposedQuery)res);
        } else if (res instanceof SimilarityQuery) {
            this.addSimilarityQuery((SimilarityQuery)res);
        }
    }

    protected void addSimilarityQuery(SimilarityQuery sq) {
        for (Resource r : sq.getResource()) {
            this.addResource(r);
        }
    }

    protected void addComposedQuery(ComposedQuery cq) {
        for (Query q : cq.getQuery()) {
            this.addResource((Resource)q);
        }
    }

    protected void addComposedResource(ComposedResource rc) {
        for (Resource r : rc.getResource()) {
            this.addResource(r);
        }
    }

    protected void addResultSet(ResultSet rs) {
        for (Resource r : rs.getResource()) {
            this.addResource(r);
        }
        PieceOfKnowledge p = rs.getPok();
        if (p != null) {
            this.addResource((Resource)p);
        }
    }

    protected void addPieceOfKnowledge(PieceOfKnowledge pok) {
        String rdf = PoKUtil.getPoKData((PieceOfKnowledge)pok);
        if (!rdf.trim().equals("")) {
            this.loadFromRdfXml(rdf, true);
        }
    }

    protected void addMediaUnit(MediaUnit mu) {
        if (mu instanceof Document) {
            this.addDocument((Document)mu);
        }
    }

    protected void addDocument(Document cu) {
        for (MediaUnit mu : cu.getMediaUnit()) {
            this.addResource((Resource)mu);
        }
    }

    @Override
    public List<String> getLitsOnPredSubj(String uriSubj, String uriPred) {
        return this.bejh.getLitsOnPredSubj(uriSubj, uriPred);
    }

    @Override
    public Set<String> getPredsOnSubj(String uriSubj) {
        return this.bejh.getPredsOnSubj(uriSubj);
    }

    @Override
    public List<String> getRessOnPredSubj(String uriSubj, String uriPred) {
        return this.bejh.getRessOnPredSubj(uriSubj, uriPred);
    }

    @Override
    public Set<String> getSubjs() {
        return this.bejh.getSubjs();
    }

    @Override
    public Set<String> getSubjsOnPred(String uriPred) {
        return this.bejh.getSubjsOnPred(uriPred);
    }

    @Override
    public Set<String> getSubjsOnPredLit(String uriPred, String litObj) {
        return this.bejh.getSubjsOnPredLit(uriPred, litObj);
    }

    @Override
    public Set<String> getSubjsOnPredRes(String uriPred, String uriObj) {
        return this.bejh.getSubjsOnPredRes(uriPred, uriObj);
    }

    @Override
    public boolean hasLitStat(String uriSubj, String uriPred, String litObj) {
        return this.bejh.hasLitStat(uriSubj, uriPred, litObj);
    }

    @Override
    public boolean hasResStat(String uriSubj, String uriPred, String uriObj) {
        return this.bejh.hasResStat(uriSubj, uriPred, uriObj);
    }

    @Override
    public boolean isDefinedResource(String uri) {
        return this.bejh.isDefinedResource(uri);
    }

    @Override
    public void loadFromRdfXml(String rdfXml) throws WebLabCheckedException {
        this.loadFromRdfXml(rdfXml, false);
    }

    protected void loadFromRdfXml(String rdfXml, boolean add) {
        if (add && this.bejh != null) {
            this.bejh.addToModel(rdfXml);
        } else {
            this.bejh = new BackEndJenaHelper(rdfXml);
        }
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public boolean isFullyDefinedResource(String uri) {
        return this.isDefinedResource(uri) && this.resourcesMap.containsKey(uri);
    }

    @Override
    public Set<String> getPreds() {
        return this.bejh.getPreds();
    }

    @Override
    public String getRdfXml() {
        if (this.bejh != null && this.resource != null) {
            return this.bejh.getRdfXml();
        }
        return "";
    }

    @Override
    public List<String> getLitsOnPredSubj(String uriSubj, String uriPred, String language) {
        return this.bejh.getLitsOnPredSubj(uriSubj, uriPred, language);
    }
}

