/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.utils;

import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.utils.RDFHelperException;

public class BackEndJenaHelper {
    private static final String SYNTAX = "RDF/XML";
    private static final String BASE = "";
    private Model model;
    private Model tempModel;

    public Set<String> getSubjs() {
        return this.getSubjects(ResourceTypes.NAMED);
    }

    public Set<String> getPredsOnSubj(String uriSubj) {
        if (uriSubj == null) {
            throw new RDFHelperException("uriSubj was null but shouldn't.");
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        return this.getPredicates(subj);
    }

    public List<String> getLitsOnPredSubj(String uriSubj, String uriPred, String language) {
        if (uriSubj == null || uriPred == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        return this.getObjects(subj, pred, RDFNodeTypes.LITERAL, language);
    }

    public List<String> getLitsOnPredSubj(String uriSubj, String uriPred) {
        return this.getLitsOnPredSubj(uriSubj, uriPred, null);
    }

    public List<String> getRessOnPredSubj(String uriSubj, String uriPred) {
        if (uriSubj == null || uriPred == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        return this.getObjects(subj, pred, RDFNodeTypes.NAMED_R);
    }

    public boolean hasLitStat(String uriSubj, String uriPred, String litObj) {
        if (uriSubj == null || uriPred == null || litObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " litObj:" + litObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Literal lit = this.createTempLit(litObj);
        return this.containsStatement(subj, pred, (RDFNode)lit);
    }

    public boolean hasResStat(String uriSubj, String uriPred, String uriObj) {
        if (uriSubj == null || uriPred == null || uriObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " uriObj:" + uriObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        return this.containsStatement(subj, pred, (RDFNode)obj);
    }

    public void createLitStat(String uriSubj, String uriPred, String litObj) {
        this.createLitStat(uriSubj, uriPred, litObj, null);
    }

    public void createLitStat(String uriSubj, String uriPred, String litObj, String language) {
        if (uriSubj == null || uriPred == null || litObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " litObj:" + litObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Literal lit = this.createTempLit(litObj, language);
        this.createStatement(subj, pred, (RDFNode)lit);
    }

    public void createResStat(String uriSubj, String uriPred, String uriObj) {
        if (uriSubj == null || uriPred == null || uriObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " uriObj:" + uriObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        this.createStatement(subj, pred, (RDFNode)obj);
    }

    public void removeLitStat(String uriSubj, String uriPred, String litObj) {
        if (uriSubj == null || uriPred == null || litObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " litObj:" + litObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Literal lit = this.createTempLit(litObj);
        this.removeStatement(subj, pred, (RDFNode)lit);
    }

    public void removeResStat(String uriSubj, String uriPred, String uriObj) {
        if (uriSubj == null || uriPred == null || uriObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " uriObj:" + uriObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        this.removeStatement(subj, pred, (RDFNode)obj);
    }

    public void removeStatsOnSubj(String uriSubj) {
        if (uriSubj == null) {
            throw new RDFHelperException("uriSubj was null but shouldn't.");
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        this.removeStatement(subj, null, null);
    }

    public void removeStatsWithPred(String uriPred) {
        if (uriPred == null) {
            throw new RDFHelperException("uriPred was null but shouldn't.");
        }
        Property pred = this.createTempProp(uriPred);
        this.removeStatement(null, pred, null);
    }

    public void removeStatsWithLit(String litObj) {
        if (litObj == null) {
            throw new RDFHelperException("litObj was null but shouldn't.");
        }
        Literal lit = this.createTempLit(litObj);
        this.removeStatement(null, null, (RDFNode)lit);
    }

    public void removeStatsWithRes(String uriObj) {
        if (uriObj == null) {
            throw new RDFHelperException("uriObj was null but shouldn't.");
        }
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        this.removeStatement(null, null, (RDFNode)obj);
    }

    public Set<String> getSubjsOnPred(String uriPred) {
        if (uriPred == null) {
            throw new RDFHelperException("uriPred was null but shouldn't.");
        }
        Property pred = this.createTempProp(uriPred);
        return this.getSubjects(pred, null, ResourceTypes.NAMED);
    }

    public Set<String> getSubjsOnPredLit(String uriPred, String litObj) {
        if (uriPred == null || litObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriPred:" + uriPred + " litObj:" + litObj);
        }
        Property pred = this.createTempProp(uriPred);
        Literal obj = this.createTempLit(litObj);
        return this.getSubjects(pred, (RDFNode)obj, ResourceTypes.NAMED);
    }

    public Set<String> getSubjsOnPredRes(String uriPred, String uriObj) {
        if (uriPred == null || uriObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriPred:" + uriPred + " uriObj:" + uriObj);
        }
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        return this.getSubjects(pred, (RDFNode)obj, ResourceTypes.NAMED);
    }

    public boolean isDefinedResource(String uri) {
        if (uri == null) {
            throw new RDFHelperException("Uri args were null but shouldn't.");
        }
        Resource res = this.createTempRes(uri, ResourceTypes.NAMED);
        return this.containsResource((RDFNode)res);
    }

    public void createAnonResStat(String uriSubj, String uriPred, String idObj) {
        if (uriSubj == null || uriPred == null || idObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " idObj:" + idObj);
        }
        Resource s = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        this.createStatement(s, pred, (RDFNode)obj);
    }

    public void createAnonResStatOnAnonSubj(String idSubj, String uriPred, String idObj) {
        if (idSubj == null || uriPred == null || idObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " idObj:" + idObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        this.createStatement(subj, pred, (RDFNode)obj);
    }

    public String createAnonResStatReif(String uriSubj, String uriPred, String idObj, Map<String, String> mapPredLit, Map<String, String> mapPredUri, Map<String, String> mapPredId) {
        return this.createAnonResStatReif(uriSubj, uriPred, idObj, mapPredLit, mapPredUri, mapPredId, null);
    }

    public String createAnonResStatReifOnAnonSubj(String idSubj, String uriPred, String idObj, Map<String, String> mapPredLit, Map<String, String> mapPredUri, Map<String, String> mapPredId) {
        return this.createAnonResStatReifOnAnonSubj(idSubj, uriPred, idObj, mapPredLit, mapPredUri, mapPredId, null);
    }

    public void createLitStatOnAnonSubj(String idSubj, String uriPred, String litObj) {
        if (idSubj == null || uriPred == null || litObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " litObj:" + litObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Literal lit = this.createTempLit(litObj);
        this.createStatement(subj, pred, (RDFNode)lit);
    }

    public String createLitStatReif(String uriSubj, String uriPred, String litObj, Map<String, String> mapPredLit, Map<String, String> mapPredUri, Map<String, String> mapPredId) {
        return this.createLitStatReif(uriSubj, uriPred, litObj, mapPredLit, mapPredUri, mapPredId, null);
    }

    public String createLitStatReifOnAnonSubj(String idSubj, String uriPred, String litObj, Map<String, String> mapPredLit, Map<String, String> mapPredUri, Map<String, String> mapPredId) {
        return this.createLitStatReifOnAnonSubj(idSubj, uriPred, litObj, mapPredLit, mapPredUri, mapPredId, null);
    }

    public void createResStatOnAnonSubj(String idSubj, String uriPred, String uriObj) {
        if (idSubj == null || uriPred == null || uriObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " uriObj:" + uriObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        this.createStatement(subj, pred, (RDFNode)obj);
    }

    public String createResStatReif(String uriSubj, String uriPred, String uriObj, Map<String, String> mapPredLit, Map<String, String> mapPredUri, Map<String, String> mapPredId) {
        return this.createResStatReif(uriSubj, uriPred, uriObj, mapPredLit, mapPredUri, mapPredId, null);
    }

    public String createResStatReifOnAnonSubj(String idSubj, String uriPred, String uriObj, Map<String, String> mapPredLit, Map<String, String> mapPredUri, Map<String, String> mapPredId) {
        return this.createResStatReifOnAnonSubj(idSubj, uriPred, uriObj, mapPredLit, mapPredUri, mapPredId, null);
    }

    public List<String> getAnonResOnPredAnonResStatReif(String uriSubj, String uriPred, String idObj, String uriReif) {
        if (uriSubj == null || uriPred == null || idObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " uriObj:" + idObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.ANON_R));
        }
        return objects;
    }

    public List<String> getAnonResOnPredAnonResStatReifOnAnonSubj(String idSubj, String uriPred, String idObj, String uriReif) {
        if (idSubj == null || uriPred == null || idObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " idObj:" + idObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.ANON_R));
        }
        return objects;
    }

    public List<String> getAnonResOnPredAnonSubj(String idSubj, String uriPred) {
        if (idSubj == null || uriPred == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        return this.getObjects(subj, pred, RDFNodeTypes.ANON_R);
    }

    public List<String> getAnonResOnPredLitStatReif(String uriSubj, String uriPred, String litObj, String uriReif) {
        if (uriSubj == null || uriPred == null || litObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " litObj:" + litObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Literal obj = this.createTempLit(litObj);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.ANON_R));
        }
        return objects;
    }

    public List<String> getAnonResOnPredLitStatReifOnAnonSubj(String idSubj, String uriPred, String litObj, String uriReif) {
        if (idSubj == null || uriPred == null || litObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " litObj:" + litObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Literal obj = this.createTempLit(litObj);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.ANON_R));
        }
        return objects;
    }

    public List<String> getAnonResOnPredResStatReif(String uriSubj, String uriPred, String uriObj, String uriReif) {
        if (uriSubj == null || uriPred == null || uriObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " uriObj:" + uriObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.ANON_R));
        }
        return objects;
    }

    public List<String> getAnonResOnPredResStatReifOnAnonSubj(String idSubj, String uriPred, String uriObj, String uriReif) {
        if (idSubj == null || uriPred == null || uriObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " uriObj:" + uriObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.ANON_R));
        }
        return objects;
    }

    public List<String> getAnonResOnPredSubj(String uriSubj, String uriPred) {
        if (uriSubj == null || uriPred == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred);
        }
        Resource s = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        return this.getObjects(s, pred, RDFNodeTypes.ANON_R);
    }

    public Set<String> getAnonSubj() {
        return this.getSubjects(ResourceTypes.ANON);
    }

    public Set<String> getAnonSubjOnPred(String uriPred) {
        if (uriPred == null) {
            throw new RDFHelperException("uriPred was null but shouldn't");
        }
        Property pred = this.createTempProp(uriPred);
        return this.getSubjects(pred, null, ResourceTypes.ANON);
    }

    public Set<String> getAnonSubjOnPredAnonRes(String uriPred, String idObj) {
        if (uriPred == null || idObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriPred:" + uriPred + " idObj:" + idObj);
        }
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        return this.getSubjects(pred, (RDFNode)obj, ResourceTypes.ANON);
    }

    public Set<String> getAnonSubjOnPredLit(String uriPred, String litObj) {
        if (uriPred == null || litObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriPred:" + uriPred + " litObj:" + litObj);
        }
        Property pred = this.createTempProp(uriPred);
        Literal obj = this.createTempLit(litObj);
        return this.getSubjects(pred, (RDFNode)obj, ResourceTypes.ANON);
    }

    public Set<String> getAnonSubjOnPredRes(String uriPred, String uriObj) {
        if (uriPred == null || uriObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriPred:" + uriPred + " uriObj:" + uriObj);
        }
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        return this.getSubjects(pred, (RDFNode)obj, ResourceTypes.ANON);
    }

    public List<String> getLitOnPredAnonResStatReif(String uriSubj, String uriPred, String idObj, String uriReif) {
        if (uriSubj == null || uriPred == null || idObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " idObj:" + idObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.LITERAL));
        }
        return objects;
    }

    public List<String> getLitOnPredAnonResStatReifOnAnonSubj(String idSubj, String uriPred, String idObj, String uriReif) {
        if (idSubj == null || uriPred == null || idObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + idSubj + " uriPred:" + uriPred + " idObj:" + idObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.LITERAL));
        }
        return objects;
    }

    public List<String> getLitOnPredAnonSubj(String idSubj, String uriPred) {
        if (idSubj == null || uriPred == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        return this.getObjects(subj, pred, RDFNodeTypes.LITERAL);
    }

    public List<String> getLitOnPredLitStatReif(String uriSubj, String uriPred, String litObj, String uriReif) {
        if (uriSubj == null || uriPred == null || litObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " litObj:" + litObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Literal obj = this.createTempLit(litObj);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.LITERAL));
        }
        return objects;
    }

    public List<String> getLitOnPredLitStatReifOnAnonSubj(String idSubj, String uriPred, String litObj, String uriReif) {
        if (idSubj == null || uriPred == null || litObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " litObj:" + litObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Literal obj = this.createTempLit(litObj);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.LITERAL));
        }
        return objects;
    }

    public List<String> getLitOnPredResStatReif(String uriSubj, String uriPred, String uriObj, String uriReif) {
        if (uriSubj == null || uriPred == null || uriObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " uriObj:" + uriObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.LITERAL));
        }
        return objects;
    }

    public List<String> getLitsOnPredResStatReifOnAnonSubj(String idSubj, String uriPred, String uriObj, String uriReif) {
        if (idSubj == null || uriPred == null || uriObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " uriObj:" + uriObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.LITERAL));
        }
        return objects;
    }

    public Set<String> getPredOnAnonResStatReif(String uriSubj, String uriPred, String idObj) {
        if (uriSubj == null || uriPred == null || idObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " idObj:" + idObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        HashSet<String> preds = new HashSet<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            preds.addAll(this.getPredicates((Resource)rs));
        }
        return preds;
    }

    public Set<String> getPredOnAnonResStatReifOnAnonSubj(String idSubj, String uriPred, String idObj) {
        if (idSubj == null || uriPred == null || idObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " idObj:" + idObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        HashSet<String> preds = new HashSet<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            preds.addAll(this.getPredicates((Resource)rs));
        }
        return preds;
    }

    public Set<String> getPredOnAnonSubj(String idSubj) {
        if (idSubj == null) {
            throw new RDFHelperException("idSubj was null but shouldn't.");
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        return this.getPredicates(subj);
    }

    public Set<String> getPredOnLitStatReif(String uriSubj, String uriPred, String litObj) {
        if (uriSubj == null || uriPred == null || litObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " litObj:" + litObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Literal obj = this.createTempLit(litObj);
        HashSet<String> preds = new HashSet<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            preds.addAll(this.getPredicates((Resource)rs));
        }
        return preds;
    }

    public Set<String> getPredOnLitStatReifOnAnonSubj(String idSubj, String uriPred, String litObj) {
        if (idSubj == null || uriPred == null || litObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " litObj:" + litObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Literal obj = this.createTempLit(litObj);
        HashSet<String> preds = new HashSet<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            preds.addAll(this.getPredicates((Resource)rs));
        }
        return preds;
    }

    public Set<String> getPredOnResStatReif(String uriSubj, String uriPred, String uriObj) {
        if (uriSubj == null || uriPred == null || uriObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " uriObj:" + uriObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        HashSet<String> preds = new HashSet<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            preds.addAll(this.getPredicates((Resource)rs));
        }
        return preds;
    }

    public Set<String> getPredOnResStatReifOnAnonSubj(String idSubj, String uriPred, String uriObj) {
        if (idSubj == null || uriPred == null || uriObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " uriObj:" + uriObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        HashSet<String> preds = new HashSet<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            preds.addAll(this.getPredicates((Resource)rs));
        }
        return preds;
    }

    public List<String> getResOnPredAnonResStatReif(String uriSubj, String uriPred, String idObj, String uriReif) {
        if (uriSubj == null || uriPred == null || idObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " idObj:" + idObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.NAMED_R));
        }
        return objects;
    }

    public List<String> getResOnPredAnonResStatReifOnAnonSubj(String idSubj, String uriPred, String idObj, String uriReif) {
        if (idSubj == null || uriPred == null || idObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " idObj:" + idObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.NAMED_R));
        }
        return objects;
    }

    public List<String> getResOnPredAnonSubj(String idSubj, String uriPred) {
        if (idSubj == null || uriPred == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        return this.getObjects(subj, pred, RDFNodeTypes.NAMED_R);
    }

    public List<String> getResOnPredLitStatReif(String uriSubj, String uriPred, String litObj, String uriReif) {
        if (uriSubj == null || uriPred == null || litObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " litObj:" + litObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Literal obj = this.createTempLit(litObj);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.NAMED_R));
        }
        return objects;
    }

    public List<String> getResOnPredLitStatReifOnAnonSubj(String idSubj, String uriPred, String litObj, String uriReif) {
        if (idSubj == null || uriPred == null || litObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " litObj:" + litObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Literal obj = this.createTempLit(litObj);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.NAMED_R));
        }
        return objects;
    }

    public List<String> getResOnPredResStatReif(String uriSubj, String uriPred, String uriObj, String uriReif) {
        if (uriSubj == null || uriPred == null || uriObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " uriObj:" + uriObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.NAMED_R));
        }
        return objects;
    }

    public List<String> getResOnPredResStatReifOnAnonSubj(String idSubj, String uriPred, String uriObj, String uriReif) {
        if (idSubj == null || uriPred == null || uriObj == null || uriReif == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " uriObj:" + uriObj + " uriReif:" + uriReif);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Property p = this.createTempProp(uriReif);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        ArrayList<String> objects = new ArrayList<String>();
        for (ReifiedStatement rs : this.getReifStats(subj, pred, (RDFNode)obj)) {
            objects.addAll(this.getObjects((Resource)rs, p, RDFNodeTypes.NAMED_R));
        }
        return objects;
    }

    public Set<String> getSubjOnPredAnonRes(String uriPred, String idObj) {
        if (uriPred == null || idObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriPred:" + uriPred + " idObj:" + idObj);
        }
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        return this.getSubjects(pred, (RDFNode)obj, ResourceTypes.NAMED);
    }

    public boolean hasAnonResStat(String uriSubj, String uriPred, String idObj) {
        if (uriSubj == null || uriPred == null || idObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " idObj:" + idObj);
        }
        Resource s = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        return this.containsStatement(s, pred, (RDFNode)obj);
    }

    public boolean hasAnonResStatOnAnonSubj(String idSubj, String uriPred, String idObj) {
        if (idSubj == null || uriPred == null || idObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " idObj:" + idObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        return this.containsStatement(subj, pred, (RDFNode)obj);
    }

    public boolean hasLitStatOnAnonSubj(String idSubj, String uriPred, String litObj) {
        if (idSubj == null || uriPred == null || litObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " litObj:" + litObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Literal lit = this.createTempLit(litObj);
        return this.containsStatement(subj, pred, (RDFNode)lit);
    }

    public boolean hasResStatOnAnonSubj(String idSubj, String uriPred, String uriObj) {
        if (idSubj == null || uriPred == null || uriObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " uriObj:" + uriObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        return this.containsStatement(subj, pred, (RDFNode)obj);
    }

    public boolean isAnonResStatReif(String uriSubj, String uriPred, String idObj) {
        if (uriSubj == null || uriPred == null || idObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " idObj:" + idObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        return this.isReified(subj, pred, (RDFNode)obj);
    }

    public boolean isAnonResStatReifOnAnonSubj(String idSubj, String uriPred, String idObj) {
        if (idSubj == null || uriPred == null || idObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " idObj:" + idObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        return this.isReified(subj, pred, (RDFNode)obj);
    }

    public boolean isDefinedAnonRes(String id) {
        Resource res = this.createTempRes(id, ResourceTypes.ANON);
        return this.containsResource((RDFNode)res);
    }

    public boolean isLitStatReif(String uriSubj, String uriPred, String litObj) {
        if (uriSubj == null || uriPred == null || litObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " litObj:" + litObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Literal obj = this.createTempLit(litObj);
        return this.isReified(subj, pred, (RDFNode)obj);
    }

    public boolean isLitStatReifOnAnonSubj(String idSubj, String uriPred, String litObj) {
        if (idSubj == null || uriPred == null || litObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " litObj:" + litObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Literal obj = this.createTempLit(litObj);
        return this.isReified(subj, pred, (RDFNode)obj);
    }

    public boolean isResStatReif(String uriSubj, String uriPred, String uriObj) {
        if (uriSubj == null || uriPred == null || uriObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " uriObj:" + uriObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        return this.isReified(subj, pred, (RDFNode)obj);
    }

    public boolean isResStatReifOnAnonSubj(String idSubj, String uriPred, String uriObj) {
        if (idSubj == null || uriPred == null || uriObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " uriObj:" + uriObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        return this.isReified(subj, pred, (RDFNode)obj);
    }

    public void removeAnonResStat(String uriSubj, String uriPred, String idObj) {
        if (uriSubj == null || uriPred == null || idObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " idObj:" + idObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        this.removeStatement(subj, pred, (RDFNode)obj);
    }

    public void removeAnonResStatOnAnonSubj(String idSubj, String uriPred, String idObj) {
        if (idSubj == null || uriPred == null || idObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " idObj:" + idObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        this.removeStatement(subj, pred, (RDFNode)obj);
    }

    public void removeLitStatOnAnonSubj(String idSubj, String uriPred, String litObj) {
        if (idSubj == null || uriPred == null || litObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " litObj:" + litObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Literal obj = this.createTempLit(litObj);
        this.removeStatement(subj, pred, (RDFNode)obj);
    }

    public void removeResStatOnAnonSubj(String idSubj, String uriPred, String uriObj) {
        if (idSubj == null || uriPred == null || uriObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " uriObj:" + uriObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        this.removeStatement(subj, pred, (RDFNode)obj);
    }

    public void removeStatsOnAnonSubj(String idSubj) {
        if (idSubj == null) {
            throw new RDFHelperException("idSubj was null but shouldn't.");
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        this.removeStatement(subj, null, null);
    }

    public void removeStatWithAnonRes(String idObj) {
        if (idObj == null) {
            throw new RDFHelperException("idObj was null but shouldn't.");
        }
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        this.removeStatement(null, null, (RDFNode)obj);
    }

    public List<String> getAnonReifStats() {
        return this.listReifiedStatements(ResourceTypes.ANON);
    }

    public String getAnonResOfAnonReifStat(String statId) {
        if (statId == null) {
            throw new RDFHelperException("statId was null but shouldn't.");
        }
        ReifiedStatement rs = this.getSpecifiedReifStat(statId, ResourceTypes.ANON);
        if (rs != null) {
            return this.getReifiedStatementObject(rs, RDFNodeTypes.ANON_R);
        }
        return null;
    }

    public String getAnonResOnReifStat(String statUri) {
        if (statUri == null) {
            throw new RDFHelperException("statUri was null but shouldn't.");
        }
        ReifiedStatement rs = this.getSpecifiedReifStat(statUri, ResourceTypes.NAMED);
        if (rs != null) {
            return this.getReifiedStatementObject(rs, RDFNodeTypes.ANON_R);
        }
        return null;
    }

    public String getAnonSubjOfAnonReifStat(String statId) {
        if (statId == null) {
            throw new RDFHelperException("statId was null but shouldn't.");
        }
        ReifiedStatement rs = this.getSpecifiedReifStat(statId, ResourceTypes.ANON);
        if (rs != null) {
            return this.getReifiedStatementSubject(rs, ResourceTypes.ANON);
        }
        return null;
    }

    public String getAnonSubjOfReifStat(String statUri) {
        if (statUri == null) {
            throw new RDFHelperException("statUri was null but shouldn't.");
        }
        ReifiedStatement rs = this.getSpecifiedReifStat(statUri, ResourceTypes.NAMED);
        if (rs != null) {
            return this.getReifiedStatementSubject(rs, ResourceTypes.ANON);
        }
        return null;
    }

    public String getLitOfAnonReifStat(String statId) {
        if (statId == null) {
            throw new RDFHelperException("statId was null but shouldn't.");
        }
        ReifiedStatement rs = this.getSpecifiedReifStat(statId, ResourceTypes.ANON);
        if (rs != null) {
            return this.getReifiedStatementObject(rs, RDFNodeTypes.LITERAL);
        }
        return null;
    }

    public String getLitOfReifStat(String statUri) {
        if (statUri == null) {
            throw new RDFHelperException("statUri was null but shouldn't.");
        }
        ReifiedStatement rs = this.getSpecifiedReifStat(statUri, ResourceTypes.NAMED);
        if (rs != null) {
            return this.getReifiedStatementObject(rs, RDFNodeTypes.LITERAL);
        }
        return null;
    }

    public String getPredOfAnonReifStat(String statId) {
        if (statId == null) {
            throw new RDFHelperException("statId was null but shouldn't.");
        }
        ReifiedStatement rs = this.getSpecifiedReifStat(statId, ResourceTypes.ANON);
        if (rs != null) {
            return this.getReifiedStatementPredicate(rs);
        }
        return null;
    }

    public String getPredOfReifStat(String statUri) {
        if (statUri == null) {
            throw new RDFHelperException("statUri was null but shouldn't.");
        }
        ReifiedStatement rs = this.getSpecifiedReifStat(statUri, ResourceTypes.NAMED);
        if (rs != null) {
            return this.getReifiedStatementPredicate(rs);
        }
        return null;
    }

    public List<String> getReifStats() {
        return this.listReifiedStatements(ResourceTypes.NAMED);
    }

    public String getResOfAnonReifStat(String statId) {
        if (statId == null) {
            throw new RDFHelperException("statId was null but shouldn't.");
        }
        ReifiedStatement rs = this.getSpecifiedReifStat(statId, ResourceTypes.ANON);
        if (rs != null) {
            return this.getReifiedStatementObject(rs, RDFNodeTypes.NAMED_R);
        }
        return null;
    }

    public String getResOfReifStat(String statUri) {
        if (statUri == null) {
            throw new RDFHelperException("statUri was null but shouldn't.");
        }
        ReifiedStatement rs = this.getSpecifiedReifStat(statUri, ResourceTypes.NAMED);
        if (rs != null) {
            return this.getReifiedStatementObject(rs, RDFNodeTypes.NAMED_R);
        }
        return null;
    }

    public String getSubjOfAnonReifStat(String statId) {
        if (statId == null) {
            throw new RDFHelperException("statId was null but shouldn't.");
        }
        ReifiedStatement rs = this.getSpecifiedReifStat(statId, ResourceTypes.ANON);
        if (rs != null) {
            return this.getReifiedStatementSubject(rs, ResourceTypes.NAMED);
        }
        return null;
    }

    public String getSubjOfReifStat(String statUri) {
        if (statUri == null) {
            throw new RDFHelperException("statUri was null but shouldn't.");
        }
        ReifiedStatement rs = this.getSpecifiedReifStat(statUri, ResourceTypes.NAMED);
        if (rs != null) {
            return this.getReifiedStatementSubject(rs, ResourceTypes.NAMED);
        }
        return null;
    }

    public String createAnonResStatReif(String uriSubj, String uriPred, String idObj, Map<String, String> mapPredLit, Map<String, String> mapPredUri, Map<String, String> mapPredId, String statUri) {
        if (uriSubj == null || uriPred == null || idObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " idObj:" + idObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        HashMap<Property, RDFNode> map = new HashMap<Property, RDFNode>();
        map.putAll(this.convertReifMap(mapPredLit, RDFNodeTypes.LITERAL));
        map.putAll(this.convertReifMap(mapPredUri, RDFNodeTypes.NAMED_R));
        map.putAll(this.convertReifMap(mapPredId, RDFNodeTypes.ANON_R));
        String toRet = this.createReifiedStatement(subj, pred, (RDFNode)obj, map, statUri);
        return toRet;
    }

    public String createAnonResStatReifOnAnonSubj(String idSubj, String uriPred, String idObj, Map<String, String> mapPredLit, Map<String, String> mapPredUri, Map<String, String> mapPredId, String statUri) {
        if (idSubj == null || uriPred == null || idObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " idObj:" + idObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(idObj, ResourceTypes.ANON);
        HashMap<Property, RDFNode> map = new HashMap<Property, RDFNode>();
        map.putAll(this.convertReifMap(mapPredLit, RDFNodeTypes.LITERAL));
        map.putAll(this.convertReifMap(mapPredUri, RDFNodeTypes.NAMED_R));
        map.putAll(this.convertReifMap(mapPredId, RDFNodeTypes.ANON_R));
        String toRet = this.createReifiedStatement(subj, pred, (RDFNode)obj, map, statUri);
        return toRet;
    }

    public String createLitStatReif(String uriSubj, String uriPred, String litObj, Map<String, String> mapPredLit, Map<String, String> mapPredUri, Map<String, String> mapPredId, String statUri) {
        if (uriSubj == null || uriPred == null || litObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " litObj:" + litObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Literal lit = this.createTempLit(litObj);
        HashMap<Property, RDFNode> map = new HashMap<Property, RDFNode>();
        map.putAll(this.convertReifMap(mapPredLit, RDFNodeTypes.LITERAL));
        map.putAll(this.convertReifMap(mapPredUri, RDFNodeTypes.NAMED_R));
        map.putAll(this.convertReifMap(mapPredId, RDFNodeTypes.ANON_R));
        String toRet = this.createReifiedStatement(subj, pred, (RDFNode)lit, map, statUri);
        return toRet;
    }

    public String createLitStatReifOnAnonSubj(String idSubj, String uriPred, String litObj, Map<String, String> mapPredLit, Map<String, String> mapPredUri, Map<String, String> mapPredId, String statUri) {
        if (idSubj == null || uriPred == null || litObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " litObj:" + litObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Literal lit = this.createTempLit(litObj);
        HashMap<Property, RDFNode> map = new HashMap<Property, RDFNode>();
        map.putAll(this.convertReifMap(mapPredLit, RDFNodeTypes.LITERAL));
        map.putAll(this.convertReifMap(mapPredUri, RDFNodeTypes.NAMED_R));
        map.putAll(this.convertReifMap(mapPredId, RDFNodeTypes.ANON_R));
        String toRet = this.createReifiedStatement(subj, pred, (RDFNode)lit, map, statUri);
        return toRet;
    }

    public String createResStatReif(String uriSubj, String uriPred, String uriObj, Map<String, String> mapPredLit, Map<String, String> mapPredUri, Map<String, String> mapPredId, String statUri) {
        if (uriSubj == null || uriPred == null || uriObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. uriSubj:" + uriSubj + " uriPred:" + uriPred + " uriObj:" + uriObj);
        }
        Resource subj = this.createTempRes(uriSubj, ResourceTypes.NAMED);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        HashMap<Property, RDFNode> map = new HashMap<Property, RDFNode>();
        map.putAll(this.convertReifMap(mapPredLit, RDFNodeTypes.LITERAL));
        map.putAll(this.convertReifMap(mapPredUri, RDFNodeTypes.NAMED_R));
        map.putAll(this.convertReifMap(mapPredId, RDFNodeTypes.ANON_R));
        String toRet = this.createReifiedStatement(subj, pred, (RDFNode)obj, map, statUri);
        return toRet;
    }

    public String createResStatReifOnAnonSubj(String idSubj, String uriPred, String uriObj, Map<String, String> mapPredLit, Map<String, String> mapPredUri, Map<String, String> mapPredId, String statUri) {
        if (idSubj == null || uriPred == null || uriObj == null) {
            throw new RDFHelperException("Some args were null but shouldn't. idSubj:" + idSubj + " uriPred:" + uriPred + " uriObj:" + uriObj);
        }
        Resource subj = this.createTempRes(idSubj, ResourceTypes.ANON);
        Property pred = this.createTempProp(uriPred);
        Resource obj = this.createTempRes(uriObj, ResourceTypes.NAMED);
        HashMap<Property, RDFNode> map = new HashMap<Property, RDFNode>();
        map.putAll(this.convertReifMap(mapPredLit, RDFNodeTypes.LITERAL));
        map.putAll(this.convertReifMap(mapPredUri, RDFNodeTypes.NAMED_R));
        map.putAll(this.convertReifMap(mapPredId, RDFNodeTypes.ANON_R));
        String toRet = this.createReifiedStatement(subj, pred, (RDFNode)obj, map, statUri);
        return toRet;
    }

    public void removeAnonReifStat(String statId) {
        ReifiedStatement rs = this.getSpecifiedReifStat(statId, ResourceTypes.ANON);
        if (rs != null) {
            this.removeReification(rs);
        }
    }

    public void removeReifStat(String statUri) {
        ReifiedStatement rs = this.getSpecifiedReifStat(statUri, ResourceTypes.NAMED);
        if (rs != null) {
            this.removeReification(rs);
        }
    }

    public List<String> getAnonResOnPredAnonStatReif(String statId, String uriPred) {
        if (statId == null || uriPred == null) {
            throw new RDFHelperException("Some args were null but shouldn't. statId:" + statId + " uriPred:" + uriPred);
        }
        Property pred = this.createTempProp(uriPred);
        ReifiedStatement rs = this.getSpecifiedReifStat(statId, ResourceTypes.ANON);
        if (rs == null) {
            return new ArrayList<String>();
        }
        return this.getObjects((Resource)rs, pred, RDFNodeTypes.ANON_R);
    }

    public List<String> getAnonResOnPredStatReif(String statUri, String uriPred) {
        if (statUri == null || uriPred == null) {
            throw new RDFHelperException("Some args were null but shouldn't. statUri:" + statUri + " uriPred:" + uriPred);
        }
        Property pred = this.createTempProp(uriPred);
        ReifiedStatement rs = this.getSpecifiedReifStat(statUri, ResourceTypes.NAMED);
        if (rs == null) {
            return new ArrayList<String>();
        }
        return this.getObjects((Resource)rs, pred, RDFNodeTypes.ANON_R);
    }

    public List<String> getLitOnPredAnonStatReif(String statId, String uriPred) {
        if (statId == null || uriPred == null) {
            throw new RDFHelperException("Some args were null but shouldn't. statId:" + statId + " uriPred:" + uriPred);
        }
        Property pred = this.createTempProp(uriPred);
        ReifiedStatement rs = this.getSpecifiedReifStat(statId, ResourceTypes.ANON);
        if (rs == null) {
            return new ArrayList<String>();
        }
        return this.getObjects((Resource)rs, pred, RDFNodeTypes.LITERAL);
    }

    public List<String> getLitsOnPredStatReif(String statUri, String uriPred) {
        if (statUri == null || uriPred == null) {
            throw new RDFHelperException("Some args were null but shouldn't. statUri:" + statUri + " uriPred:" + uriPred);
        }
        Property pred = this.createTempProp(uriPred);
        ReifiedStatement rs = this.getSpecifiedReifStat(statUri, ResourceTypes.NAMED);
        if (rs == null) {
            return new ArrayList<String>();
        }
        return this.getObjects((Resource)rs, pred, RDFNodeTypes.LITERAL);
    }

    public Set<String> getPredOnAnonStatReif(String statId) {
        if (statId == null) {
            throw new RDFHelperException("statId was null");
        }
        ReifiedStatement rs = this.getSpecifiedReifStat(statId, ResourceTypes.ANON);
        if (rs == null) {
            return new HashSet<String>();
        }
        return this.getPredicates((Resource)rs);
    }

    public Set<String> getPredOnStatReif(String statUri) {
        if (statUri == null) {
            throw new RDFHelperException("statUri was null");
        }
        ReifiedStatement rs = this.getSpecifiedReifStat(statUri, ResourceTypes.NAMED);
        if (rs == null) {
            return new HashSet<String>();
        }
        return this.getPredicates((Resource)rs);
    }

    public List<String> getResOnPredAnonStatReif(String statId, String uriPred) {
        if (statId == null || uriPred == null) {
            throw new RDFHelperException("Some args were null but shouldn't. statId:" + statId + " uriPred:" + uriPred);
        }
        Property pred = this.createTempProp(uriPred);
        ReifiedStatement rs = this.getSpecifiedReifStat(statId, ResourceTypes.ANON);
        ArrayList<String> toRet = new ArrayList<String>();
        if (rs == null) {
            return toRet;
        }
        return this.getObjects((Resource)rs, pred, RDFNodeTypes.NAMED_R);
    }

    public List<String> getResOnPredStatReif(String statUri, String uriPred) {
        if (statUri == null || uriPred == null) {
            throw new RDFHelperException("Some args were null but shouldn't. statUri:" + statUri + " uriPred:" + uriPred);
        }
        Property pred = this.createTempProp(uriPred);
        ReifiedStatement rs = this.getSpecifiedReifStat(statUri, ResourceTypes.NAMED);
        ArrayList<String> toRet = new ArrayList<String>();
        if (rs == null) {
            return toRet;
        }
        return this.getObjects((Resource)rs, pred, RDFNodeTypes.NAMED_R);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model modelFromFile(File file, String baseUri, String lang) throws IOException {
        FileInputStream fis;
        Model aModel = ModelFactory.createDefaultModel();
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            LogFactory.getLog(BackEndJenaHelper.class).warn((Object)("File " + file.getAbsolutePath() + " not found."), (Throwable)fnfe);
            throw fnfe;
        }
        try {
            aModel.read((InputStream)fis, baseUri, lang);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ioe) {
                LogFactory.getLog(BackEndJenaHelper.class).warn((Object)("Error wile closing stream on file: " + file.getAbsolutePath() + "."), (Throwable)ioe);
            }
        }
        return aModel;
    }

    public BackEndJenaHelper() {
        new ARP().getOptions().setStrictErrorMode();
        this.model = ModelFactory.createDefaultModel();
        this.tempModel = ModelFactory.createDefaultModel();
    }

    public BackEndJenaHelper(Model model) {
        new ARP().getOptions().setStrictErrorMode();
        this.addToModel(model);
    }

    public BackEndJenaHelper(String rdfXml) {
        new ARP().getOptions().setStrictErrorMode();
        this.addToModel(rdfXml);
    }

    public void addToModel(Model modelToAdd) {
        if (this.model == null) {
            this.model = ModelFactory.createDefaultModel();
        }
        if (this.tempModel == null) {
            this.tempModel = ModelFactory.createDefaultModel();
        }
        this.model.add(modelToAdd);
    }

    public void addToModel(String rdfXml) {
        if (this.model == null) {
            this.model = ModelFactory.createDefaultModel();
        }
        if (this.tempModel == null) {
            this.tempModel = ModelFactory.createDefaultModel();
        }
        if (rdfXml == null || rdfXml.equals(BASE)) {
            throw new RDFHelperException("Args was null or empty.");
        }
        StringReader sr = new StringReader(rdfXml);
        this.model.read((Reader)sr, BASE, SYNTAX);
        sr.close();
    }

    public Model getModel() {
        return this.model;
    }

    protected Resource createTempRes(String uriOrId, ResourceTypes resType) {
        if (resType.equals((Object)ResourceTypes.NAMED)) {
            return this.tempModel.createResource(uriOrId);
        }
        if (resType.equals((Object)ResourceTypes.ANON)) {
            AnonId a = AnonId.create((String)uriOrId);
            return this.tempModel.createResource(a);
        }
        throw new RDFHelperException("Unexpected error. Using a type that is not defined: " + resType.name() + "-" + resType.ordinal());
    }

    protected Literal createTempLit(String value) {
        return this.createTempLit(value, null);
    }

    protected Literal createTempLit(String value, String language) {
        return this.tempModel.createLiteral(value, language);
    }

    protected Property createTempProp(String uri) {
        return this.tempModel.createProperty(uri);
    }

    protected boolean containsResource(RDFNode node) {
        return this.model.containsResource(node);
    }

    protected Set<String> getSubjects(Property pred, RDFNode obj, ResourceTypes resType) {
        List<Statement> stats = this.listStatements();
        if (obj != null) {
            ListIterator<Statement> it = stats.listIterator();
            while (it.hasNext()) {
                Statement stat = it.next();
                if (stat.getObject().equals(obj)) continue;
                it.remove();
            }
        }
        HashSet<String> subjs = new HashSet<String>();
        for (Statement stat : stats) {
            if (!pred.equals(stat.getPredicate())) continue;
            Resource subj = stat.getSubject();
            if (resType.equals((Object)ResourceTypes.NAMED) && subj.isURIResource()) {
                subjs.add(subj.getURI());
                continue;
            }
            if (!resType.equals((Object)ResourceTypes.ANON) || !subj.isAnon()) continue;
            subjs.add(subj.getId().getLabelString());
        }
        return subjs;
    }

    protected List<String> getObjects(Resource subj, Property pred, RDFNodeTypes nodeType) {
        return this.getObjects(subj, pred, nodeType, null);
    }

    protected List<String> getObjects(Resource subj, Property pred, RDFNodeTypes nodeType, String language) {
        List<Statement> stats = this.listStatements();
        if (subj != null) {
            ListIterator<Statement> it = stats.listIterator();
            while (it.hasNext()) {
                Statement stat = it.next();
                if (stat.getSubject().equals(subj)) continue;
                it.remove();
            }
        }
        ArrayList<String> objs = new ArrayList<String>();
        for (Statement stat : stats) {
            if (!pred.equals(stat.getPredicate())) continue;
            RDFNode obj = stat.getObject();
            if (nodeType.equals((Object)RDFNodeTypes.ANON_R) && obj.isAnon()) {
                objs.add(((Resource)obj).getId().getLabelString());
                continue;
            }
            if (nodeType.equals((Object)RDFNodeTypes.LITERAL) && obj.isLiteral()) {
                if (language != null && ((Literal)obj).getLanguage().equals(language)) {
                    objs.add(((Literal)obj).getLexicalForm());
                    continue;
                }
                if (language != null) continue;
                objs.add(((Literal)obj).getLexicalForm());
                continue;
            }
            if (!nodeType.equals((Object)RDFNodeTypes.NAMED_R) || !obj.isURIResource()) continue;
            objs.add(((Resource)obj).getURI());
        }
        return objs;
    }

    protected Set<String> getPredicates(Resource subj) {
        List<Statement> stats = this.listStatements();
        HashSet<String> preds = new HashSet<String>();
        for (Statement stat : stats) {
            if (!subj.equals(stat.getSubject())) continue;
            preds.add(stat.getPredicate().getURI());
        }
        return preds;
    }

    protected Set<String> getSubjects(ResourceTypes resType) {
        List<Statement> stats = this.listStatements();
        HashSet<String> subjs = new HashSet<String>();
        for (Statement stat : stats) {
            Resource subj = stat.getSubject();
            if (resType.equals((Object)ResourceTypes.NAMED) && subj.isURIResource()) {
                subjs.add(subj.getURI());
                continue;
            }
            if (!resType.equals((Object)ResourceTypes.ANON) || !subj.isAnon()) continue;
            subjs.add(subj.getId().getLabelString());
        }
        return subjs;
    }

    protected List<Statement> listStatements() {
        ArrayList<Statement> stats = new ArrayList<Statement>();
        StmtIterator sit = this.model.listStatements();
        while (sit.hasNext()) {
            Statement stat = sit.nextStatement();
            if (stat.getPredicate().equals(RDF.subject) || stat.getPredicate().equals(RDF.predicate) || stat.getPredicate().equals(RDF.object)) continue;
            if (stat.getPredicate().equals(RDF.type) && stat.getObject().isResource()) {
                if (((Resource)stat.getObject()).equals(RDF.Statement)) continue;
                stats.add(stat);
                continue;
            }
            stats.add(stat);
        }
        sit.close();
        RSIterator rsit = this.model.listReifiedStatements();
        while (rsit.hasNext()) {
            stats.add(rsit.nextRS().getStatement());
        }
        rsit.close();
        return stats;
    }

    protected Statement createStatement(Resource subj, Property pred, RDFNode obj, boolean add) {
        if (!this.containsStatement(subj, pred, obj) && add) {
            this.model.add(this.model.createStatement(subj, pred, obj));
        }
        return this.model.createStatement(subj, pred, obj);
    }

    protected Statement createStatement(Resource subj, Property pred, RDFNode obj) {
        if (!this.containsStatement(subj, pred, obj)) {
            this.model.add(this.model.createStatement(subj, pred, obj));
        }
        return this.model.createStatement(subj, pred, obj);
    }

    protected String createReifiedStatement(Resource subj, Property pred, RDFNode obj, Map<Property, RDFNode> reifs, String uri) {
        ReifiedStatement rst = uri == null ? this.model.createReifiedStatement(this.createStatement(subj, pred, obj, false)) : this.model.createReifiedStatement(uri, this.createStatement(subj, pred, obj, false));
        for (Map.Entry<Property, RDFNode> entry : reifs.entrySet()) {
            rst.addProperty(entry.getKey(), entry.getValue());
        }
        if (uri == null) {
            return rst.getId().getLabelString();
        }
        return rst.getURI();
    }

    protected void removeStatement(Resource subj, Property pred, RDFNode obj) {
        if (subj == null || pred == null || obj == null) {
            StmtIterator sit = this.model.listStatements(subj, pred, obj);
            while (sit.hasNext()) {
                Statement s = sit.nextStatement();
                this.model.removeAllReifications(s);
            }
            sit.close();
            this.model.removeAll(subj, pred, obj);
        } else {
            Statement s = this.buildTempStatement(subj, pred, obj);
            this.model.removeAllReifications(s);
            this.model.remove(s);
        }
        for (Statement s : this.listStatements()) {
            if (subj != null && !s.getSubject().equals(subj) || pred != null && !s.getPredicate().equals(pred) || obj != null && !s.getObject().equals(obj)) continue;
            if (s.isReified()) {
                RSIterator rsit = this.model.listReifiedStatements(s);
                while (rsit.hasNext()) {
                    ReifiedStatement rs = rsit.nextRS();
                    this.model.removeAll((Resource)rs, null, null);
                    this.model.removeAll(null, null, (RDFNode)rs);
                }
                rsit.close();
            }
            this.model.removeAllReifications(s);
            this.model.remove(s);
        }
    }

    protected boolean containsStatement(Resource subj, Property pred, RDFNode obj) {
        if (!this.model.contains(subj, pred, obj)) {
            if (subj != null && pred != null && obj != null) {
                Statement s = this.buildTempStatement(subj, pred, obj);
                return this.model.isReified(s);
            }
            return false;
        }
        return true;
    }

    public String getRdfXml() {
        LinkedList<String> prefixToRemove = new LinkedList<String>();
        for (String prefix : this.model.getNsPrefixMap().keySet()) {
            if (!prefix.toString().startsWith("j.")) continue;
            prefixToRemove.add(prefix.toString());
        }
        for (String prefix : prefixToRemove) {
            this.model.removeNsPrefix(prefix);
        }
        StringWriter writer = new StringWriter();
        try {
            this.model.write((Writer)writer, SYNTAX);
        }
        catch (Exception e) {
            throw new RDFHelperException("Serialisation of Jena model failed. RDF/XMLstring appears to be invalid: " + writer.toString(), e);
        }
        return writer.toString().replace("\r", BASE);
    }

    protected Map<Property, RDFNode> convertReifMap(Map<String, String> reifs, RDFNodeTypes objType) {
        HashMap<Property, RDFNode> result;
        block5: {
            block6: {
                block4: {
                    if (reifs == null) {
                        return new HashMap<Property, RDFNode>();
                    }
                    result = new HashMap<Property, RDFNode>(reifs.size());
                    if (!objType.equals((Object)RDFNodeTypes.LITERAL)) break block4;
                    for (Map.Entry<String, String> entry : reifs.entrySet()) {
                        result.put(this.createTempProp(entry.getKey()), (RDFNode)this.createTempLit(entry.getValue()));
                    }
                    break block5;
                }
                if (!objType.equals((Object)RDFNodeTypes.NAMED_R)) break block6;
                for (Map.Entry<String, String> entry : reifs.entrySet()) {
                    result.put(this.createTempProp(entry.getKey()), (RDFNode)this.createTempRes(entry.getValue(), ResourceTypes.NAMED));
                }
                break block5;
            }
            if (!objType.equals((Object)RDFNodeTypes.ANON_R)) break block5;
            for (Map.Entry<String, String> entry : reifs.entrySet()) {
                result.put(this.createTempProp(entry.getKey()), (RDFNode)this.createTempRes(entry.getValue(), ResourceTypes.ANON));
            }
        }
        return result;
    }

    protected List<ReifiedStatement> getReifStats(Resource subj, Property pred, RDFNode obj) {
        Statement s;
        ArrayList<ReifiedStatement> reifs = new ArrayList<ReifiedStatement>();
        if (this.containsStatement(subj, pred, obj) && (s = this.createStatement(subj, pred, obj, false)).isReified()) {
            RSIterator rsit = s.listReifiedStatements();
            while (rsit.hasNext()) {
                reifs.add(rsit.nextRS());
            }
            rsit.close();
        }
        return reifs;
    }

    protected boolean isReified(Resource subj, Property pred, RDFNode obj) {
        Statement s = this.buildTempStatement(subj, pred, obj);
        return this.model.isReified(s);
    }

    private Statement buildTempStatement(Resource subj, Property pred, RDFNode obj) {
        return this.tempModel.createStatement(subj, pred, obj);
    }

    private static Map<String, String> convertNSMap(Map<?, ?> prefixMap) {
        HashMap<String, String> ret = new HashMap<String, String>(prefixMap.size());
        for (Map.Entry<?, ?> entry : prefixMap.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            ret.put((String)entry.getKey(), (String)entry.getValue());
        }
        return ret;
    }

    public Map<String, String> setNSPrefix(String prefix, String uri) {
        if (this.model != null && prefix != null && uri != null && !prefix.equals(BASE) && !uri.equals(BASE)) {
            Map map = this.model.setNsPrefix(prefix, uri).getNsPrefixMap();
            return BackEndJenaHelper.convertNSMap(map);
        }
        return this.getNSPrefixes();
    }

    public Map<String, String> getNSPrefixes() {
        if (this.model != null) {
            return BackEndJenaHelper.convertNSMap(this.model.getNsPrefixMap());
        }
        return new HashMap<String, String>(0);
    }

    public List<String> listReifiedStatements(ResourceTypes type) {
        ArrayList<String> idsOrUris = new ArrayList<String>();
        if (type.equals((Object)ResourceTypes.ANON)) {
            for (ReifiedStatement rs : this.listReifStats(type)) {
                idsOrUris.add(rs.getId().getLabelString());
            }
        } else if (type.equals((Object)ResourceTypes.NAMED)) {
            for (ReifiedStatement rs : this.listReifStats(type)) {
                idsOrUris.add(rs.getURI());
            }
        } else {
            LogFactory.getLog(this.getClass()).warn((Object)"Error in listReifiedStatement ResourceType was neither an anon nor a named resource...");
        }
        return idsOrUris;
    }

    private List<ReifiedStatement> listReifStats(ResourceTypes type) {
        RSIterator rsi = this.model.listReifiedStatements();
        ArrayList<ReifiedStatement> rss = new ArrayList<ReifiedStatement>();
        if (type.equals((Object)ResourceTypes.ANON)) {
            while (rsi.hasNext()) {
                ReifiedStatement rs = rsi.nextRS();
                if (!rs.isAnon()) continue;
                rss.add(rs);
            }
        } else if (type.equals((Object)ResourceTypes.NAMED)) {
            while (rsi.hasNext()) {
                ReifiedStatement rs = rsi.nextRS();
                if (!rs.isURIResource()) continue;
                rss.add(rs);
            }
        } else {
            LogFactory.getLog(this.getClass()).warn((Object)"Error in listReifiedStatement ResourceType was neither an anon nor a named resource...");
        }
        rsi.close();
        return rss;
    }

    protected ReifiedStatement getSpecifiedReifStat(String idOrUri, ResourceTypes type) {
        ReifiedStatement toRet = null;
        if (type.equals((Object)ResourceTypes.ANON)) {
            for (ReifiedStatement rs : this.listReifStats(type)) {
                if (!rs.getId().getLabelString().equals(idOrUri)) continue;
                toRet = rs;
                break;
            }
        } else {
            for (ReifiedStatement rs : this.listReifStats(type)) {
                if (!rs.getURI().equals(idOrUri)) continue;
                toRet = rs;
                break;
            }
        }
        return toRet;
    }

    protected String getReifiedStatementSubject(ReifiedStatement rs, ResourceTypes type) {
        String toRet = null;
        Resource subj = rs.getStatement().getSubject();
        if (type.equals((Object)ResourceTypes.ANON) && subj.isAnon()) {
            toRet = subj.getId().getLabelString();
        } else if (type.equals((Object)ResourceTypes.NAMED) && subj.isURIResource()) {
            toRet = subj.getURI();
        }
        return toRet;
    }

    protected String getReifiedStatementObject(ReifiedStatement rs, RDFNodeTypes type) {
        String toRet = null;
        RDFNode obj = rs.getStatement().getObject();
        if (type.equals((Object)RDFNodeTypes.ANON_R) && obj.isAnon()) {
            toRet = ((Resource)obj).getId().getLabelString();
        } else if (type.equals((Object)RDFNodeTypes.LITERAL) && obj.isLiteral()) {
            toRet = ((Literal)obj).getLexicalForm();
        } else if (type.equals((Object)RDFNodeTypes.NAMED_R) && obj.isURIResource()) {
            toRet = ((Resource)obj).getURI();
        }
        return toRet;
    }

    protected String getReifiedStatementPredicate(ReifiedStatement rs) {
        return rs.getStatement().getPredicate().getURI();
    }

    protected void removeReification(ReifiedStatement rs) {
        this.removeStatement((Resource)rs, null, null);
        this.model.removeReification(rs);
    }

    public Set<String> getPreds() {
        HashSet<String> preds = new HashSet<String>();
        for (Statement stat : this.listStatements()) {
            preds.add(stat.getPredicate().getURI());
        }
        return preds;
    }

    public void close() {
        this.model.close();
        this.tempModel.close();
        this.tempModel = ModelFactory.createDefaultModel();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.tempModel.close();
        this.model.close();
    }

    public static enum RDFNodeTypes {
        NAMED_R,
        ANON_R,
        LITERAL;

    }

    public static enum ResourceTypes {
        NAMED,
        ANON;

    }
}

