/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.crawler.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ExtensionFilter
implements FileFilter {
    protected List<String> extensions;
    protected boolean rejectMode = false;

    public ExtensionFilter(List<String> extentions, boolean rejectMode) {
        this.rejectMode = rejectMode;
        this.extensions = new ArrayList<String>();
        if (extentions != null) {
            this.extensions.addAll(extentions);
        }
    }

    @Override
    public boolean accept(File file) {
        return file.isFile() && this.extensions.contains(ExtensionFilter.getFileExtension(file)) != this.rejectMode;
    }

    public static String getFileExtension(File file) {
        String[] splited = file.getName().split("\\.");
        if (splited.length > 0) {
            return splited[splited.length - 1].toLowerCase(Locale.getDefault());
        }
        return "";
    }
}

