package org.ow2.weblab.iterator.service;

import javax.annotation.PostConstruct;
import javax.jws.WebService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.model.ComposedResource;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.SourceReader;
import org.ow2.weblab.core.services.queuemanager.NextResourceArgs;
import org.ow2.weblab.core.services.queuemanager.NextResourceReturn;
import org.ow2.weblab.core.services.sourcereader.GetResourceArgs;
import org.ow2.weblab.core.services.sourcereader.GetResourceReturn;
import org.ow2.weblab.iterator.FolderResourceIterator;
/**
 * Old service relying on SourceReader interface
 * @deprecated Use FolderResourceIteraor instead
 * @date
 */
@WebService(endpointInterface = "org.ow2.weblab.core.services.SourceReader")
public class WLResourceIterator implements SourceReader {

	public static Log LOGGER = LogFactory.getLog(WLResourceIterator.class);

	protected final static String PROPERTY_FILE = "resourceiterator.properties";
	protected final static String PROPERTY_NAME = "folderpath";

	public static FolderResourceIterator resourceIterator;

	@PostConstruct
	public void init() throws Exception {
		resourceIterator = new FolderResourceIterator();
		resourceIterator.init();
	}

	@Override
	public synchronized GetResourceReturn getResource(GetResourceArgs args) throws InsufficientResourcesException {
		GetResourceReturn ret = new GetResourceReturn();
		ComposedResource retCol = ResourceFactory.createResource("svn-resource-iterator", "" + System.nanoTime(), ComposedResource.class);
		try {
			NextResourceReturn nret = resourceIterator.nextResource(new NextResourceArgs());
			retCol.getResource().add(nret.getResource());
			ret.setResources(retCol);
			return ret;
		} catch (Exception e) {
			throw new InsufficientResourcesException("No more resources.", "Insufficient resources.", e);
		}
	}
}
