/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.iterator;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.jaxb.WebLabMarshaller;
import org.ow2.weblab.core.extended.properties.PropertiesLoader;
import org.ow2.weblab.core.model.Document;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.services.AccessDeniedException;
import org.ow2.weblab.core.services.ContentNotAvailableException;
import org.ow2.weblab.core.services.EmptyQueueException;
import org.ow2.weblab.core.services.InsufficientResourcesException;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.QueueManager;
import org.ow2.weblab.core.services.ServiceNotConfiguredException;
import org.ow2.weblab.core.services.UnexpectedException;
import org.ow2.weblab.core.services.UnsupportedRequestException;
import org.ow2.weblab.core.services.queuemanager.NextResourceArgs;
import org.ow2.weblab.core.services.queuemanager.NextResourceReturn;

@WebService(endpointInterface="org.ow2.weblab.core.services.QueueManager")
public class FolderResourceIterator
implements QueueManager {
    public static Log LOGGER = LogFactory.getLog(FolderResourceIterator.class);
    protected static final String PROPERTY_FILE = "resourceiterator.properties";
    protected static final String PROPERTY_NAME = "folderpath";
    protected WebLabMarshaller webLabMarshaller = new WebLabMarshaller();
    protected static File folder;
    protected static String folderPath;
    protected static LinkedList<String> resourceList;

    protected int loadResources() throws IOException {
        String[] filePaths = folder.list();
        if (filePaths == null) {
            throw new IOException("Folder " + folder.getAbsolutePath() + " is invalid.");
        }
        for (String filePath : filePaths) {
            resourceList.add(filePath);
        }
        if (resourceList.size() > 0) {
            LOGGER.info((Object)(resourceList.size() + " items added."));
        } else {
            LOGGER.warn((Object)"Reach the end of resources iterator list.");
        }
        return resourceList.size();
    }

    @PostConstruct
    public void init() throws IOException {
        if (folder == null) {
            String folderPath = (String)PropertiesLoader.loadProperties((String)PROPERTY_FILE).get(PROPERTY_NAME);
            if (folderPath == null) {
                String errorMsg = "Unable to read property 'folderpath' in property file: resourceiterator.properties";
                LOGGER.error((Object)errorMsg);
                throw new IOException(errorMsg);
            }
            folder = new File(folderPath);
            FolderResourceIterator.folderPath = folder.getAbsolutePath();
            if (!FolderResourceIterator.folderPath.endsWith(File.separator)) {
                FolderResourceIterator.folderPath = FolderResourceIterator.folderPath + File.separator;
            }
            if (!folder.exists() && !folder.mkdirs()) {
                throw new IOException("Unable to create folder " + folder.getAbsolutePath());
            }
            if (!folder.isDirectory()) {
                throw new IOException("File " + folder.getAbsolutePath() + " is invalid, not a directory.");
            }
            this.loadResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource loadNextResource() {
        Resource res = null;
        while (res == null && !resourceList.isEmpty()) {
            File file = new File(folderPath + (String)resourceList.getFirst());
            resourceList.removeFirst();
            try {
                res = this.webLabMarshaller.unmarshal(file, Document.class);
            }
            catch (WebLabCheckedException e) {
                LOGGER.warn((Object)("Unable to unmarshal resource : " + e.getMessage()));
            }
            finally {
                file.delete();
            }
        }
        return res;
    }

    protected boolean hasNext() {
        if (resourceList.isEmpty()) {
            try {
                this.loadResources();
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
        return resourceList.size() > 0;
    }

    public NextResourceReturn nextResource(NextResourceArgs args) throws AccessDeniedException, ContentNotAvailableException, EmptyQueueException, InsufficientResourcesException, InvalidParameterException, ServiceNotConfiguredException, UnexpectedException, UnsupportedRequestException {
        LinkedList linkedList = resourceList;
        synchronized (linkedList) {
            if (this.hasNext()) {
                Resource res = this.loadNextResource();
                if (res == null) {
                    throw new EmptyQueueException("No more resources.", "Insufficient resources.");
                }
                LOGGER.trace((Object)("Resource " + res.getUri() + " loaded."));
                NextResourceReturn ret = new NextResourceReturn();
                ret.setResource(res);
                return ret;
            }
            throw new EmptyQueueException("No more resources.", "Insufficient resources.");
        }
    }

    public static String getFolderPath() {
        return folderPath;
    }

    public static int getNbResources() {
        return resourceList.size();
    }

    static {
        resourceList = new LinkedList();
    }
}

