/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.portlet;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.extended.util.ServiceUtil;
import org.ow2.weblab.core.helper.BeanHelper;
import org.ow2.weblab.core.helper.impl.AdvancedSelector;
import org.ow2.weblab.core.helper.impl.IPredicateValuePairs;
import org.ow2.weblab.core.helper.impl.RDFSelectorFactory;
import org.ow2.weblab.core.helper.impl.Statements;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.StringQuery;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.Searcher;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;
import org.ow2.weblab.core.services.searcher.SearchArgs;
import org.ow2.weblab.core.services.searcher.SearchReturn;
import org.ow2.weblab.portlet.WebLabPortlet;
import org.ow2.weblab.portlet.tool.AdvancedSearchConfigBean;
import org.ow2.weblab.portlet.tool.AdvancedSearchFieldBean;
import org.ow2.weblab.portlet.tool.DateFieldBean;
import org.ow2.weblab.portlet.tool.SearchServiceBean;
import org.ow2.weblab.portlet.tool.TextFieldBean;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdvancedSearchPortlet
extends WebLabPortlet {
    private static Log logger = LogFactory.getLog(AdvancedSearchPortlet.class);
    private static final String DEFAULT_SEARCH = "def_mess";
    private static final String NEXT_DOCUMENTS_REACTION = "sendNextDocuments";
    private static final String NEXT_DOCUMENTS_ACTION = "nextDocuments";
    public static String TEXT_KEYWORDS_INPUT = "textInput";
    public static String LAST_TEXT_KEYWORDS_INPUT = "lastTextInput";
    public static String QUERY_INPUT = "queryInput";
    public static String SUBMIT_INPUT = "submitInput";
    public static String USER_LAST_SEARCH = "user_last_search";
    public static String USER_ESB_CONF = "user_esb_conf";
    public static String SEARCH_ERROR = "searcher_error";
    public static String ESB_CONFIG_NAME = "esb_config_bean";
    public static String SEARCH_SERVICES_MAP = "search_services_map";
    public static String DISPLAY_CHECKING_POPUP = "display_checking_popup";
    public static String SEARCH_SERVICE = "searchServiceInput";
    public static String LAST_SEARCH_SERVICE = "last_search_service";
    public static String NATIVE_SYNTAX = "native_syntax";
    public static String NATIVE_SYNTAX_DISPLAYED = "native_syntax_displayed";
    private static String OFFSET_PROPERTY = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasExpectedOffset";
    private static String LIMIT_PROPERTY = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasExpectedLimit";
    private static String HTML_CONTENT_TYPE = "text/html; charset=utf-8";
    private static String TEXT_CONTENT_TYPE = "text/plain; charset=utf-8";
    private static String SEARCH_ACTION = "search";
    private static URL SEARCHER_WSDL_LOCATION;
    private static URL ANALYSER_WSDL_LOCATION;
    private static Map<String, Searcher> searchers;
    private static Map<String, Analyser> translators;
    private AdvancedSearchConfigBean advanced_search_conf;
    private static int distinct_submit_query;
    private static boolean USE_REDIRECTION;
    private static final SimpleDateFormat DATE_FORMAT;
    private static final Date OLDEST_DATE;

    public void init() throws PortletException {
        super.init();
        this.advanced_search_conf = (AdvancedSearchConfigBean)BeanHelper.getInstance().getSpecificInstance(AdvancedSearchConfigBean.DEFAULT_CONF_FILE, true).getBean(AdvancedSearchConfigBean.DEFAULT_BEAN_NAME, AdvancedSearchConfigBean.class);
        try {
            try {
                SEARCHER_WSDL_LOCATION = new File(this.getPortletContext().getRealPath("WEB-INF/classes/services/WebLab.wsdl")).toURI().toURL();
                ANALYSER_WSDL_LOCATION = new File(this.getPortletContext().getRealPath("WEB-INF/classes/services/WebLab.wsdl")).toURI().toURL();
            }
            catch (MalformedURLException e) {
                logger.error((Object)e);
            }
            searchers = new HashMap();
            translators = new HashMap();
            for (String serviceId : this.advanced_search_conf.getSearchServices().keySet()) {
                SearchServiceBean serviceBean = (SearchServiceBean)this.advanced_search_conf.getSearchServices().get(serviceId);
                Searcher searcher = ServiceUtil.getSearcherService((URL)SEARCHER_WSDL_LOCATION, (URL)new URL(serviceBean.getURI()));
                searchers.put(serviceId, searcher);
                if (serviceBean.getTranslationURI() == null || serviceBean.getTranslationURI().isEmpty()) continue;
                Analyser translator = ServiceUtil.getAnalyserService((URL)ANALYSER_WSDL_LOCATION, (URL)new URL(serviceBean.getTranslationURI()));
                translators.put(serviceId, translator);
            }
        }
        catch (MalformedURLException e1) {
            logger.error((Object)("invalid init paramter :" + e1));
        }
        USE_REDIRECTION = this.getInitParameter("use_redirection") != null ? Boolean.parseBoolean(this.getInitParameter("use_redirection")) : false;
        distinct_submit_query = 0;
    }

    public void destroy() {
        super.destroy();
    }

    public void doView(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        PortletRequestDispatcher rd;
        if (req.getParameter(SEARCH_ERROR) != null) {
            req.setAttribute(SEARCH_ERROR, (Object)req.getParameter(SEARCH_ERROR));
            logger.info((Object)"error in searcher");
            rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("error_page_url"));
            rd.include(req, res);
        }
        if (req.getPortletSession().getAttribute(LAST_TEXT_KEYWORDS_INPUT) == null) {
            req.setAttribute(LAST_TEXT_KEYWORDS_INPUT, (Object)ResourceBundle.getBundle("search_portlet", req.getLocale()).getString("search.defaultText"));
            req.setAttribute("def_mess", (Object)true);
        } else {
            req.setAttribute(LAST_TEXT_KEYWORDS_INPUT, req.getPortletSession().getAttribute(LAST_TEXT_KEYWORDS_INPUT));
            req.setAttribute("def_mess", (Object)false);
        }
        req.setAttribute(SEARCH_SERVICES_MAP, (Object)this.advanced_search_conf.getSearchServices());
        req.setAttribute(DISPLAY_CHECKING_POPUP, (Object)this.advanced_search_conf.isDisplayCheckingPopup());
        if (req.getPortletSession().getAttribute(LAST_SEARCH_SERVICE) == null) {
            if (this.advanced_search_conf.getSearchServices().keySet().toArray().length > 0) {
                req.setAttribute(LAST_SEARCH_SERVICE, this.advanced_search_conf.getSearchServices().keySet().toArray()[0]);
            }
        } else {
            req.setAttribute(LAST_SEARCH_SERVICE, req.getPortletSession().getAttribute(LAST_SEARCH_SERVICE));
        }
        if (req.getPortletSession().getAttribute(NATIVE_SYNTAX) == null) {
            req.setAttribute(NATIVE_SYNTAX, (Object)false);
        } else {
            req.setAttribute(NATIVE_SYNTAX, req.getPortletSession().getAttribute(NATIVE_SYNTAX));
        }
        req.setAttribute(NATIVE_SYNTAX_DISPLAYED, (Object)this.advanced_search_conf.isNativeSyntaxOptionDisplayed());
        rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("search_page_url"));
        rd.include(req, res);
    }

    public void doEdit(RenderRequest req, RenderResponse res) throws PortletException, IOException {
        PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("edit_page_url"));
        rd.include(req, res);
    }

    public void processAction(ActionRequest req, ActionResponse res) throws IOException, PortletException {
        String form_name = req.getParameter("form_name");
        if (form_name != null && form_name.equals("search_query")) {
            List advancedSearchFieldList = AdvancedSearchPortlet.getFieldListFromParameters((Map)req.getParameterMap());
            req.getPortletSession().setAttribute("AdvancedSearchFieldBeanList", (Object)advancedSearchFieldList);
            req.getPortletSession().setAttribute("AdvancedSearchTextSearch", (Object)req.getParameter(TEXT_KEYWORDS_INPUT));
            String query = AdvancedSearchPortlet.generateQuery((String)req.getParameter(TEXT_KEYWORDS_INPUT), (List)advancedSearchFieldList);
            StringQuery q = (StringQuery)ResourceFactory.createResource((String)(this.getDefaultNamespace() + this.getPortletName()), (String)("queryID_" + distinct_submit_query++), StringQuery.class);
            q.setRequest(query);
            logger.info((Object)("Query sent to index : " + q.getRequest()));
            SearchArgs args = new SearchArgs();
            args.setLimit(Integer.valueOf(10));
            args.setOffset(Integer.valueOf(0));
            args.setQuery((Query)q);
            req.getPortletSession().setAttribute(LAST_TEXT_KEYWORDS_INPUT, (Object)req.getParameter(TEXT_KEYWORDS_INPUT));
            req.getPortletSession().setAttribute(USER_LAST_SEARCH, (Object)args);
            req.getPortletSession().setAttribute(LAST_SEARCH_SERVICE, (Object)req.getParameter(SEARCH_SERVICE));
            if (req.getParameter("searchBox_nativeSyntax") != null && req.getParameter("searchBox_nativeSyntax").equals("on")) {
                req.getPortletSession().setAttribute(NATIVE_SYNTAX, (Object)true);
            } else {
                req.getPortletSession().setAttribute(NATIVE_SYNTAX, (Object)false);
            }
            if (q.getRequest() != null && q.getRequest() != "") {
                Searcher searcherToUse = (Searcher)searchers.get(req.getParameter(SEARCH_SERVICE));
                logger.info((Object)(req.getParameter(SEARCH_SERVICE) + " searcher is used."));
                try {
                    if (searcherToUse != null) {
                        SearchReturn searchResult = searcherToUse.search(args);
                        if (USE_REDIRECTION) {
                            this.sendEventForActionAndRedirect(SEARCH_ACTION, (Resource)searchResult.getResultSet(), res);
                        } else {
                            this.sendEventForAction(SEARCH_ACTION, (Resource)searchResult.getResultSet(), res);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    res.setRenderParameter(SEARCH_ERROR, e.getMessage());
                }
            }
        }
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        if (request.getParameter("page_part").equals("advancedSearchField")) {
            ArrayList fieldList = (ArrayList)request.getPortletSession().getAttribute("AdvancedSearchFieldBeanList");
            if (fieldList == null) {
                fieldList = new ArrayList();
            }
            request.setAttribute("advancedSearchStructure", fieldList);
            request.setAttribute("boolean_conditions", (Object)this.advanced_search_conf.getBooleanConditions());
            request.setAttribute("advanced_search_fields", (Object)this.advanced_search_conf.getAdvancedSearchFields());
            response.setContentType(HTML_CONTENT_TYPE);
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("advanced_search_field_page_url"));
            rd.include((PortletRequest)request, (PortletResponse)response);
        } else if (request.getParameter("page_part").equals("nativeSyntax")) {
            Analyser translatorToUse = (Analyser)translators.get(request.getParameter("searchServiceInput"));
            logger.info((Object)(request.getParameter("searchServiceInput") + " translator is used."));
            List fieldList = AdvancedSearchPortlet.getFieldListFromParameters((Map)request.getParameterMap());
            String query = AdvancedSearchPortlet.generateQuery((String)request.getParameter(TEXT_KEYWORDS_INPUT), (List)fieldList);
            StringQuery q = (StringQuery)ResourceFactory.createResource((String)(this.getDefaultNamespace() + this.getPortletName()), (String)("queryID_" + distinct_submit_query++), StringQuery.class);
            q.setRequest(query);
            ProcessArgs translatorArgs = new ProcessArgs();
            translatorArgs.setResource((Resource)q);
            if (translatorToUse != null) {
                try {
                    ProcessReturn translatorResult = translatorToUse.process(translatorArgs);
                    StringQuery resultQuery = (StringQuery)translatorResult.getResource();
                    logger.info((Object)("query translated : " + resultQuery.getRequest()));
                    response.setContentType(TEXT_CONTENT_TYPE);
                    response.getWriter().print(resultQuery.getRequest());
                }
                catch (Exception pe) {
                    logger.error((Object)pe);
                    response.setProperty(SEARCH_ERROR, pe.getMessage());
                }
            } else {
                response.setContentType(TEXT_CONTENT_TYPE);
                response.getWriter().print(query);
            }
            response.getWriter().flush();
        } else if (request.getParameter("page_part").equals("advancedSearchNewLine")) {
            boolean launchFormAfter = false;
            if (request.getParameter("launchFormAfter") != null) {
                launchFormAfter = Boolean.parseBoolean(request.getParameter("launchFormAfter"));
            }
            int position = 0;
            if (request.getParameter("position") != null) {
                position = Integer.parseInt(request.getParameter("position"));
            }
            if (request.getParameter("booleanCondition") != null && request.getParameter("fieldName") != null && request.getParameter("fieldValue") != null && request.getParameter("fieldListValue") != null && request.getParameter("fieldBeforeValue") != null && request.getParameter("fieldAfterValue") != null) {
                TextFieldBean newLine;
                String booleanCondition = request.getParameter("booleanCondition");
                String[] fieldTypeAndName = request.getParameter("fieldName").split(":");
                String fieldType = fieldTypeAndName[0];
                String fieldName = fieldTypeAndName[1];
                if (fieldType.equals("date")) {
                    String beforeValue = "";
                    if (request.getParameter("fieldBeforeValue") != null && !request.getParameter("fieldBeforeValue").isEmpty()) {
                        beforeValue = request.getParameter("fieldBeforeValue");
                    }
                    String afterValue = "";
                    if (request.getParameter("fieldAfterValue") != null && !request.getParameter("fieldAfterValue").isEmpty()) {
                        afterValue = request.getParameter("fieldAfterValue");
                    }
                    newLine = new DateFieldBean(position, booleanCondition, fieldName, beforeValue, afterValue);
                } else if (fieldType.equals("list")) {
                    String value = "";
                    if (request.getParameter("fieldListValue") != null && !request.getParameter("fieldListValue").isEmpty()) {
                        value = request.getParameter("fieldListValue");
                    }
                    newLine = new TextFieldBean(position, AdvancedSearchFieldBean.Types.LIST_TYPE, booleanCondition, fieldName, value);
                } else {
                    String value = "";
                    if (request.getParameter("fieldValue") != null && !request.getParameter("fieldValue").isEmpty()) {
                        value = request.getParameter("fieldValue");
                    }
                    newLine = new TextFieldBean(position, AdvancedSearchFieldBean.Types.TEXT_TYPE, booleanCondition, fieldName, value);
                }
                logger.info((Object)("New field added : " + newLine));
                request.setAttribute("advancedSearchNewLine", (Object)newLine);
            }
            request.setAttribute("boolean_conditions", (Object)this.advanced_search_conf.getBooleanConditions());
            request.setAttribute("advanced_search_fields", (Object)this.advanced_search_conf.getAdvancedSearchFields());
            request.setAttribute("launchFormAfter", (Object)launchFormAfter);
            response.setContentType(HTML_CONTENT_TYPE);
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("advanced_search_new_field_page_url"));
            rd.include((PortletRequest)request, (PortletResponse)response);
        } else if (request.getParameter("page_part").equals("generateQuery")) {
            List fieldList = AdvancedSearchPortlet.getFieldListFromParameters((Map)request.getParameterMap());
            String query = AdvancedSearchPortlet.generateQuery((String)request.getParameter(TEXT_KEYWORDS_INPUT), (List)fieldList);
            response.setContentType(TEXT_CONTENT_TYPE);
            response.getWriter().print(query);
            response.getWriter().flush();
        } else if (request.getParameter("page_part").equals("getSelectValues")) {
            response.setContentType(TEXT_CONTENT_TYPE);
            String id = request.getParameter("id");
            Map valuesMap = id.equals("format") ? this.advanced_search_conf.getFormatValues() : (id.equals("language") ? this.advanced_search_conf.getLanguageValues() : new HashMap());
            StringBuilder responseSB = new StringBuilder();
            responseSB.append("[{optionValue: '', optionDisplay: '-'},");
            for (Map.Entry entry : valuesMap.entrySet()) {
                responseSB.append('{');
                responseSB.append("optionValue: ");
                responseSB.append("'").append((String)entry.getKey()).append("'");
                responseSB.append(", optionDisplay: ");
                responseSB.append("'").append(ResourceBundle.getBundle("search_portlet", request.getLocale()).getString((String)entry.getValue())).append("'");
                responseSB.append("},");
            }
            responseSB.deleteCharAt(responseSB.length() - 1);
            responseSB.append(']');
            response.getWriter().print(responseSB.toString());
            response.getWriter().flush();
        }
    }

    public void processEvent(EventRequest request, EventResponse response) throws PortletException, IOException {
        long start = System.currentTimeMillis();
        String reaction = this.getReaction(request.getEvent().getQName()).getLocalPart();
        if (reaction.equals("sendNextDocuments") && request.getEvent().getValue() != null && request.getEvent().getValue() instanceof PieceOfKnowledge) {
            PieceOfKnowledge pok = (PieceOfKnowledge)request.getEvent().getValue();
            AdvancedSelector rdfSelector = RDFSelectorFactory.getSelector((boolean)true, (String[])new String[0]);
            Statements map = rdfSelector.searchFor((Resource)pok, new String[0]);
            String queryURI = null;
            queryURI = (String)map.getTypedValue(pok.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasQuery", String.class);
            logger.debug((Object)("Map of pok : " + map));
            logger.debug((Object)("QueryID : " + queryURI));
            SearchArgs userSearchArg = (SearchArgs)request.getPortletSession().getAttribute(USER_LAST_SEARCH);
            if (userSearchArg != null && queryURI != null && userSearchArg.getQuery().getUri().equals(queryURI)) {
                userSearchArg.setOffset(Integer.valueOf(Integer.parseInt((String)((IPredicateValuePairs)((Map.Entry)map.entrySet().iterator().next()).getValue()).getValue(OFFSET_PROPERTY))));
                userSearchArg.setLimit(Integer.valueOf(Integer.parseInt((String)((IPredicateValuePairs)((Map.Entry)map.entrySet().iterator().next()).getValue()).getValue(LIMIT_PROPERTY))));
                Searcher searcherToUse = (Searcher)searchers.get(request.getPortletSession().getAttribute(LAST_SEARCH_SERVICE));
                logger.info((Object)(request.getPortletSession().getAttribute(LAST_SEARCH_SERVICE) + " searcher is used : updating a resultSet, offset:" + userSearchArg.getOffset() + " limit:" + userSearchArg.getLimit()));
                try {
                    if (searcherToUse != null) {
                        SearchReturn searchResult = searcherToUse.search(userSearchArg);
                        logger.info((Object)searchResult.getResultSet());
                        this.sendEventForAction("nextDocuments", (Resource)searchResult.getResultSet(), response);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    response.setRenderParameter(SEARCH_ERROR, e.getMessage());
                }
            }
        }
        logger.info((Object)("processEvent response time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    private static List<AdvancedSearchFieldBean> getFieldListFromParameters(Map<String, String[]> parameters) {
        ArrayList<AdvancedSearchFieldBean> advancedSearchFieldList = new ArrayList<AdvancedSearchFieldBean>();
        Pattern p = Pattern.compile("advanced_booleanCondition_(\\d+)");
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            if (!entry.getKey().startsWith("advanced_booleanCondition_")) continue;
            Matcher m = p.matcher(entry.getKey());
            m.matches();
            int position = Integer.parseInt(m.group(1));
            if (parameters.get("advanced_fieldName_" + position) != null && parameters.get("advanced_fieldName_" + position)[0] != null && !parameters.get("advanced_fieldName_" + position)[0].isEmpty()) {
                String value;
                TextFieldBean field;
                String[] fieldTypeAndName = parameters.get("advanced_fieldName_" + position)[0].split(":");
                String fieldType = fieldTypeAndName[0];
                String fieldName = fieldTypeAndName[1];
                boolean addField = true;
                if (fieldType.equals("date")) {
                    String beforeValue = DATE_FORMAT.format(OLDEST_DATE);
                    if (parameters.get("advanced_fieldBeforeValue_" + position) != null && !parameters.get("advanced_fieldBeforeValue_" + position)[0].isEmpty()) {
                        beforeValue = parameters.get("advanced_fieldBeforeValue_" + position)[0];
                    }
                    String afterValue = DATE_FORMAT.format(Calendar.getInstance().getTime());
                    if (parameters.get("advanced_fieldAfterValue_" + position) != null && !parameters.get("advanced_fieldAfterValue_" + position)[0].isEmpty()) {
                        afterValue = parameters.get("advanced_fieldAfterValue_" + position)[0];
                    }
                    field = new DateFieldBean(position, entry.getValue()[0], fieldName, beforeValue, afterValue);
                } else if (fieldType.equals("list")) {
                    value = "";
                    if (parameters.get("advanced_fieldListValue_" + position) != null && !parameters.get("advanced_fieldListValue_" + position)[0].isEmpty()) {
                        value = parameters.get("advanced_fieldListValue_" + position)[0];
                    } else {
                        addField = false;
                    }
                    field = new TextFieldBean(position, AdvancedSearchFieldBean.Types.LIST_TYPE, entry.getValue()[0], fieldName, value);
                } else {
                    value = "";
                    if (parameters.get("advanced_fieldValue_" + position) != null && !parameters.get("advanced_fieldValue_" + position)[0].isEmpty()) {
                        value = parameters.get("advanced_fieldValue_" + position)[0];
                    } else {
                        addField = false;
                    }
                    field = new TextFieldBean(position, AdvancedSearchFieldBean.Types.TEXT_TYPE, entry.getValue()[0], fieldName, value);
                }
                if (!addField) continue;
                advancedSearchFieldList.add((AdvancedSearchFieldBean)field);
                continue;
            }
            logger.error((Object)("Name field was null for element " + position));
        }
        Collections.sort(advancedSearchFieldList);
        return advancedSearchFieldList;
    }

    private static String generateQuery(String textQuery, List<AdvancedSearchFieldBean> advancedSearchFieldList) {
        if (textQuery.isEmpty() && advancedSearchFieldList.size() > 0) {
            advancedSearchFieldList.get(0).setBooleanCondition("");
        }
        StringBuilder generatedQuery = new StringBuilder();
        for (AdvancedSearchFieldBean advancedSearchFieldBean : advancedSearchFieldList) {
            if (advancedSearchFieldBean.getBooleanCondition() != null && !advancedSearchFieldBean.getBooleanCondition().isEmpty()) {
                generatedQuery.append(advancedSearchFieldBean.getBooleanCondition()).append(" ");
            }
            generatedQuery.append(advancedSearchFieldBean.getFieldName()).append(":");
            if (advancedSearchFieldBean instanceof TextFieldBean) {
                generatedQuery.append('(');
                generatedQuery.append(((TextFieldBean)advancedSearchFieldBean).getValue());
                generatedQuery.append(')');
            } else if (advancedSearchFieldBean instanceof DateFieldBean) {
                generatedQuery.append('[');
                generatedQuery.append(((DateFieldBean)advancedSearchFieldBean).getBeforeValue());
                generatedQuery.append(' ');
                generatedQuery.append(((DateFieldBean)advancedSearchFieldBean).getAfterValue());
                generatedQuery.append(']');
            }
            generatedQuery.append(' ');
        }
        if (generatedQuery.length() > 0) {
            generatedQuery.deleteCharAt(generatedQuery.length() - 1);
        }
        if (generatedQuery.length() == 0) {
            return textQuery;
        }
        if (textQuery.length() == 0) {
            return generatedQuery.toString();
        }
        return '(' + textQuery + ')' + ' ' + generatedQuery.toString();
    }

    static {
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        OLDEST_DATE = new Date(0L);
    }
}

