<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jstl/fmt_rt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jstl/core_rt" prefix="c"%>
<%@page import="org.ow2.weblab.portlet.tool.AdvancedSearchFieldBean"%>

<%-- Enum are not supported by JSTL, so define attributes corresponding to possible values --%>
<% pageContext.setAttribute("text_type", AdvancedSearchFieldBean.Types.TEXT_TYPE); %>
<% pageContext.setAttribute("list_type", AdvancedSearchFieldBean.Types.LIST_TYPE); %>
<% pageContext.setAttribute("date_type", AdvancedSearchFieldBean.Types.DATE_TYPE); %>

<portlet:defineObjects />
<fmt:setLocale value="${pageContext.request.locale}" />
<fmt:setBundle basename="search_portlet" />

<tr id="advancedSearchFieldLine_${advancedSearchNewLine.position}"
	<c:choose>
		<c:when test="${(advancedSearchNewLine.position%2) == 1}">
			class="portlet-section-body results-row"
		</c:when>
		<c:otherwise>
			class="portlet-section-alternate results-row alt"
		</c:otherwise>
	</c:choose>
>
	<td class="booleanCondition" >
		<select name="advanced_booleanCondition_${advancedSearchNewLine.position}" id="advanced_booleanCondition_${advancedSearchNewLine.position}" style="wdith: 100%" >
			<c:forEach var="booleanEntry" items="${boolean_conditions}" >
				<option value="${booleanEntry.key}" 
					<c:if test="${booleanEntry.key == advancedSearchNewLine.booleanCondition}">selected="selected"</c:if>
				>${booleanEntry.value}</option>
			</c:forEach>
		</select>
	</td>
	<td class="fieldName" >
		<select name="advanced_fieldName_${advancedSearchNewLine.position}" id="advanced_fieldName_${advancedSearchNewLine.position}" disabled="disabled" style="width: 100%;" 
				onchange="jQuery.advancedSearchField.changeAdvancedFieldValueFieldType('${advancedSearchNewLine.position}');" >
			<option value="">-</option>
			<c:forEach var="fieldEntry" items="${advanced_search_fields}" >
				<option value="${fieldEntry.value}:${fieldEntry.key}" 
					<c:if test="${fieldEntry.key == advancedSearchNewLine.fieldName}">
						selected="selected"
						<c:set var="advanced_fieldType" value="${fieldEntry.value}" />
					</c:if>
				>
					<fmt:message key="search.field.${fieldEntry.key}" />
				</option>
			</c:forEach>
		</select>
	</td>
	<td class="fieldValueCell advanced_fieldValue_${advancedSearchNewLine.position}"
			<c:if test="${advancedSearchNewLine.type != text_type}">
				style="display:none"
			</c:if>
	>
		=
		<input type="text" id="advanced_fieldValue_${advancedSearchNewLine.position}" 
			name="advanced_fieldValue_${advancedSearchNewLine.position}" 
			<c:if test="${advancedSearchNewLine.type == text_type}">
				value="<c:out value="${advancedSearchNewLine.value}" escapeXml="true" />"
			</c:if>
			class="fieldValue" />
	</td>
	<td class="fieldValueCell advanced_fieldListValue_${advancedSearchNewLine.position}" 
			<c:if test="${advancedSearchNewLine.type != list_type}">
				style="display:none"
			</c:if>
		>
			
			=
			<select id="advanced_fieldListValue_${advancedSearchNewLine.position}" name="advanced_fieldListValue_${advancedSearchNewLine.position}" class="fieldValue" ></select>
			<c:if test="${advancedSearchNewLine.type == list_type}">
				<script defer="true" language="Javascript">
					jQuery.advancedSearchField.updateValuesList("${advancedSearchNewLine.fieldName}", "advanced_fieldListValue_${advancedSearchNewLine.position}", "${advancedSearchNewLine.value}", "${launchFormAfter}");
				</script>
			</c:if>
	</td>
	<td class="fieldValueCell advanced_fieldDateValues_${advancedSearchNewLine.position}" 
			<c:if test="${advancedSearchNewLine.type != date_type}">
				style="display:none"
			</c:if>
	>
		<fmt:message key="search.from" />
		<input type="text" id="advanced_fieldBeforeValue_${advancedSearchNewLine.position}" name="advanced_fieldBeforeValue_${advancedSearchNewLine.position}" 
			<c:if test="${advancedSearchNewLine.type == date_type}">
				value="<c:out value="${advancedSearchNewLine.beforeValue}" escapeXml="true" />"
			</c:if>
			class="dateFieldValue" />
		<fmt:message key="search.to" />
		<input type="text" id="advanced_fieldAfterValue_${advancedSearchNewLine.position}" name="advanced_fieldAfterValue_${advancedSearchNewLine.position}" 
			<c:if test="${advancedSearchNewLine.type == date_type}">
				value="<c:out value="${advancedSearchNewLine.afterValue}" escapeXml="true" />"
			</c:if>
		class="dateFieldValue" />
		<script language="Javascript">
			jQuery("#advanced_fieldBeforeValue_${advancedSearchNewLine.position}").datepicker(jQuery.datepicker.regional[locale_var]);
			jQuery("#advanced_fieldAfterValue_${advancedSearchNewLine.position}").datepicker(jQuery.datepicker.regional[locale_var]);
		</script>
	</td>
	<td style="width:16px;" >
		<div class="advancedSearch_del" 
			 onClick="jQuery.advancedSearchField.removeAdvancedSearchField('${advancedSearchNewLine.position}');" 
			 title="<fmt:message key="search.advanced.remove" />" >
		</div>
	</td>
</tr>
