<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jstl/core_rt" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jstl/fmt_rt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>


<%@page import="org.apache.commons.lang.StringEscapeUtils"%>
<portlet:defineObjects />

<fmt:setLocale value="${pageContext.request.locale}" />
<fmt:setBundle basename="search_portlet" />

<portlet:resourceURL var="resourceURL_advancedSearchField" escapeXml="false">
	<portlet:param name="page_part" value="advancedSearchField"></portlet:param>
</portlet:resourceURL>

<portlet:resourceURL var="resourceURL_advancedSearchField_addField" escapeXml="false">
	<portlet:param name="page_part" value="advancedSearchNewLine"></portlet:param>
	<portlet:param name="position" value="toBeChanged_position"></portlet:param>
	<portlet:param name="booleanCondition" value="toBeChanged_booleanCondition"></portlet:param>
	<portlet:param name="fieldName" value="toBeChanged_fieldName"></portlet:param>
	<portlet:param name="fieldValue" value="toBeChanged_fieldValue"></portlet:param>
	<portlet:param name="fieldListValue" value="toBeChanged_fieldListValue"></portlet:param>
	<portlet:param name="fieldBeforeValue" value="toBeChanged_fieldBeforeValue"></portlet:param>
	<portlet:param name="fieldAfterValue" value="toBeChanged_fieldAfterValue"></portlet:param>
	<portlet:param name="launchFormAfter" value="toBeChanged_launchFormAfter"></portlet:param>
</portlet:resourceURL>

<portlet:resourceURL var="resourceURL_nativeSyntax" escapeXml="false">
	<portlet:param name="page_part" value="nativeSyntax"></portlet:param>
</portlet:resourceURL>

<portlet:resourceURL var="resourceURL_generateQuery" escapeXml="false">
	<portlet:param name="page_part" value="generateQuery"></portlet:param>
</portlet:resourceURL>

<portlet:resourceURL var="resourceURL_getSelectValues" escapeXml="false">
	<portlet:param name="page_part" value="getSelectValues"></portlet:param>
</portlet:resourceURL>

<script type="text/javascript">
	jQuery.advancedSearchField.initAdvancedSearchPortlet("${resourceURL_advancedSearchField}", "${resourceURL_advancedSearchField_addField}", "${resourceURL_generateQuery}", "${resourceURL_getSelectValues}",
							"<%=StringEscapeUtils.escapeJavaScript((String) request.getAttribute("lastTextInput"))%>",
							${def_mess}, ${native_syntax}, "${resourceURL_nativeSyntax}", "${pageContext.request.locale}", "${display_checking_popup}");
</script>

<div id="searchBox" class="advancedPortletContent">

<form id="advancedSearchForm" method="POST" onsubmit="jQuery.advancedSearchField.enableAllDisabledSelect();" action="<portlet:actionURL></portlet:actionURL>">
	
	<!-- =========================== -->
	<!--      PORTLET LEFT PART      -->
	<!-- =========================== -->
	
	<div id="advancedSearch_leftPart" class="advancedLeftPanel" >

		<div style="padding:5px;" >
			<!-- Search input -->
			<span><fmt:message key="search.advancedSearchFields.text" /> :</span>
			<c:choose>
				<c:when test="${def_mess}">
					<input id='advancedSearchBox_input' type='text' name="textInput"
						value="<c:out value="${lastTextInput}" escapeXml="true" />"
						onclick="jQuery.advancedSearchField.clearSearchField();" size="45" />
				</c:when>
				<c:otherwise>
					<input id='advancedSearchBox_input' type='text' name="textInput"
						value="<c:out value="${lastTextInput}" />" size="45" />
				</c:otherwise>
			</c:choose>
		</div>
	
		<div id="advancedSearchField" class="advancedFieldsDiv" >
			<div class="advancedSearch_loading" ></div>
		</div>
		
	</div>
	
	
	<!-- =========================== -->
	<!--      PORTLET RIGHT PART     -->
	<!-- =========================== -->
	
	<div id="advancedSearch_rightPart" class="advancedRightPanel" >
		<div style="padding:5px;" >
			<!-- Search and clear buttons -->
			<input type="button" name="search_submit" value="<fmt:message key="search.button" />"  
					onclick="jQuery.advancedSearchField.checkAddingAdvancedSearchfields()"/>
			<input type="button" name="search_clear" value="<fmt:message key="clear.button" />" 
					onclick="jQuery.advancedSearchField.clearAllFields();" /> 
			<input type="button" name="test" value="<fmt:message key="generateQuery.button" />" 
					onclick="jQuery.advancedSearchField.getGeneratedQuery();" />
			<input type="hidden" name="form_name" value="search_query">
		</div>
		
		<!-- Search services list -->
		<div 
			<c:choose>
				<c:when test="${fn:length(search_services_map) == 1}">style="display:none"</c:when>
				<c:otherwise></c:otherwise>
			</c:choose>
		 >
			<select name="searchServiceInput" id="searchServiceInput" >
				<c:forEach var="entry" items="${search_services_map}" >
					<option value="${entry.key}"
							<c:if test="${entry.key == last_search_service}">selected="selected"</c:if>
							icon="<%=request.getContextPath()%>/${entry.value.imagePath}">${entry.value.name}</option>
				</c:forEach>
			</select>
		</div>
		
		<!-- Native syntax checkbox -->
		<div
			<c:choose>
				<c:when test="${native_syntax_displayed == false}">style="display:none;"</c:when>
				<c:otherwise>style="padding:5px;"</c:otherwise>
			</c:choose>
		 >
		 <c:out value="${native_syntax_displayed == false}" />
			<input class="advancedSearch_checkBox" type="checkbox"
					name="searchBox_nativeSyntax" id="searchBox_nativeSyntax"
					onClick="jQuery.advancedSearchField.changeNativeSyntaxCheckBox();" >
				<fmt:message key="search.nativeSyntax"/>
			</input>
		</div>
		
		<!-- native syntax checkbox confirmation messages -->
		<div id="advancedSearch_uncheck_question" style="display:none; cursor: default"> 
	        <h1><fmt:message key="search.nativeSyntax.question.uncheck" /></h1> 
	        <input type="button" id="advancedSearch_uncheck_question_yes" value="<fmt:message key="search.nativeSyntax.question.yes" />" /> 
	        <input type="button" id="advancedSearch_uncheck_question_no" value="<fmt:message key="search.nativeSyntax.question.no" />" /> 
		</div>
		<div id="advancedSearch_check_question" style="display:none; cursor: default"> 
	        <h1><fmt:message key="search.nativeSyntax.question.check" /></h1> 
	        <input type="button" id="advancedSearch_check_question_yes" value="<fmt:message key="search.nativeSyntax.question.yes" />" /> 
	        <input type="button" id="advancedSearch_check_question_no" value="<fmt:message key="search.nativeSyntax.question.no" />" />  
		</div>
		
		<!-- Search button confirmation message -->
		<div id="advancedSearch_search_question" style="display:none; cursor: default"> 
	        <h1><fmt:message key="search.fieldNotAdded.question" /></h1> 
	        <input type="button" id="advancedSearch_fieldNotAdded_question_addMeta" value="<fmt:message key="search.fieldNotAdded.question.addMeta" />" /> 
	        <input type="button" id="advancedSearch_fieldNotAdded_question_search" value="<fmt:message key="search.fieldNotAdded.question.search" />" /> 
	        <input type="button" id="advancedSearch_fieldNotAdded_question_cancel" value="<fmt:message key="search.fieldNotAdded.question.cancel" />" />
		</div>
		
		<!-- Search button confirmation message -->
		<div id="advancedSearch_empty_form" style="display:none; cursor: default"> 
	        <h1><fmt:message key="search.formEmpty" /></h1>
	        <input type="button" id="advancedSearch_empty_form_ok" value="<fmt:message key="valid.button" />" /> 
		</div>
		
	</div>
	
</form>
</div>

<div id="advanced_generatedQuery" class="weblab_portletMsgInfo" style="display:none;" ></div>
