/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2010 EADS - CASSIDIAN
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.portlet.tool;

import java.util.Map;

public class AdvancedSearchConfigBean {

	public static String DEFAULT_CONF_FILE = "AdvancedSearchConfigBean.xml";
	public static String DEFAULT_BEAN_NAME = "AdvancedSearchConfigBean";
	
	private Map<String, SearchServiceBean> searchServices;
	private Map<String, String> advancedSearchFields;
	private Map<String, String> booleanConditions;
	private Map<String, String> formatValues;
	private Map<String, String> languageValues;
	private boolean nativeSyntaxOptionDisplayed;
	private boolean displayCheckingPopup;

	private boolean enableAdvancedSearch = true;
	private boolean enableSaveQuery = false;
	private boolean enableGenerate = false;

	/**
	 * @return the searchServices
	 */
	public Map<String, SearchServiceBean> getSearchServices() {
		return this.searchServices;
	}

	/**
	 * @param searchServices the searchServices to set
	 */
	public void setSearchServices(Map<String, SearchServiceBean> searchServices) {
		this.searchServices = searchServices;
	}

	/**
	 * @return the advancedSearchFields
	 */
	public Map<String, String> getAdvancedSearchFields() {
		return this.advancedSearchFields;
	}

	/**
	 * @param advancedSearchFields the advancedSearchFields to set
	 */
	public void setAdvancedSearchFields(Map<String, String> advancedSearchFields) {
		this.advancedSearchFields = advancedSearchFields;
	}

	/**
	 * @return the booleanConditions
	 */
	public Map<String, String> getBooleanConditions() {
		return this.booleanConditions;
	}

	/**
	 * @param booleanConditions the booleanConditions to set
	 */
	public void setBooleanConditions(Map<String, String> booleanConditions) {
		this.booleanConditions = booleanConditions;
	}

	/**
	 * @return the formatValues
	 */
	public Map<String, String> getFormatValues() {
		return this.formatValues;
	}

	/**
	 * @param formatValues the formatValues to set
	 */
	public void setFormatValues(Map<String, String> formatValues) {
		this.formatValues = formatValues;
	}

	/**
	 * @return the languageValues
	 */
	public Map<String, String> getLanguageValues() {
		return this.languageValues;
	}

	/**
	 * @param languageValues the languageValues to set
	 */
	public void setLanguageValues(Map<String, String> languageValues) {
		this.languageValues = languageValues;
	}

	/**
	 * @return the nativeSyntaxOptionDisplayed
	 */
	public boolean isNativeSyntaxOptionDisplayed() {
		return this.nativeSyntaxOptionDisplayed;
	}

	/**
	 * @param nativeSyntaxOptionDisplayed the nativeSyntaxOptionDisplayed to set
	 */
	public void setNativeSyntaxOptionDisplayed(boolean nativeSyntaxOptionDisplayed) {
		this.nativeSyntaxOptionDisplayed = nativeSyntaxOptionDisplayed;
	}

	/**
	 * @return the displayCheckingPopup
	 */
	public boolean isDisplayCheckingPopup() {
		return this.displayCheckingPopup;
	}

	/**
	 * @param displayCheckingPopup the displayCheckingPopup to set
	 */
	public void setDisplayCheckingPopup(boolean displayCheckingPopup) {
		this.displayCheckingPopup = displayCheckingPopup;
	}

	public boolean isEnableAdvancedSearch() {
		return enableAdvancedSearch;
	}

	public void setEnableAdvancedSearch(boolean enableAdvancedSearch) {
		this.enableAdvancedSearch = enableAdvancedSearch;
	}

	public boolean isEnableSaveQuery() {
		return enableSaveQuery;
	}

	public void setEnableSaveQuery(boolean enableSaveQuery) {
		this.enableSaveQuery = enableSaveQuery;
	}

	public boolean isEnableGenerate() {
		return enableGenerate;
	}

	public void setEnableGenerate(boolean enableGenerate) {
		this.enableGenerate = enableGenerate;
	}
}
