/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2010 EADS - CASSIDIAN
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.portlet.tool;

/*
 * Warning : this class is not consistent with comparable
 */
public abstract class AdvancedSearchFieldBean implements Comparable<AdvancedSearchFieldBean> {

	public enum Types {
		TEXT_TYPE, LIST_TYPE, DATE_TYPE
	}

	protected int position;
	protected Types type;
	protected String booleanCondition;
	protected String fieldName;

	public AdvancedSearchFieldBean() {
		super();
	}

	public AdvancedSearchFieldBean(int position, Types type, String booleanCondition, String fieldName) {
		super();
		this.position = position;
		this.type = type;
		this.booleanCondition = booleanCondition;
		this.fieldName = fieldName;
	}

	/**
	 * @return the booleanCondition
	 */
	public String getBooleanCondition() {
		return this.booleanCondition;
	}

	/**
	 * @param booleanCondition
	 *            the booleanCondition to set
	 */
	public void setBooleanCondition(String booleanCondition) {
		this.booleanCondition = booleanCondition;
	}

	/**
	 * @return the fieldName
	 */
	public String getFieldName() {
		return this.fieldName;
	}

	/**
	 * @param fieldName
	 *            the fieldName to set
	 */
	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}

	/**
	 * @return the position
	 */
	public int getPosition() {
		return this.position;
	}

	/**
	 * @param position
	 *            the position to set
	 */
	public void setPosition(int position) {
		this.position = position;
	}

	/**
	 * @return the type
	 */
	public Types getType() {
		return this.type;
	}

	/**
	 * @param type the type to set
	 */
	public void setType(Types type) {
		this.type = type;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.booleanCondition == null) ? 0 : this.booleanCondition.hashCode());
		result = prime * result + ((this.fieldName == null) ? 0 : this.fieldName.hashCode());
		result = prime * result + this.position;
		result = prime * result + ((this.type == null) ? 0 : this.type.hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
	
		AdvancedSearchFieldBean other = (AdvancedSearchFieldBean) obj;
		if (this.booleanCondition == null) {
			if (other.booleanCondition != null) {
				return false;
			}
		} else if (!this.booleanCondition.equals(other.booleanCondition)) {
			return false;
		}
		if (this.fieldName == null) {
			if (other.fieldName != null) {
				return false;
			}
		} else if (!this.fieldName.equals(other.fieldName)) {
			return false;
		}
		if (this.position != other.position) {
			return false;
		}
		if (this.type == null) {
			if (other.type != null) {
				return false;
			}
		} else if (!this.type.equals(other.type)) {
			return false;
		}
		return true;
	}

	@Override
	public int compareTo(AdvancedSearchFieldBean o) {
		return Integer.valueOf(this.position).compareTo(Integer.valueOf(o.getPosition()));
	}
}
