/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2010 EADS - CASSIDIAN
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.portlet.tool;

public class DateFieldBean extends AdvancedSearchFieldBean {

	protected String beforeValue;
	protected String afterValue;

	public DateFieldBean() {
		super();
	}

	public DateFieldBean(int position, String booleanCondition, String fieldName, String beforeValue, String afterValue) {
		super(position, AdvancedSearchFieldBean.Types.DATE_TYPE, booleanCondition, fieldName);
		this.beforeValue = beforeValue;
		this.afterValue = afterValue;
	}

	/**
	 * @return the beforeValue
	 */
	public String getBeforeValue() {
		return this.beforeValue;
	}

	/**
	 * @param beforeValue
	 *            the beforeValue to set
	 */
	public void setBeforeValue(String beforeValue) {
		this.beforeValue = beforeValue;
	}

	/**
	 * @return the afterValue
	 */
	public String getAfterValue() {
		return this.afterValue;
	}

	/**
	 * @param afterValue
	 *            the afterValue to set
	 */
	public void setAfterValue(String afterValue) {
		this.afterValue = afterValue;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((this.afterValue == null) ? 0 : this.afterValue.hashCode());
		result = prime * result + ((this.beforeValue == null) ? 0 : this.beforeValue.hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (!super.equals(obj)) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		DateFieldBean other = (DateFieldBean) obj;
		if (this.afterValue == null) {
			if (other.afterValue != null) {
				return false;
			}
		} else if (!this.afterValue.equals(other.afterValue)) {
			return false;
		}
		
		if (this.beforeValue == null) {
			if (other.beforeValue != null) {
				return false;
			}
		} else if (!this.beforeValue.equals(other.beforeValue)) {
			return false;
		}
		
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "DateFieldBean [booleanCondition=" + this.booleanCondition + ", fieldName=" + this.fieldName + ", position="
				+ this.position + ", afterValue=" + this.afterValue + ", beforeValue=" + this.beforeValue + "]";
	}

}
