/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 * 
 * Copyright (C) 2004 - 2010 EADS - CASSIDIAN
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.portlet.tool;

public class SearchServiceBean {

	protected String id;
	protected String name;
	protected String URI;
	protected String translatorClass;
	protected String imagePath;
	protected boolean nativeSyntaxe;
	protected String usageContext;
	
	
	/**
	 * @return the id
	 */
	public String getId() {
		return this.id;
	}
	/**
	 * @param id the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}
	/**
	 * @return the name
	 */
	public String getName() {
		return this.name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return the uRI
	 */
	public String getURI() {
		return this.URI;
	}
	/**
	 * @param uri the uRI to set
	 */
	public void setURI(String uri) {
		this.URI = uri;
	}
	/**
	 * @return the translatorClass
	 */
	public String getTranslatorClass() {
		return this.translatorClass;
	}
	/**
	 * @param translatorClass the translatorClass to set
	 */
	public void setTranslatorClass(String translatorClass) {
		this.translatorClass = translatorClass;
	}
	/**
	 * @return the imagePath
	 */
	public String getImagePath() {
		return this.imagePath;
	}
	/**
	 * @param imagePath the imagePath to set
	 */
	public void setImagePath(String imagePath) {
		this.imagePath = imagePath;
	}
	
	public boolean isNativeSyntaxe() {
		return nativeSyntaxe;
	}
	public void setNativeSyntaxe(boolean nativeSyntaxe) {
		this.nativeSyntaxe = nativeSyntaxe;
	}
	
	/**
	 * @return the usageContext
	 */
	public String getUsageContext() {
		return usageContext;
	}	
	/**
	 * @param usageContext the usageContext to set
	 */
	public void setUsageContext(String usageContext) {
		this.usageContext = usageContext;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.URI == null) ? 0 : this.URI.hashCode());
		result = prime * result + ((this.id == null) ? 0 : this.id.hashCode());
		result = prime * result + ((this.imagePath == null) ? 0 : this.imagePath.hashCode());
		result = prime * result + ((this.name == null) ? 0 : this.name.hashCode());
		result = prime * result + ((this.translatorClass == null) ? 0 : this.translatorClass.hashCode());
		return result;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		SearchServiceBean other = (SearchServiceBean) obj;
		if (this.URI == null) {
			if (other.URI != null) {
				return false;
			}
		} else if (!this.URI.equals(other.URI)) {
			return false;
		}
		
		if (this.id == null) {
			if (other.id != null) {
				return false;
			}
		} else if (!this.id.equals(other.id)) {
			return false;
		}
		if (this.imagePath == null) {
			if (other.imagePath != null) {
				return false;
			}
		} else if (!this.imagePath.equals(other.imagePath)) {
			return false;
		}
		
		if (this.name == null) {
			if (other.name != null)
				return false;
		} else if (!this.name.equals(other.name)) {
			return false;
		}
		if (this.translatorClass == null) {
			if (other.translatorClass != null) {
				return false;
			}
		} else if (!this.translatorClass.equals(other.translatorClass)) {
			return false;
		}
		
		return true;
	}
}
