/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.weblab.portlet;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.exception.WebLabCheckedException;
import org.ow2.weblab.core.extended.factory.AnnotationFactory;
import org.ow2.weblab.core.extended.factory.ResourceFactory;
import org.ow2.weblab.core.extended.jaxb.WebLabMarshaller;
import org.ow2.weblab.core.extended.util.ResourceUtil;
import org.ow2.weblab.core.extended.util.ServiceUtil;
import org.ow2.weblab.core.helper.impl.AdvancedSelector;
import org.ow2.weblab.core.helper.impl.IPredicateValuePairs;
import org.ow2.weblab.core.helper.impl.JenaPoKHelper;
import org.ow2.weblab.core.helper.impl.RDFSelectorFactory;
import org.ow2.weblab.core.helper.impl.Statements;
import org.ow2.weblab.core.model.Annotation;
import org.ow2.weblab.core.model.PieceOfKnowledge;
import org.ow2.weblab.core.model.Query;
import org.ow2.weblab.core.model.Resource;
import org.ow2.weblab.core.model.ResultSet;
import org.ow2.weblab.core.model.StringQuery;
import org.ow2.weblab.core.services.Analyser;
import org.ow2.weblab.core.services.InvalidParameterException;
import org.ow2.weblab.core.services.Searcher;
import org.ow2.weblab.core.services.analyser.ProcessArgs;
import org.ow2.weblab.core.services.analyser.ProcessReturn;
import org.ow2.weblab.core.services.searcher.SearchArgs;
import org.ow2.weblab.core.services.searcher.SearchReturn;
import org.ow2.weblab.portlet.WebLabPortlet;
import org.ow2.weblab.portlet.tool.AdvancedSearchConfigBean;
import org.ow2.weblab.portlet.tool.AdvancedSearchFieldBean;
import org.ow2.weblab.portlet.tool.DateFieldBean;
import org.ow2.weblab.portlet.tool.SearchServiceBean;
import org.ow2.weblab.portlet.tool.TextFieldBean;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdvancedSearchPortlet
extends WebLabPortlet {
    private static final String DO_SAVE_QUERY = "doSaveQuery";
    private static final String DO_SEARCH = "doSearch";
    private static Log logger = LogFactory.getLog(AdvancedSearchPortlet.class);
    protected static final String DEFAULT_SYNTAX_NAME = "lucene";
    private static final String DEFAULT_SEARCH = "def_mess";
    private static String SEARCH_ACTION = "search";
    private static String NEXT_DOCUMENTS_ACTION = "nextDocuments";
    private static String RESET_ACTION = "resetSearch";
    private static String SAVE_QUERY_ACTION = "saveQuery";
    private static String NEXT_DOCUMENTS_REACTION = "sendNextDocuments";
    private static String FACET_SELECTION_REACTION = "facetSelection";
    private static String FACET_UNSELECTION_REACTION = "facetUnselection";
    public static String ENABLE_ADVANCED_SEARCH = "enableAdvancedSearch";
    public static String ENABLE_SAVE = "enableSave";
    public static String ENABLE_GENERATE = "enableGenerate";
    public static String TEXT_KEYWORDS_INPUT = "textInput";
    public static String LAST_TEXT_KEYWORDS_INPUT = "lastTextInput";
    public static String QUERY_INPUT = "queryInput";
    public static String SUBMIT_INPUT = "submitInput";
    public static String USER_LAST_SEARCH = "user_last_search";
    public static String USER_ESB_CONF = "user_esb_conf";
    public static String SEARCH_ERROR = "searcher_error";
    public static String ESB_CONFIG_NAME = "esb_config_bean";
    public static String SEARCH_SERVICES_MAP = "search_services_map";
    public static String DISPLAY_CHECKING_POPUP = "display_checking_popup";
    public static String SEARCH_SERVICE = "searchServiceInput";
    public static String LAST_SEARCH_SERVICE = "last_search_service";
    public static String NATIVE_SYNTAX = "native_syntax";
    public static String NATIVE_SYNTAX_DISPLAYED = "native_syntax_displayed";
    private static String OFFSET_PROPERTY = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasExpectedOffset";
    private static String LIMIT_PROPERTY = "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasExpectedLimit";
    private static String HTML_CONTENT_TYPE = "text/html; charset=utf-8";
    private static String TEXT_CONTENT_TYPE = "text/plain; charset=utf-8";
    protected static AdvancedSearchConfigBean advanced_search_conf;
    protected static URL SEARCHER_WSDL_LOCATION;
    protected static Map<String, Searcher> searchers;
    protected static Map<String, Analyser> translators;
    protected static Map<String, String> usageContexts;
    protected static int distinct_submit_query;
    protected static boolean USE_REDIRECTION;
    private static final SimpleDateFormat DATE_FORMAT;
    private static final Date OLDEST_DATE;

    public void init() throws PortletException {
        super.init();
        ClassPathResource resource = new ClassPathResource(AdvancedSearchConfigBean.DEFAULT_CONF_FILE);
        XmlBeanFactory factory = new XmlBeanFactory((org.springframework.core.io.Resource)resource);
        advanced_search_conf = (AdvancedSearchConfigBean)factory.getBean(AdvancedSearchConfigBean.DEFAULT_BEAN_NAME, AdvancedSearchConfigBean.class);
        try {
            try {
                SEARCHER_WSDL_LOCATION = new File(this.getPortletContext().getRealPath("WEB-INF/classes/services/WebLab.wsdl")).toURI().toURL();
            }
            catch (MalformedURLException e) {
                logger.error((Object)e);
            }
            searchers = new HashMap();
            translators = new HashMap();
            usageContexts = new HashMap();
            for (String serviceId : advanced_search_conf.getSearchServices().keySet()) {
                SearchServiceBean serviceBean = (SearchServiceBean)advanced_search_conf.getSearchServices().get(serviceId);
                Searcher searcher = ServiceUtil.getSearcherService((URL)SEARCHER_WSDL_LOCATION, (URL)new URL(serviceBean.getURI()));
                searchers.put(serviceId, searcher);
                if (serviceBean.getUsageContext() != null && !serviceBean.getUsageContext().isEmpty()) {
                    usageContexts.put(serviceId, serviceBean.getUsageContext());
                    logger.info((Object)("add uc: " + serviceBean.getUsageContext() + " for searcher " + serviceId));
                }
                if (serviceBean.getTranslatorClass() == null || serviceBean.getTranslatorClass().isEmpty()) continue;
                try {
                    Class<?> clazz = Class.forName(serviceBean.getTranslatorClass());
                    if (!Analyser.class.isAssignableFrom(clazz)) continue;
                    Analyser queryAnalyser = (Analyser)Analyser.class.cast(clazz.newInstance());
                    translators.put(serviceId, queryAnalyser);
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)("Unbale to load QueryTranslator class for: " + serviceId));
                }
                catch (InstantiationException e) {
                    logger.error((Object)("Unbale to instantiate QueryTranslator class for: " + serviceId));
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)("Access exception when trying to load QueryTranslator class for: " + serviceId));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unbale to get service URI");
        }
        if (this.getInitParameter(SEARCH_ACTION) != null) {
            SEARCH_ACTION = this.getInitParameter(SEARCH_ACTION);
            logger.info((Object)("SEARCH_ACTION is fixed to " + SEARCH_ACTION));
        }
        if (this.getInitParameter(NEXT_DOCUMENTS_ACTION) != null) {
            NEXT_DOCUMENTS_ACTION = this.getInitParameter(NEXT_DOCUMENTS_ACTION);
            logger.info((Object)("NEXT_DOCUMENTS_ACTION is fixed to " + NEXT_DOCUMENTS_ACTION));
        }
        if (this.getInitParameter(RESET_ACTION) != null) {
            RESET_ACTION = this.getInitParameter(RESET_ACTION);
            logger.info((Object)("RESET_ACTION is fixed to " + RESET_ACTION));
        }
        if (this.getInitParameter(SAVE_QUERY_ACTION) != null) {
            SAVE_QUERY_ACTION = this.getInitParameter(SAVE_QUERY_ACTION);
            logger.info((Object)("SAVE_QUERY_ACTION is fixed to " + SAVE_QUERY_ACTION));
        }
        if (this.getInitParameter(NEXT_DOCUMENTS_REACTION) != null) {
            NEXT_DOCUMENTS_REACTION = this.getInitParameter(NEXT_DOCUMENTS_REACTION);
            logger.info((Object)("NEXT_DOCUMENTS_REACTION is fixed to " + NEXT_DOCUMENTS_REACTION));
        }
        if (this.getInitParameter(FACET_SELECTION_REACTION) != null) {
            FACET_SELECTION_REACTION = this.getInitParameter(FACET_SELECTION_REACTION);
            logger.info((Object)("FACET_SELECTION_REACTION is fixed to " + FACET_SELECTION_REACTION));
        }
        if (this.getInitParameter(FACET_UNSELECTION_REACTION) != null) {
            FACET_UNSELECTION_REACTION = this.getInitParameter(FACET_UNSELECTION_REACTION);
            logger.info((Object)("FACET_UNSELECTION_REACTION is fixed to " + FACET_UNSELECTION_REACTION));
        }
        USE_REDIRECTION = this.getInitParameter("use_redirection") != null ? Boolean.parseBoolean(this.getInitParameter("use_redirection")) : false;
        distinct_submit_query = 0;
    }

    public void destroy() {
        super.destroy();
    }

    public void doView(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        PortletRequestDispatcher rd;
        if (req.getParameter(SEARCH_ERROR) != null) {
            req.setAttribute(SEARCH_ERROR, (Object)req.getParameter(SEARCH_ERROR));
            logger.info((Object)"error in searcher");
            rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("error_page_url"));
            rd.include(req, res);
        }
        if (req.getPortletSession().getAttribute(LAST_TEXT_KEYWORDS_INPUT) == null) {
            req.setAttribute(LAST_TEXT_KEYWORDS_INPUT, (Object)ResourceBundle.getBundle("search_portlet", req.getLocale()).getString("search.defaultText"));
            req.setAttribute("def_mess", (Object)true);
        } else {
            req.setAttribute(LAST_TEXT_KEYWORDS_INPUT, req.getPortletSession().getAttribute(LAST_TEXT_KEYWORDS_INPUT));
            req.setAttribute("def_mess", (Object)false);
        }
        req.setAttribute(SEARCH_SERVICES_MAP, (Object)advanced_search_conf.getSearchServices());
        req.setAttribute(DISPLAY_CHECKING_POPUP, (Object)advanced_search_conf.isDisplayCheckingPopup());
        if (req.getPortletSession().getAttribute(LAST_SEARCH_SERVICE) == null) {
            if (advanced_search_conf.getSearchServices().keySet().toArray().length > 0) {
                req.setAttribute(LAST_SEARCH_SERVICE, advanced_search_conf.getSearchServices().keySet().toArray()[0]);
            }
        } else {
            req.setAttribute(LAST_SEARCH_SERVICE, req.getPortletSession().getAttribute(LAST_SEARCH_SERVICE));
        }
        if (req.getPortletSession().getAttribute(NATIVE_SYNTAX) == null) {
            req.setAttribute(NATIVE_SYNTAX, (Object)false);
        } else {
            req.setAttribute(NATIVE_SYNTAX, req.getPortletSession().getAttribute(NATIVE_SYNTAX));
        }
        req.setAttribute(ENABLE_ADVANCED_SEARCH, (Object)advanced_search_conf.isEnableAdvancedSearch());
        req.setAttribute(ENABLE_SAVE, (Object)advanced_search_conf.isEnableSaveQuery());
        req.setAttribute(ENABLE_GENERATE, (Object)advanced_search_conf.isEnableGenerate());
        req.setAttribute(NATIVE_SYNTAX_DISPLAYED, (Object)advanced_search_conf.isNativeSyntaxOptionDisplayed());
        rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("search_page_url"));
        rd.include(req, res);
    }

    public void doEdit(RenderRequest req, RenderResponse res) throws PortletException, IOException {
        PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("edit_page_url"));
        rd.include(req, res);
    }

    public void processAction(ActionRequest req, ActionResponse res) throws IOException, PortletException {
        String form_name = req.getParameter("form_name");
        String form_action = req.getParameter("form_action");
        if (form_name != null) {
            if (form_name.equals("search_query")) {
                logger.debug((Object)"Do 'search' action.");
                List advancedSearchFieldList = AdvancedSearchPortlet.getFieldListFromParameters((Map)req.getParameterMap());
                req.getPortletSession().setAttribute("AdvancedSearchFieldBeanList", (Object)advancedSearchFieldList);
                req.getPortletSession().setAttribute("AdvancedSearchTextSearch", (Object)req.getParameter(TEXT_KEYWORDS_INPUT));
                String query = AdvancedSearchPortlet.generateQuery((String)req.getParameter(TEXT_KEYWORDS_INPUT), (List)advancedSearchFieldList);
                StringQuery q = (StringQuery)ResourceFactory.createResource((String)(this.getDefaultNamespace() + this.getPortletName()), (String)("queryID_" + distinct_submit_query++), StringQuery.class);
                q.setRequest(query);
                boolean isExpressedInNativeSyntax = false;
                if (req.getParameter("searchBox_nativeSyntax") != null && req.getParameter("searchBox_nativeSyntax").equals("on")) {
                    logger.debug((Object)"Request will be parsed as native");
                    isExpressedInNativeSyntax = true;
                }
                req.getPortletSession().setAttribute(NATIVE_SYNTAX, (Object)isExpressedInNativeSyntax);
                Annotation annot = AnnotationFactory.createAndLinkAnnotation((Resource)q);
                JenaPoKHelper h = new JenaPoKHelper((PieceOfKnowledge)annot);
                if (isExpressedInNativeSyntax) {
                    h.createLitStat(q.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#isExpressedWith", req.getParameter(SEARCH_SERVICE));
                    logger.debug((Object)("Request parsed for " + req.getParameter(SEARCH_SERVICE) + " engine"));
                } else {
                    h.createLitStat(q.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#isExpressedWith", "lucene");
                    logger.debug((Object)"Request parsed with default syntax");
                }
                if (form_action.compareToIgnoreCase("doSearch") == 0) {
                    logger.info((Object)("Query sent to index : " + q.getRequest()));
                    this.doSearch(req, res, q);
                } else if (form_action.compareToIgnoreCase("doSaveQuery") == 0) {
                    this.doSave(req, res, q);
                }
            } else if (form_name.equals("reset")) {
                logger.debug((Object)"Do 'reset' action.");
                req.getPortletSession().removeAttribute(LAST_TEXT_KEYWORDS_INPUT);
                req.getPortletSession().removeAttribute("AdvancedSearchFieldBeanList");
                ResultSet emptyRS = (ResultSet)ResourceFactory.createResource((String)"AdvancedSearchPortlet_ResultSet", (String)("" + System.currentTimeMillis()), ResultSet.class);
                this.sendEventForAction(RESET_ACTION, (Resource)emptyRS, res);
            }
        }
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        if (request.getParameter("page_part").equals("advancedSearchField")) {
            LinkedList fieldList = (LinkedList)request.getPortletSession().getAttribute("AdvancedSearchFieldBeanList");
            if (fieldList == null) {
                fieldList = new LinkedList();
            }
            request.setAttribute("advancedSearchStructure", fieldList);
            request.setAttribute("boolean_conditions", (Object)advanced_search_conf.getBooleanConditions());
            request.setAttribute("advanced_search_fields", (Object)advanced_search_conf.getAdvancedSearchFields());
            response.setContentType(HTML_CONTENT_TYPE);
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("advanced_search_field_page_url"));
            rd.include((PortletRequest)request, (PortletResponse)response);
        } else if (request.getParameter("page_part").equals("nativeSyntax")) {
            Analyser translatorToUse = (Analyser)translators.get(request.getParameter("searchServiceInput"));
            logger.info((Object)(request.getParameter("searchServiceInput") + " translator is used."));
            List fieldList = AdvancedSearchPortlet.getFieldListFromParameters((Map)request.getParameterMap());
            String query = AdvancedSearchPortlet.generateQuery((String)request.getParameter(TEXT_KEYWORDS_INPUT), (List)fieldList);
            StringQuery q = (StringQuery)ResourceFactory.createResource((String)(this.getDefaultNamespace() + this.getPortletName()), (String)("queryID_" + distinct_submit_query++), StringQuery.class);
            q.setRequest(query);
            ProcessArgs translatorArgs = new ProcessArgs();
            translatorArgs.setResource((Resource)q);
            if (translatorToUse != null) {
                try {
                    ProcessReturn translatorResult = translatorToUse.process(translatorArgs);
                    StringQuery resultQuery = (StringQuery)translatorResult.getResource();
                    logger.info((Object)("query translated : " + resultQuery.getRequest()));
                    response.setContentType(TEXT_CONTENT_TYPE);
                    response.getWriter().print(resultQuery.getRequest());
                }
                catch (Exception pe) {
                    logger.error((Object)pe);
                    response.setProperty(SEARCH_ERROR, pe.getMessage());
                }
            } else {
                response.setContentType(TEXT_CONTENT_TYPE);
                response.getWriter().print(query);
            }
            response.getWriter().flush();
        } else if (request.getParameter("page_part").equals("advancedSearchNewLine")) {
            boolean launchFormAfter = false;
            if (request.getParameter("launchFormAfter") != null) {
                launchFormAfter = Boolean.parseBoolean(request.getParameter("launchFormAfter"));
            }
            int position = 0;
            if (request.getParameter("position") != null) {
                position = Integer.parseInt(request.getParameter("position"));
            }
            if (request.getParameter("booleanCondition") != null && request.getParameter("fieldName") != null && request.getParameter("fieldValue") != null && request.getParameter("fieldListValue") != null && request.getParameter("fieldBeforeValue") != null && request.getParameter("fieldAfterValue") != null) {
                String value;
                TextFieldBean newLine;
                String booleanCondition = request.getParameter("booleanCondition");
                String[] fieldTypeAndName = request.getParameter("fieldName").split(":");
                String fieldType = fieldTypeAndName[0];
                String fieldName = fieldTypeAndName[1];
                if (fieldType.equals("date")) {
                    String beforeValue = "";
                    if (request.getParameter("fieldBeforeValue") != null && !request.getParameter("fieldBeforeValue").isEmpty()) {
                        beforeValue = request.getParameter("fieldBeforeValue");
                    }
                    String afterValue = "";
                    if (request.getParameter("fieldAfterValue") != null && !request.getParameter("fieldAfterValue").isEmpty()) {
                        afterValue = request.getParameter("fieldAfterValue");
                    }
                    newLine = new DateFieldBean(position, booleanCondition, fieldName, beforeValue, afterValue);
                } else if (fieldType.equals("list")) {
                    value = "";
                    if (request.getParameter("fieldListValue") != null && !request.getParameter("fieldListValue").isEmpty()) {
                        value = request.getParameter("fieldListValue");
                    }
                    newLine = new TextFieldBean(position, AdvancedSearchFieldBean.Types.LIST_TYPE, booleanCondition, fieldName, value);
                } else {
                    value = "";
                    if (request.getParameter("fieldValue") != null && !request.getParameter("fieldValue").isEmpty()) {
                        value = request.getParameter("fieldValue");
                    }
                    newLine = new TextFieldBean(position, AdvancedSearchFieldBean.Types.TEXT_TYPE, booleanCondition, fieldName, value);
                }
                logger.info((Object)("New field added : " + newLine));
                request.setAttribute("advancedSearchNewLine", (Object)newLine);
                if (request.getPortletSession().getAttribute("AdvancedSearchFieldBeanList") != null) {
                    ((List)request.getPortletSession().getAttribute("AdvancedSearchFieldBeanList")).add(newLine);
                } else {
                    LinkedList<TextFieldBean> fieldList = new LinkedList<TextFieldBean>();
                    fieldList.add(newLine);
                    request.getPortletSession().setAttribute("AdvancedSearchFieldBeanList", fieldList);
                }
            }
            request.setAttribute("boolean_conditions", (Object)advanced_search_conf.getBooleanConditions());
            request.setAttribute("advanced_search_fields", (Object)advanced_search_conf.getAdvancedSearchFields());
            request.setAttribute("launchFormAfter", (Object)launchFormAfter);
            response.setContentType(HTML_CONTENT_TYPE);
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("advanced_search_new_field_page_url"));
            rd.include((PortletRequest)request, (PortletResponse)response);
        } else if (request.getParameter("page_part").equals("advancedSearchRemoveLine")) {
            response.setContentType(HTML_CONTENT_TYPE);
            int position = Integer.parseInt(request.getParameter("position"));
            logger.info((Object)("Removing field at position :" + position));
            ((List)request.getPortletSession().getAttribute("AdvancedSearchFieldBeanList")).remove(position);
            request.setAttribute("advancedSearchStructure", request.getPortletSession().getAttribute("AdvancedSearchFieldBeanList"));
            request.setAttribute("boolean_conditions", (Object)advanced_search_conf.getBooleanConditions());
            request.setAttribute("advanced_search_fields", (Object)advanced_search_conf.getAdvancedSearchFields());
            response.setContentType(HTML_CONTENT_TYPE);
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(this.getInitParameter("advanced_search_field_page_url"));
            rd.include((PortletRequest)request, (PortletResponse)response);
        } else if (request.getParameter("page_part").equals("generateQuery")) {
            List fieldList = AdvancedSearchPortlet.getFieldListFromParameters((Map)request.getParameterMap());
            String query = AdvancedSearchPortlet.generateQuery((String)request.getParameter(TEXT_KEYWORDS_INPUT), (List)fieldList);
            response.setContentType(TEXT_CONTENT_TYPE);
            response.getWriter().print(query);
            response.getWriter().flush();
        } else if (request.getParameter("page_part").equals("getSelectValues")) {
            response.setContentType(TEXT_CONTENT_TYPE);
            String id = request.getParameter("id");
            Map valuesMap = id.equals("format") ? advanced_search_conf.getFormatValues() : (id.equals("language") ? advanced_search_conf.getLanguageValues() : new HashMap());
            StringBuilder responseSB = new StringBuilder();
            responseSB.append("[{\"optionValue\": \"\", \"optionDisplay\": \"-\"},");
            for (Map.Entry entry : valuesMap.entrySet()) {
                responseSB.append('{');
                responseSB.append("\"optionValue\": ");
                responseSB.append("\"").append((String)entry.getKey()).append("\"");
                responseSB.append(", \"optionDisplay\": ");
                responseSB.append("\"").append(ResourceBundle.getBundle("search_portlet", request.getLocale()).getString((String)entry.getValue())).append("\"");
                responseSB.append("},");
            }
            responseSB.deleteCharAt(responseSB.length() - 1);
            responseSB.append(']');
            response.getWriter().print(responseSB.toString());
            response.getWriter().flush();
        }
    }

    public void processEvent(EventRequest request, EventResponse response) throws PortletException, IOException {
        long start = System.currentTimeMillis();
        String reaction = this.getReaction(request.getEvent().getQName()).getLocalPart();
        if (reaction.equals(NEXT_DOCUMENTS_REACTION)) {
            if (request.getEvent().getValue() != null && request.getEvent().getValue() instanceof PieceOfKnowledge) {
                PieceOfKnowledge pok = (PieceOfKnowledge)request.getEvent().getValue();
                AdvancedSelector rdfSelector = RDFSelectorFactory.getSelector((boolean)true, (String[])new String[0]);
                Statements map = rdfSelector.searchFor((Resource)pok, new String[0]);
                String queryURI = null;
                queryURI = (String)map.getTypedValue(pok.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasOrderedQuery", String.class);
                logger.debug((Object)("Map of pok : " + map));
                logger.debug((Object)("QueryID : " + queryURI));
                SearchArgs userSearchArg = (SearchArgs)request.getPortletSession().getAttribute(USER_LAST_SEARCH);
                if (userSearchArg != null && queryURI != null && userSearchArg.getQuery().getUri().equals(queryURI)) {
                    userSearchArg.setOffset(Integer.valueOf(Integer.parseInt((String)((IPredicateValuePairs)((Map.Entry)map.entrySet().iterator().next()).getValue()).getValue(OFFSET_PROPERTY))));
                    userSearchArg.setLimit(Integer.valueOf(Integer.parseInt((String)((IPredicateValuePairs)((Map.Entry)map.entrySet().iterator().next()).getValue()).getValue(LIMIT_PROPERTY))));
                    logger.info((Object)(request.getPortletSession().getAttribute(LAST_SEARCH_SERVICE) + " searcher is used : updating a resultSet, offset:" + userSearchArg.getOffset() + " limit:" + userSearchArg.getLimit()));
                    try {
                        SearchReturn searchResult = this.launchQuery((PortletRequest)request, (PortletResponse)response, userSearchArg);
                        logger.info((Object)searchResult.getResultSet());
                        this.sendEventForAction(NEXT_DOCUMENTS_ACTION, (Resource)searchResult.getResultSet(), response);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        response.setRenderParameter(SEARCH_ERROR, e.getMessage());
                    }
                }
            }
        } else if (reaction.equals(FACET_SELECTION_REACTION) || reaction.equals(FACET_UNSELECTION_REACTION)) {
            logger.info((Object)"Facet selection event.");
            if (request.getEvent().getValue() == null || !(request.getEvent().getValue() instanceof PieceOfKnowledge)) {
                logger.warn((Object)"No value in facet selection event, or it's not a valid PoK.");
            } else {
                PieceOfKnowledge pok = (PieceOfKnowledge)request.getEvent().getValue();
                AdvancedSelector rdfSelector = RDFSelectorFactory.getSelector((boolean)true, (String[])new String[0]);
                Statements map = rdfSelector.searchFor((Resource)pok, new String[0]);
                String queryURI = (String)map.getTypedValue(pok.getUri(), "http://weblab.ow2.org/core/1.2/ontology/retrieval#hasOrderedQuery", String.class);
                logger.debug((Object)("Map of pok : " + map));
                logger.debug((Object)("QueryID : " + queryURI));
                SearchArgs userSearchArg = (SearchArgs)request.getPortletSession().getAttribute(USER_LAST_SEARCH);
                if (userSearchArg == null || queryURI == null || !userSearchArg.getQuery().getUri().equals(queryURI)) {
                    logger.warn((Object)"userSearchArg is null or problem with queryURI.");
                    logger.debug((Object)("userSearchArg=" + userSearchArg + "\nQueryID=" + queryURI));
                } else {
                    logger.debug((Object)("User queryID: " + userSearchArg.getQuery().getUri()));
                    if (!(userSearchArg.getQuery() instanceof StringQuery)) {
                        logger.error((Object)"Could not filter on non StringQuery requests.");
                    } else {
                        String filterValue = (String)map.getTypedValue(pok.getUri(), this.getInitParameter("facetFilterQueryProperty"), String.class);
                        StringQuery lastSearchQuery = (StringQuery)userSearchArg.getQuery();
                        String lastSearch = lastSearchQuery.getRequest();
                        String booleanOperator = filterValue.contains("AND") ? "AND" : "NOT";
                        String fieldName = filterValue.replaceFirst(booleanOperator, "").split(":")[0].trim();
                        String fieldValue = filterValue.replaceFirst(booleanOperator, "").split(":")[1].trim();
                        List fieldList = request.getPortletSession().getAttribute("AdvancedSearchFieldBeanList") != null ? (List)request.getPortletSession().getAttribute("AdvancedSearchFieldBeanList") : new LinkedList();
                        TextFieldBean facetFilterField = new TextFieldBean(-1, AdvancedSearchFieldBean.Types.TEXT_TYPE, booleanOperator, fieldName, fieldValue);
                        if (reaction.equals(FACET_SELECTION_REACTION)) {
                            lastSearchQuery.setRequest("(" + lastSearch + ") " + filterValue);
                            fieldList.add(facetFilterField);
                        } else if (reaction.equals(FACET_UNSELECTION_REACTION)) {
                            lastSearchQuery.setRequest(lastSearch.replaceFirst("\\(", "").replaceFirst("\\)\\s*" + Pattern.quote(filterValue) + "($|\\s*\\))", "$1"));
                            Iterator fieldsIterator = fieldList.iterator();
                            while (fieldsIterator.hasNext()) {
                                AdvancedSearchFieldBean field = (AdvancedSearchFieldBean)fieldsIterator.next();
                                if (!(field instanceof TextFieldBean) || !field.getBooleanCondition().equals(booleanOperator) || !field.getFieldName().equals(fieldName) || !((TextFieldBean)field).getValue().equals(fieldValue)) continue;
                                fieldsIterator.remove();
                            }
                        }
                        request.getPortletSession().setAttribute("AdvancedSearchFieldBeanList", fieldList);
                        userSearchArg.setOffset(Integer.valueOf(0));
                        userSearchArg.setLimit(Integer.valueOf(10));
                        userSearchArg.setQuery((Query)lastSearchQuery);
                        logger.info((Object)(request.getPortletSession().getAttribute(LAST_SEARCH_SERVICE) + " searcher is used, create a facet filter: " + lastSearchQuery.getRequest()));
                        try {
                            SearchReturn searchResult = this.launchQuery((PortletRequest)request, (PortletResponse)response, userSearchArg);
                            this.sendEventForAction(SEARCH_ACTION, (Resource)searchResult.getResultSet(), response);
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                            response.setRenderParameter(SEARCH_ERROR, e.getMessage());
                        }
                    }
                }
            }
        }
        logger.info((Object)("processEvent response time :" + Long.toString(System.currentTimeMillis() - start)));
    }

    protected void doSave(ActionRequest req, ActionResponse res, StringQuery q) {
        logger.info((Object)"Saving query...");
        this.sendEventForAction(SAVE_QUERY_ACTION, (Resource)q, res);
        logger.debug((Object)"Save Query Event sent.");
    }

    protected void doSearch(ActionRequest req, ActionResponse res, StringQuery q) {
        logger.info((Object)"Sending query to search engine...");
        try {
            SearchArgs args = new SearchArgs();
            args.setLimit(Integer.valueOf(10));
            args.setOffset(Integer.valueOf(0));
            args.setQuery((Query)q);
            if (req.getParameter(SEARCH_SERVICE) != null) {
                logger.debug((Object)("Sending to search service " + req.getParameter(SEARCH_SERVICE)));
                try {
                    WebLabMarshaller marsh_l = new WebLabMarshaller();
                    StringWriter sw_l = new StringWriter();
                    marsh_l.marshalResource((Resource)args.getQuery(), (Writer)sw_l);
                    logger.debug((Object)("with request :" + sw_l.toString()));
                    marsh_l = null;
                    sw_l = null;
                }
                catch (WebLabCheckedException e) {
                    logger.debug((Object)"Debug marshalling for request failed");
                }
                req.getPortletSession().setAttribute(LAST_SEARCH_SERVICE, (Object)req.getParameter(SEARCH_SERVICE));
            }
            SearchReturn searchResult = this.launchQuery((PortletRequest)req, (PortletResponse)res, args);
            logger.debug((Object)"Results received.");
            if (searchResult != null) {
                if (USE_REDIRECTION) {
                    logger.debug((Object)("sendEventForActionAndRedirect " + SEARCH_ACTION + " to share results."));
                    this.sendEventForActionAndRedirect(SEARCH_ACTION, (Resource)searchResult.getResultSet(), res);
                } else {
                    logger.debug((Object)("sendEventForAction " + SEARCH_ACTION + " to share results."));
                    this.sendEventForAction(SEARCH_ACTION, (Resource)searchResult.getResultSet(), res);
                }
            } else {
                logger.error((Object)"Search results are nempty or null.");
            }
        }
        catch (PortletException e) {
            logger.error((Object)e);
            res.setRenderParameter(SEARCH_ERROR, e.getMessage());
        }
        catch (IOException e) {
            logger.error((Object)e);
            res.setRenderParameter(SEARCH_ERROR, e.getMessage());
        }
    }

    protected SearchReturn launchQuery(PortletRequest req, PortletResponse res, SearchArgs args) throws PortletException {
        SearchReturn searchResult = null;
        req.getPortletSession().setAttribute(USER_LAST_SEARCH, (Object)args);
        StringQuery q = (StringQuery)args.getQuery();
        if (q.getRequest() != null && q.getRequest() != "") {
            try {
                Searcher searcherToUse = (Searcher)searchers.get(req.getPortletSession().getAttribute(LAST_SEARCH_SERVICE));
                if (searcherToUse == null) {
                    searcherToUse = (Searcher)searchers.get(searchers.keySet().iterator().next());
                }
                if (searcherToUse == null) {
                    throw new InvalidParameterException("Searcher is null.");
                }
                String usageContext = (String)usageContexts.get(req.getParameter(SEARCH_SERVICE));
                if (usageContext != null && !usageContext.isEmpty()) {
                    args.setUsageContext(usageContext);
                    logger.info((Object)("Usage context: " + usageContext + " is used."));
                }
                logger.trace((Object)("searcherToUse=" + searcherToUse));
                logger.trace((Object)"Before querying searcher");
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("SOAP query sent: " + ResourceUtil.saveToXMLString((Resource)args.getQuery())));
                    logger.trace((Object)("Usage context: " + args.getUsageContext()));
                }
                searchResult = searcherToUse.search(args);
                req.getPortletSession().setAttribute(LAST_TEXT_KEYWORDS_INPUT, (Object)req.getParameter(TEXT_KEYWORDS_INPUT));
                req.getPortletSession().setAttribute(USER_LAST_SEARCH, (Object)args);
            }
            catch (Exception e) {
                logger.error((Object)("Error during search: " + e.getMessage()));
                e.printStackTrace();
                throw new PortletException("Error during search.", (Throwable)e);
            }
        } else {
            logger.error((Object)"Empty query?!");
            throw new PortletException("Empty query?!");
        }
        return searchResult;
    }

    protected static List<AdvancedSearchFieldBean> getFieldListFromParameters(Map<String, String[]> parameters) {
        LinkedList<AdvancedSearchFieldBean> advancedSearchFieldList = new LinkedList<AdvancedSearchFieldBean>();
        Pattern p = Pattern.compile("advanced_booleanCondition_(\\d+)");
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            if (!entry.getKey().startsWith("advanced_booleanCondition_")) continue;
            Matcher m = p.matcher(entry.getKey());
            m.matches();
            int position = Integer.parseInt(m.group(1));
            if (parameters.get("advanced_fieldName_" + position) != null && parameters.get("advanced_fieldName_" + position)[0] != null && !parameters.get("advanced_fieldName_" + position)[0].isEmpty()) {
                String value;
                TextFieldBean field;
                String[] fieldTypeAndName = parameters.get("advanced_fieldName_" + position)[0].split(":");
                String fieldType = fieldTypeAndName[0];
                String fieldName = fieldTypeAndName[1];
                boolean addField = true;
                if (fieldType.equals("date")) {
                    String beforeValue = DATE_FORMAT.format(OLDEST_DATE);
                    if (parameters.get("advanced_fieldBeforeValue_" + position) != null && !parameters.get("advanced_fieldBeforeValue_" + position)[0].isEmpty()) {
                        beforeValue = parameters.get("advanced_fieldBeforeValue_" + position)[0];
                    }
                    String afterValue = DATE_FORMAT.format(Calendar.getInstance().getTime());
                    if (parameters.get("advanced_fieldAfterValue_" + position) != null && !parameters.get("advanced_fieldAfterValue_" + position)[0].isEmpty()) {
                        afterValue = parameters.get("advanced_fieldAfterValue_" + position)[0];
                    }
                    field = new DateFieldBean(position, entry.getValue()[0], fieldName, beforeValue, afterValue);
                } else if (fieldType.equals("list")) {
                    value = "";
                    if (parameters.get("advanced_fieldListValue_" + position) != null && !parameters.get("advanced_fieldListValue_" + position)[0].isEmpty()) {
                        value = parameters.get("advanced_fieldListValue_" + position)[0];
                    } else {
                        addField = false;
                    }
                    field = new TextFieldBean(position, AdvancedSearchFieldBean.Types.LIST_TYPE, entry.getValue()[0], fieldName, value);
                } else {
                    value = "";
                    if (parameters.get("advanced_fieldValue_" + position) != null && !parameters.get("advanced_fieldValue_" + position)[0].isEmpty()) {
                        value = parameters.get("advanced_fieldValue_" + position)[0];
                    } else {
                        addField = false;
                    }
                    field = new TextFieldBean(position, AdvancedSearchFieldBean.Types.TEXT_TYPE, entry.getValue()[0], fieldName, value);
                }
                if (!addField) continue;
                advancedSearchFieldList.add((AdvancedSearchFieldBean)field);
                continue;
            }
            logger.error((Object)("Name field was null for element " + position));
        }
        Collections.sort(advancedSearchFieldList);
        return advancedSearchFieldList;
    }

    protected static String generateQuery(String textQuery, List<AdvancedSearchFieldBean> advancedSearchFieldList) {
        if (textQuery.isEmpty() && advancedSearchFieldList.size() > 0) {
            advancedSearchFieldList.get(0).setBooleanCondition("");
        }
        StringBuilder generatedQuery = new StringBuilder();
        for (AdvancedSearchFieldBean advancedSearchFieldBean : advancedSearchFieldList) {
            if (advancedSearchFieldBean.getBooleanCondition() != null && !advancedSearchFieldBean.getBooleanCondition().isEmpty()) {
                generatedQuery.append(advancedSearchFieldBean.getBooleanCondition()).append(" ");
            }
            generatedQuery.append(advancedSearchFieldBean.getFieldName()).append(":");
            if (advancedSearchFieldBean instanceof TextFieldBean) {
                generatedQuery.append('(');
                generatedQuery.append(((TextFieldBean)advancedSearchFieldBean).getValue());
                generatedQuery.append(')');
            } else if (advancedSearchFieldBean instanceof DateFieldBean) {
                generatedQuery.append('[');
                generatedQuery.append(((DateFieldBean)advancedSearchFieldBean).getBeforeValue());
                generatedQuery.append(' ');
                generatedQuery.append(((DateFieldBean)advancedSearchFieldBean).getAfterValue());
                generatedQuery.append(']');
            }
            generatedQuery.append(' ');
        }
        if (generatedQuery.length() > 0) {
            generatedQuery.deleteCharAt(generatedQuery.length() - 1);
        }
        if (generatedQuery.length() == 0) {
            return textQuery;
        }
        if (textQuery.length() == 0) {
            return generatedQuery.toString();
        }
        return '(' + textQuery + ')' + ' ' + generatedQuery.toString();
    }

    static {
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        OLDEST_DATE = new Date(0L);
    }
}

