jQuery.advancedSearchField = {
	lastSearch_var : '',
	new_search_var : true,
	resourceURL_nativeSyntax_var : '',
	resourceURL_advancedSearchField_addField_var : '',
	resourceURL_generateQuery_var : '',
	resourceURL_getSelectValues_var : '',
	locale_var : '',
	lastAdvancedSearchFieldAdded : '',
	displayCheckingPopup_var : true,
	resourceURL_removeField_var:'',

	initAdvancedSearchPortlet : function(resourceURL_advancedSearchField,
			resourceURL_advancedSearchField_addField,
			resourceURL_generateQuery, resourceURL_getSelectValues, lastSearch,
			new_search, nativeSyntax, resourceURL_nativeSyntax, locale, displayCheckingPopup, resourceURL_removeField, currentServiceNativeSyntaxe, displayNativeSyntax) {
		
		jQuery(document).ready(function() {
			
			// init search services list only if the list size is > 1
			if (jQuery("#searchServiceInput").children().length > 1)
				MSDropDown.init('#searchServiceInput');
			
				// init advanced search fields
				jQuery("#advancedSearchField").load(
					resourceURL_advancedSearchField,
					function(responseText, textStatus,
							XMLHttpRequest) {
						jQuery("#advanced_fieldBeforeValue")
								.datepicker(
										jQuery.datepicker.regional[locale]);
						jQuery("#advanced_fieldAfterValue")
								.datepicker(
										jQuery.datepicker.regional[locale]);
					}
				);
			if (!currentServiceNativeSyntaxe) {
				// init native syntax checkbox
				jQuery("#searchBox_nativeSyntax").attr('checked', nativeSyntax);
				
				jQuery.advancedSearchField.displayAdvancedSearchBlock();
			}
			// init key pressed drop
			jQuery("#searchServiceInput_ms_child").children().click(function() {
				if (advancedSearchField_serviceNativeSyntaxeTab[jQuery(this).attr("value")] == true) {
					jQuery('#searchBox_nativeSyntax').attr('checked', true);
					jQuery('#advancedSearch_checkBox_div').hide();
					jQuery.advancedSearchField.changeNativeSyntaxCheckBox();
					
				} else if  (advancedSearchField_serviceNativeSyntaxeTab[jQuery(this).attr("value")] != jQuery('#searchBox_nativeSyntax').is(':checked')) {
					  if (nativeSyntax && displayNativeSyntax) {
						  jQuery('#advancedSearch_checkBox_div').show();
					  }
					  if (jQuery('#searchBox_nativeSyntax').is(':checked')) {
						  jQuery('#searchBox_nativeSyntax').attr('checked', false);
					  } else {
						  jQuery('#searchBox_nativeSyntax').attr('checked', true);
					  }
					  
					  jQuery.advancedSearchField.changeNativeSyntaxCheckBox();
				  }
			});
			
			// init key pressed events for search field
			jQuery("#advancedSearchBox_input").keypress(
				function(e) {
					jQuery.advancedSearchField
							.searchFieldKeyPressed(e);
				}
			);
			
			// init local var
			lastSearch_var = lastSearch;
			new_search_var = new_search;
			resourceURL_nativeSyntax_var = resourceURL_nativeSyntax;
			resourceURL_advancedSearchField_addField_var = resourceURL_advancedSearchField_addField;
			resourceURL_generateQuery_var = resourceURL_generateQuery;
			resourceURL_getSelectValues_var = resourceURL_getSelectValues;
			locale_var = locale;
			displayCheckingPopup_var = displayCheckingPopup;
			resourceURL_removeField_var = resourceURL_removeField;
		});
	},

	initAdvancedSearchFieldBlock : function() {
		// init key pressed events for advanced search field
		jQuery("#advanced_booleanCondition").keypress(function(e) {
			jQuery.advancedSearchField.advancedFieldKeyPressed(e);
		});
		jQuery("#advanced_fieldName").keypress(function(e) {
			jQuery.advancedSearchField.advancedFieldKeyPressed(e);
		});
		jQuery("#advanced_fieldValue").keypress(function(e) {
			jQuery.advancedSearchField.advancedFieldKeyPressed(e);
		});
		jQuery("#advanced_fieldBeforeValue").keypress(function(e) {
			jQuery.advancedSearchField.advancedFieldKeyPressed(e);
		});
		jQuery("#advanced_fieldAfterValue").keypress(function(e) {
			jQuery.advancedSearchField.advancedFieldKeyPressed(e);
		});
	},

	advancedFieldKeyPressed : function(charCode) {
		if (charCode.which == 13) {
			jQuery.advancedSearchField.addAdvancedSearchField();
		}
	},

	searchFieldKeyPressed : function(charCode) {
		if (charCode.which == 13) {
			jQuery.advancedSearchField.checkAddingAdvancedSearchfields();
		}
	},

	addAdvancedSearchField : function() {
		jQuery.advancedSearchField.addAdvancedSearchField(false);
	},

	addAdvancedSearchField : function(launchFormAfter) {
		// Clear text search field if necessary
		if (new_search_var)
			jQuery.advancedSearchField.clearSearchField();

		var booleanCondition = jQuery('#advanced_booleanCondition');
		var name = jQuery('#advanced_fieldName');
		var textValue = jQuery('#advanced_fieldValue');
		var listValue = jQuery('#advanced_fieldListValue');
		var dateBeforeValue = jQuery('#advanced_fieldBeforeValue');
		var dateAfterValue = jQuery('#advanced_fieldAfterValue');

		var tableau = jQuery.advancedSearchField.extractFieldTypeAndName(name
				.val());
		var fieldType = tableau[0];
		var fieldName = tableau[1];

		if (name.val() != ''
				&& (
					(fieldType == 'text' && textValue.val() != '')
					|| (fieldType == 'list' && listValue.val() != '')
					|| (fieldType == 'date' && (dateBeforeValue.val() != '' || dateAfterValue.val() != ''))
					)) {
			var position = 0;
			if (!isNaN(jQuery("#advancedSearch_fieldListSize").val())) {
				position = jQuery("#advancedSearch_fieldListSize").val();
				var newPosition = +jQuery("#advancedSearch_fieldListSize")
						.val() + 1;
				jQuery("#advancedSearch_fieldListSize").val(newPosition);
			}

			var url = resourceURL_advancedSearchField_addField_var
				.replace("toBeChanged_position", encodeURIComponent(position))
				.replace("toBeChanged_booleanCondition", encodeURIComponent(booleanCondition.val()))
				.replace("toBeChanged_fieldName", encodeURIComponent(name.val()))
				.replace("toBeChanged_fieldValue", encodeURIComponent(textValue.val()))
				.replace("toBeChanged_fieldBeforeValue", encodeURIComponent(dateBeforeValue.val()))
				.replace("toBeChanged_fieldAfterValue", encodeURIComponent(dateAfterValue.val()))
				.replace("toBeChanged_fieldListValue", encodeURIComponent(listValue.val()))
				.replace("toBeChanged_launchFormAfter", encodeURIComponent(launchFormAfter));

			// Update structure and advanced search field
			jQuery.get(url, function(data) {
				jQuery.advancedSearchField.updateSearchFieldTable(data);
				
				// if field type is not list, test if form must be send
				// In case of lists, form will be send after updateValues method
				if (fieldType != 'list' && eval(launchFormAfter) == true)
					jQuery.advancedSearchField.launchSearchForm();
			});

			// Reset values
			booleanCondition.val('');
			name.val('');
			textValue.val('');
			listValue.val('');
			dateBeforeValue.val('');
			dateAfterValue.val('');
			jQuery(".advanced_fieldDateValues").hide();
			jQuery(".advanced_fieldListValue").hide();
			jQuery(".advanced_fieldValue").show();

			// Hide missing value message
			jQuery("#advanced_missingValueBlock").hide('fast');
		} else {
			jQuery("#advanced_missingValueBlock").show('slow');
			jQuery("#advanced_fieldValue").focus();
		}
	},

	removeAdvancedSearchField : function(fieldIndex) {
		
		//jQuery("#advancedSearchFieldLine_" + fieldIndex).remove();
		var url = resourceURL_removeField_var.replace("toBeChanged_position", encodeURIComponent(fieldIndex));
		jQuery("#advancedSearchField").load(url);
	},

	updateSearchFieldTable : function(data) {
		// Table node is read only in IE6, create a new cell with a new table
		if (jQuery.browser.msie && jQuery.browser.version.number < 7) {
			var newRow = document.getElementById("advancedSearchFieldsTable").insertRow(-1);
			var newCell = newRow.insertCell(-1);
			newCell.innerHTML = "<table style=\"width:100%;\">" + data + "</table>";
		}
		else {
			jQuery("#advancedSearchFieldsTable").append(data);
		}
	},

	clearSearchField : function() {
		var searchFieldValue = jQuery("#advancedSearchBox_input").val();
		if (searchFieldValue == lastSearch_var)
			jQuery("#advancedSearchBox_input").val('');
	},

	clearAllFields : function() {
		// Clear search inputs
		jQuery("#advancedSearchFieldsTable").empty();
		jQuery("#advancedSearch_fieldListSize").val('0');
		jQuery("#advancedSearchBox_input").val('');
		// Clear adding form
		jQuery("#advanced_booleanCondition").val('');
		jQuery("#advanced_fieldName").val('');
		jQuery("#advanced_fieldValue").val('');
		jQuery("#advanced_fieldListValue").val('');
		// Reset form
		jQuery(".advanced_fieldDateValues").hide();
		jQuery(".advanced_fieldListValue").hide();
		jQuery(".advanced_fieldValue").show();
		// Remove messages
		jQuery("#advanced_generatedQuery").hide('fast');
		jQuery("#advanced_missingValueBlock").hide('fast');
		
		jQuery("#advancedSearchResetForm").submit();
	},
	
	changeNativeSyntaxCheckBox : function() {
		if (jQuery('#searchBox_nativeSyntax').is(':checked')) {
			// checkbox popup
//			jQuery.blockUI( {
//				message : jQuery('#advancedSearch_uncheck_question'),
//				css : {
//					width : '275px'
//				}
//			});
//			jQuery('#advancedSearch_uncheck_question_yes').click(function() {
//				jQuery.unblockUI();
				// Clear text search field if necessary
					if (new_search_var)
						jQuery.advancedSearchField.clearSearchField();

					var disabledObjects = jQuery("select:disabled").removeAttr(
							"disabled");
					// Call server to translate query
//					jQuery.post(resourceURL_nativeSyntax_var, jQuery(
//					"#advancedSearchForm").serialize(), function(data) {
//						jQuery("#advancedSearchBox_input").val(data);
//					});
					disabledObjects.attr("disabled", "disabled");
					jQuery.advancedSearchField.displayAdvancedSearchBlock();
//					jQuery('#advancedSearch_uncheck_question_yes').unbind();
//				}
//			);
			jQuery('#advancedSearch_uncheck_question_no').click(function() {
				jQuery.unblockUI();
				jQuery("#searchBox_nativeSyntax").attr('checked', false);
			});
		} else {
			// checkbox popup
//			jQuery.blockUI( {
//				message : jQuery('#advancedSearch_uncheck_question'),
//				css : {
//					width : '275px'
//				}
//			});
//			jQuery('#advancedSearch_uncheck_question_yes').click(function() {
//				jQuery.unblockUI();
				jQuery("#advancedSearchBox_input").val('');
				jQuery.advancedSearchField.displayAdvancedSearchBlock();
				
//			});
//			jQuery('#advancedSearch_uncheck_question_no').click(function() {
//				jQuery.unblockUI();
//				jQuery("#searchBox_nativeSyntax").attr('checked', true);
//				
//			});
		}
		
//	changeNativeSyntaxCheckBox : function() {
//		if (jQuery('#searchBox_nativeSyntax').is(':checked')) {
//			// checkbox popup
//			jQuery.blockUI( {
//				message : jQuery('#advancedSearch_check_question'),
//				css : {
//					width : '275px'
//				}
//			});
//
//			jQuery('#advancedSearch_check_question_yes').click(function() {
//				jQuery.unblockUI();
//
//				// Clear text search field if necessary
//					if (new_search_var)
//						advancedSearchField.clearSearchField();
//
//					var disabledObjects = jQuery("select:disabled").removeAttr(
//							"disabled");
//
//					// Call server to translate query
//					jQuery.post(resourceURL_nativeSyntax_var, jQuery(
//					"#advancedSearchForm").serialize(), function(data) {
//						jQuery("#advancedSearchBox_input").val(data);
//					});
//
//					disabledObjects.attr("disabled", "disabled");
//					advancedSearchField.displayAdvancedSearchBlock();
//					jQuery('#advancedSearch_check_question_yes').unbind();
//				}	
//			);
//			jQuery('#advancedSearch_check_question_no').click(function() {
//				jQuery.unblockUI();
//				jQuery("#searchBox_nativeSyntax").attr('checked', false);
//			});
//		} else {
//			// checkbox popup
//			jQuery.blockUI( {
//				message : jQuery('#advancedSearch_uncheck_question'),
//				css : {
//					width : '275px'
//				}
//			});
//
//			jQuery('#advancedSearch_uncheck_question_yes').click(function() {
//				jQuery.unblockUI();
//				jQuery("#advancedSearchBox_input").val('');
//				advancedSearchField.displayAdvancedSearchBlock();
//			});
//			jQuery('#advancedSearch_uncheck_question_no').click(function() {
//				jQuery.unblockUI();
//				jQuery("#searchBox_nativeSyntax").attr('checked', true);
//			});
//		}
	},
	
	goToSearcherNativeInterface : function() {
		// Call server to translate query and send event
		jQuery("#advanced_form_name").val("goToSearcherNativeInterface");
		
		// Clear text search field if necessary
		if (new_search_var)
			jQuery.advancedSearchField.clearSearchField();
		
		jQuery.advancedSearchField.enableAllDisabledSelect();
		jQuery("#advancedSearchForm").submit();
	},

	displayAdvancedSearchBlock : function() {
		if (jQuery('#searchBox_nativeSyntax').is(':checked')) {
			// Clear advanced search fields and hide them
			jQuery("#advancedSearchFieldsTable").empty();
			jQuery("#advanced_fieldName").val("");
			jQuery("#advanced_fieldValue").val("");
			jQuery("#advanced_fieldListValue").val("");
			jQuery("#advanced_fieldBeforeValue").val("");
			jQuery("#advanced_fieldAfterValue").val("");
			jQuery("#advancedSearchField").slideUp();
		} else
			jQuery("#advancedSearchField").slideDown("slow");
	},

	changeAdvancedFieldValueFieldType : function(fieldId) {
		var fieldNameId = "advanced_fieldName";
		var fieldValueClass = "advanced_fieldValue";
		var fieldListValueClass = "advanced_fieldListValue";
		var fieldDateValueClass = "advanced_fieldDateValues";

		if (fieldId != "") {
			fieldNameId += "_" + fieldId;
			fieldValueClass += "_" + fieldId;
			fieldListValueClass += "_" + fieldId;
			fieldDateValueClass += "_" + fieldId;
		}

		var tableau = jQuery.advancedSearchField
				.extractFieldTypeAndName(jQuery("#" + fieldNameId).val());
		var fieldType = tableau[0];
		var fieldName = tableau[1];

		if (fieldType == 'date') {
			jQuery("." + fieldValueClass).hide();
			jQuery("." + fieldListValueClass).hide();
			jQuery("." + fieldDateValueClass).show();
		} else if (fieldType == 'list') {
			jQuery("." + fieldDateValueClass).hide();
			jQuery("." + fieldValueClass).hide();
			jQuery("." + fieldListValueClass).show();

			jQuery.advancedSearchField.updateValuesList(fieldName, fieldListValueClass, "");
		} else {
			jQuery("." + fieldDateValueClass).hide();
			jQuery("." + fieldListValueClass).hide();
			jQuery("." + fieldValueClass).show();
		}
	},

	updateValuesList : function(fieldName, fieldListValueName, selectedValue, launchFormAfter) {
		jQuery.getJSON(resourceURL_getSelectValues_var, {
			id : fieldName,
			ajax : 'true'
		}, function(j) {
			var optionsTable = document.getElementById(fieldListValueName).options;
			optionsTable.length = 0;
			for ( var i = 0; i < j.length; i++) {
				var option = new Option(j[i].optionDisplay, j[i].optionValue)
				optionsTable[i] = option;
				if (optionsTable[i].value == selectedValue) {
					optionsTable[i].selected = true;
				}
			}
			
			if (eval(launchFormAfter) == true)
				jQuery.advancedSearchField.launchSearchForm();
		})
	},
	
	extractFieldTypeAndName : function(fieldName) {
		var reg = new RegExp(":", "g");
		var tableau = fieldName.split(reg);
		return tableau;
	},

	enableAllDisabledSelect : function() {
		jQuery("select:disabled").removeAttr("disabled");
	},

	getGeneratedQuery : function() {
		// Clear text search field if necessary
		if (new_search_var)
			jQuery.advancedSearchField.clearSearchField();

		var disabledObjects = jQuery("select:disabled").removeAttr("disabled");

		jQuery.post(resourceURL_generateQuery_var,
				jQuery("#advancedSearchForm").serialize(), function(data) {
					jQuery("#advanced_generatedQuery").html(data);
					jQuery("#advanced_generatedQuery").show('slow');
				});

		disabledObjects.attr("disabled", "disabled");
	},

	checkAddingAdvancedSearchfields : function() {
		var booleanCondition = jQuery("#advanced_booleanCondition");
		var name = jQuery("#advanced_fieldName");
		var textValue = jQuery("#advanced_fieldValue");
		var dateBeforeValue = jQuery("#advanced_fieldBeforeValue");
		var dateAfterValue = jQuery("#advanced_fieldAfterValue");
		var listValue = jQuery("#advanced_fieldListValue");
		
		var tableau = jQuery.advancedSearchField.extractFieldTypeAndName(name.val());
		var fieldType = tableau[0];
		var fieldName = tableau[1];

		if (name.val() != ''
			&& ((fieldType == "text" && textValue.val() != '')
			|| (fieldType == "date" && (dateBeforeValue.val() != '' || dateAfterValue.val() != ''))
			|| (fieldType == "list" && listValue.val() != ''))) {
			
			// Test if checking popup is enabled
			if (eval(displayCheckingPopup_var) == true) {
			
				// Advanced search field to add, display popup
				jQuery.blockUI( {
					message : jQuery('#advancedSearch_search_question'),
					css : {
						width : '350px'
					}
				});
	
				// Add meta and search
				jQuery('#advancedSearch_fieldNotAdded_question_addMeta').click(
						function() {
							jQuery.unblockUI();
							jQuery.advancedSearchField.addAdvancedSearchField(true);
						});
	
				// Search without adding meta
				jQuery('#advancedSearch_fieldNotAdded_question_search').click(
						function() {
							jQuery.unblockUI();
							jQuery.advancedSearchField.launchSearchForm();
						});
	
				// Cancel search
				jQuery('#advancedSearch_fieldNotAdded_question_cancel').click(
						function() {
							jQuery.unblockUI();
						});
			} else {
				// If popup is disabled, add meta and search
				jQuery.advancedSearchField.addAdvancedSearchField(true);
			}
		} else {
			// No advanced search field to add, submit form
			jQuery.advancedSearchField.launchSearchForm();
		}
	},
	
	saveQuery : function(){
		jQuery("#advancedSearch_input_action").val("doSaveQuery");
		jQuery.advancedSearchField.checkAddingAdvancedSearchfields();
	},
	
	launchQuery : function(){
		jQuery("#advancedSearch_input_action").val("search");
		jQuery.advancedSearchField.checkAddingAdvancedSearchfields();
	},
	
	launchSearchForm : function() {
		// Test if one field at least is not empty
		var formIsEmpty = true;
		if (jQuery("#advancedSearchBox_input").val() != "")
			formIsEmpty = false;
		
		var fieldsNb = jQuery("#advancedSearch_fieldListSize").val();
		for ( var i = 0; i < fieldsNb; i++) {
			var textValue = jQuery("#advanced_fieldValue_" + i);
			var dateBeforeValue = jQuery("#advanced_fieldBeforeValue_" + i);
			var dateAfterValue = jQuery("#advanced_fieldAfterValue_" + i);
			var listValue = jQuery("#advanced_fieldListValue_" + i);
			
			if (textValue.length > 0 && textValue.val() != "")
				formIsEmpty = false;
			if (dateBeforeValue.length > 0 && dateBeforeValue.val() != "")
				formIsEmpty = false;
			if (dateAfterValue.length > 0 && dateAfterValue.val() != "")
				formIsEmpty = false;
			if (listValue.length > 0 && listValue.val() != null && listValue.val() != "")
				formIsEmpty = false;
		}
		
		if (!formIsEmpty) {
			
			 setTimeout(function() {
				 jQuery(".weblab_portletMsgInfoLoading").removeClass("hidden");}
			 , 2500);
			jQuery.advancedSearchField.enableAllDisabledSelect();
			jQuery("#advancedSearchForm").submit();
		}
		else {
			// checkbox popup
			jQuery.blockUI( {
				message : jQuery('#advancedSearch_empty_form'),
				css : {
					width : '275px'
				}
			});

			jQuery('#advancedSearch_empty_form_ok').click(function() {
				jQuery.unblockUI();
			});
		}
	}
};