<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jstl/fmt_rt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jstl/core_rt" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@page import="org.ow2.weblab.portlet.tool.AdvancedSearchFieldBean"%>

<%-- Enum are not supported by JSTL, so define attributes corresponding to possible values --%>
<% pageContext.setAttribute("text_type", AdvancedSearchFieldBean.Types.TEXT_TYPE); %>
<% pageContext.setAttribute("list_type", AdvancedSearchFieldBean.Types.LIST_TYPE); %>
<% pageContext.setAttribute("date_type", AdvancedSearchFieldBean.Types.DATE_TYPE); %>

<portlet:defineObjects />

<script type="text/javascript">
	jQuery.advancedSearchField.initAdvancedSearchFieldBlock();
</script>

<fmt:setLocale value="${pageContext.request.locale}" />

<fmt:setBundle basename="search_portlet" />

<!-- Advanced search fields -->
<span><fmt:message key="search.advancedSearchFields" /> :</span>

<input type="hidden" id="advancedSearch_fieldListSize" value="${fn:length(advancedSearchStructure)}" />

<table id="advancedSearchFieldsTable" style="width:100%" >
	<c:forEach var="entry" items="${advancedSearchStructure}" varStatus="status" >
		<tr id="advancedSearchFieldLine_${status.index}"
		<c:choose>
			<c:when test="${(status.index%2) == 1}">
				class="portlet-section-body results-row"
			</c:when>
			<c:otherwise>
				class="portlet-section-alternate results-row alt"
			</c:otherwise>
		</c:choose>
		>
			<td class="booleanCondition" >
				<select name="advanced_booleanCondition_${status.index}" id="advanced_booleanCondition_${status.index}" style="width:100%" >
					<c:forEach var="booleanEntry" items="${boolean_conditions}" >
						<option value="${booleanEntry.key}" 
							<c:if test="${booleanEntry.key == entry.booleanCondition}">selected="selected"</c:if>
						>${booleanEntry.value}</option>
					</c:forEach>
				</select>
			</td>
			<td class="fieldName">
				<select name="advanced_fieldName_${status.index}" id="advanced_fieldName_${status.index}" disabled="disabled" style="width: 100%;" 
						onchange="jQuery.advancedSearchField.changeAdvancedFieldValueFieldType('${status.index}');">
					<option value="">-</option>
					<c:forEach var="fieldEntry" items="${advanced_search_fields}" >
						<option value="${fieldEntry.value}:${fieldEntry.key}"
							<c:if test="${fieldEntry.key == entry.fieldName}">
								selected="selected"
								<c:set var="advanced_fieldType" value="${fieldEntry.value}" />
							</c:if>
						>
							<fmt:message key="search.field.${fieldEntry.key}" />
						</option>
					</c:forEach>
				</select>
			</td>
			<td class="fieldValueCell advanced_fieldValue_${status.index}" 
					<c:if test="${entry.type != text_type}">
						style="display:none"
					</c:if>
				>
					
					=
					<input type="text" id="advanced_fieldValue_${status.index}" name="advanced_fieldValue_${status.index}" 
						<c:if test="${entry.type == text_type}">
							value="<c:out value="${entry.value}" escapeXml="true" />"
						</c:if> 
						class="fieldValue" />
			</td>
			<td class="fieldValueCell advanced_fieldListValue_${status.index}" 
					<c:if test="${entry.type != list_type}">
						style="display:none"
					</c:if>
				>
					
					=
					<select id="advanced_fieldListValue_${status.index}" name="advanced_fieldListValue_${status.index}" class="fieldValue" ></select>
					<c:if test="${entry.type == list_type}">
						<script language="Javascript">
							jQuery.advancedSearchField.updateValuesList("${entry.fieldName}", "advanced_fieldListValue_${status.index}", "${entry.value}");
						</script>
					</c:if>
					
			</td>
			<td class="fieldValueCell advanced_fieldDateValues_${status.index}" 
					<c:if test="${entry.type != date_type}">
						style="display:none"
					</c:if>
			>
					<fmt:message key="search.from" />
					<input type="text" id="advanced_fieldBeforeValue_${status.index}" name="advanced_fieldBeforeValue_${status.index}" 
						<c:if test="${entry.type == date_type}">
							value="<c:out value="${entry.beforeValue}" escapeXml="true" />"
						</c:if>
						class="dateFieldValue" />
					<fmt:message key="search.to" />
					<input type="text" id="advanced_fieldAfterValue_${status.index}" name="advanced_fieldAfterValue_${status.index}" 
						<c:if test="${entry.type == date_type}">
							value="<c:out value="${entry.afterValue}" escapeXml="true" />"
						</c:if>
					class="dateFieldValue" />
					<script language="Javascript">
						jQuery("#advanced_fieldBeforeValue_${status.index}").datepicker(jQuery.datepicker.regional[locale_var]);
						jQuery("#advanced_fieldAfterValue_${status.index}").datepicker(jQuery.datepicker.regional[locale_var]);
					</script>
			</td>
			<td style="width:16px;" >
				<div class="advancedSearch_del" 
					 onClick="jQuery.advancedSearchField.removeAdvancedSearchField('${status.index}');" 
					 title="<fmt:message key="search.advanced.remove" />" >
				</div>
			</td>
		</tr>
	</c:forEach>
</table>

<!-- New field -->
<table style="width:100%" >
	<tr class="portlet-section-header results-header" >
		<td class="booleanCondition" >
			<select name="advanced_booleanCondition" id="advanced_booleanCondition" style="width: 100%;" >
				<c:forEach var="entry" items="${boolean_conditions}" >
					<option value="${entry.key}" >${entry.value}</option>
				</c:forEach>
			</select>
		</td>
		<td class="fieldName">
			<select name="advanced_fieldName" id="advanced_fieldName" style="width: 100%;"
					onchange="jQuery.advancedSearchField.changeAdvancedFieldValueFieldType('');" >
				<option value="">-</option>
				<c:forEach var="entry" items="${advanced_search_fields}" >
					<option value="${entry.value}:${entry.key}" >
						<fmt:message key="search.field.${entry.key}" />
					</option>
				</c:forEach>
			</select>
		</td>
		<td class="fieldValueCell advanced_fieldValue" >
				=
				<input type="text" id="advanced_fieldValue" class="fieldValue" />
		</td>
		<td class="fieldValueCell advanced_fieldDateValues" style="display:none;" >
				<fmt:message key="search.from" />
				<input type="text" id="advanced_fieldBeforeValue" class="dateFieldValue" />
				<fmt:message key="search.to" />
				<input type="text" id="advanced_fieldAfterValue" class="dateFieldValue" />
		</td>
		<td class="fieldValueCell advanced_fieldListValue" style="display:none;" >
				=
				<select id="advanced_fieldListValue" class="fieldValue" ></select>
		</td>
		<td style="width:16px;" >
			<div class="advancedSearch_add" 
				onClick="jQuery.advancedSearchField.addAdvancedSearchField();" title="<fmt:message key="search.advanced.add" />" >
			</div>
		</td>
	</tr>
</table>

<div id="advanced_missingValueBlock" class="weblab_portletMsgInfo" style="display:none;" >
	<fmt:message key="search.advanced.missing.value" />
</div>
