/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 *
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of the
 * GNU Lesser General Public License as published by the Free Software Foundation; either version
 * 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.portlet.bean;

/**
 * Bean representing an field in a DocumentLegend. It contains information about
 * the entity that this field represent. display name, type or color.
 * 
 * @author emilien
 * 
 */
public class LegendField {
	private String entityType;
	private String matchedValue;
	private String displayName;
	private String styleColor;
	private String styleClassName;
	private boolean show;

	/**
	 * Public constructor
	 * 
	 * @param entityType
	 *            Entity type (For example
	 *            "http://weblab.eads.com/property/gate/annotation")
	 * @param matchedValue
	 *            value of the entity. (For example "Person")
	 * @param displayName
	 *            value in the legend. (For example "Persons")
	 * @param styleColor
	 *            Color of the entity in the legend.
	 * @param styleClassName
	 *            style class name used for style elements.
	 * @param show
	 *            show entity or not in document using this legend.
	 */
	public LegendField(String entityType, String matchedValue,
			String displayName, String styleColor, String styleClassName,
			boolean show) {
		super();
		this.entityType = entityType;
		this.matchedValue = matchedValue;
		this.displayName = displayName;
		this.styleColor = styleColor;
		this.styleClassName = styleClassName;
		this.show = show;
	}

	/**
	 * Public constructor without parameters.
	 */
	public LegendField() {
//
	}

	/**
	 * Getters and setters
	 */
	public String getEntityType() {
		return this.entityType;
	}

	public void setEntityType(String entityType) {
		this.entityType = entityType;
	}

	public String getMatchedValue() {
		return this.matchedValue;
	}

	public void setMatchedValue(String matchedValue) {
		this.matchedValue = matchedValue;
	}

	public String getDisplayName() {
		return this.displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public String getStyleColor() {
		return this.styleColor;
	}

	public void setStyleColor(String styleColor) {
		this.styleColor = styleColor;
	}

	public String getStyleClassName() {
		return this.styleClassName;
	}

	public void setStyleClassName(String styleClassName) {
		this.styleClassName = styleClassName;
	}

	public boolean isShow() {
		return this.show;
	}

	public void setShow(boolean show) {
		this.show = show;
	}
}