/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 *
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of the
 * GNU Lesser General Public License as published by the Free Software Foundation; either version
 * 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.portlet.bean;

/**
 * Bean class representing a Named Entity A named entity has properties like
 * start and end offset in a text, Value like "Person", URItype like
 * "http://weblab.eads.com/property/gate/annotation" Style class name like
 * "_annotation_gate_person"
 * 
 * @author emilien
 */
public class NamedEntity {

	private int startOffset;
	private int endOffset;
	private String entityLabel;
	private String entityURI;
	private String entityClassURI;
	private boolean isCandidate;

	/**
	 * @return the startOffset
	 */
	public int getStartOffset() {
		return this.startOffset;
	}

	/**
	 * @return the isCandidate
	 */
	public boolean isCandidate() {
		return this.isCandidate;
	}

	/**
	 * @param isCandidate
	 *            the isCandidate to set
	 */
	public void setCandidate(boolean isCandidate) {
		this.isCandidate = isCandidate;
	}

	/**
	 * @param startOffset
	 *            the startOffset to set
	 */
	public void setStartOffset(int startOffset) {
		this.startOffset = startOffset;
	}

	/**
	 * @return the endOffset
	 */
	public int getEndOffset() {
		return this.endOffset;
	}

	/**
	 * @param startOffset
	 * @param endOffset
	 * @param entityLabel
	 * @param entityURI
	 */
	public NamedEntity(int startOffset, int endOffset, String entityLabel,
			String entityURI, String entityClassURI, boolean isCandidate) {
		super();
		this.startOffset = startOffset;
		this.endOffset = endOffset;
		this.entityLabel = entityLabel;
		this.entityURI = entityURI;
		this.entityClassURI = entityClassURI;
		this.isCandidate = isCandidate;

	}

	/**
	 * @param endOffset
	 *            the endOffset to set
	 */
	public void setEndOffset(int endOffset) {
		this.endOffset = endOffset;
	}

	/**
	 * @return the entityLabel
	 */
	public String getEntityLabel() {
		return this.entityLabel;
	}

	/**
	 * @param entityLabel
	 *            the entityLabel to set
	 */
	public void setEntityLabel(String entityLabel) {
		this.entityLabel = entityLabel;
	}

	/**
	 * @return the entityURI
	 */
	public String getEntityURI() {
		return this.entityURI;
	}

	/**
	 * @param entityURI
	 *            the entityURI to set
	 */
	public void setEntityURI(String entityURI) {
		this.entityURI = entityURI;
	}

	/**
	 * @return the entityClassURI
	 */
	public String getEntityClassURI() {
		return this.entityClassURI;
	}

	/**
	 * @param entityClassURI
	 *            the entityClassURI to set
	 */
	public void setEntityClassURI(String entityClassURI) {
		this.entityClassURI = entityClassURI;
	}
}
