/**
 * WEBLAB: Service oriented integration platform for media mining and intelligence applications
 *
 * Copyright (C) 2004 - 2009 EADS DEFENCE AND SECURITY SYSTEMS
 * 
 * This library is free software; you can redistribute it and/or modify it under the terms of the
 * GNU Lesser General Public License as published by the Free Software Foundation; either version
 * 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
 * the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

package org.ow2.weblab.portlet.tool;

import java.net.URL;

import javax.xml.namespace.QName;

import org.apache.commons.logging.LogFactory;
import org.ow2.weblab.core.extended.util.ServiceUtil;
import org.ow2.weblab.core.services.ResourceContainer;
import org.ow2.weblab.core.services.ResourceContainer_Service;

public class ResourceContainerUtil {
	/**
	 * Build a Searcher service from WSDL and web Service URL.
	 * @param WSDLLocation
	 * @param searcher_url
	 * @return Searcher web service corresponding urls.
	 */
	public static ResourceContainer getResourceContainerService(URL WSDLLocation, URL resource_container_url) {
		ResourceContainer container;
		
		LogFactory.getLog(ResourceContainerUtil.class).info("Resource Container URL : " + WSDLLocation);
		ResourceContainer_Service container_service = new ResourceContainer_Service(
				WSDLLocation,
				new QName(
						"http://weblab.ow2.org/core/1.2/services",
						"ResourceContainer"));
		container = container_service.getResourceContainerPort();
		ServiceUtil.setEndpointAddress(container, resource_container_url.toString(),"getResource");
		
		return container;
	}
}